<?php
include('../conection.php');
include('./loginsection/loginsessionData.php');
include('./head.php'); 

$query ="SELECT * FROM vipicon WHERE status='1' ORDER BY orderby ASC";
$result = mysqli_query($conn, $query);

$icons = [];
while ($row = mysqli_fetch_assoc($result)) {
    $icons[] = $row;
}
?>

<style>
    body { background:#f8f9fa; }
    .icon-box {
        width: 80px;
        height: 80px;
        background: #fff;
        border-radius: 12px;
        display:flex;
        align-items:center;
        justify-content:center;
        flex-direction:column;
        box-shadow:0 3px 10px rgba(0,0,0,0.15);
        cursor:pointer;
        transition:0.2s;
        padding:10px;
        text-align:center;
    }
    .icon-box:hover {
        transform: scale(1.05);
        background:#eef5ff;
    }
    .icon-tag {
        font-size:12px;
        margin-top:5px;
        word-break: break-word;
    }
    .search-input {
        width:100%;
        padding:12px;
        border-radius:8px;
        border:1px solid #ccc;
        margin-bottom:20px;
    }
</style>

<div class="container py-4">

    <input type="text" id="search" class="search-input" placeholder="Search icons...">

    <div class="row g-3" id="iconContainer">

        <?php foreach ($icons as $icon): ?>
            <div class="col-3 col-md-2 icon-item" data-name="<?php echo strtolower($icon['name']); ?>">
                <div class="icon-box" onclick="copyIcon('<?php echo htmlspecialchars($icon['icontag']); ?>')">
                    <?php echo $icon['icontag']; ?>
                    <div class="icon-tag"><?php echo $icon['name']; ?></div>
                </div>
            </div>
        <?php endforeach; ?>

    </div>
</div>
<script>
    // 🔍 Search filter
    document.getElementById("search").addEventListener("keyup", function () {
        let value = this.value.toLowerCase();
        document.querySelectorAll(".icon-item").forEach(function (icon) {
            let name = icon.getAttribute("data-name");
            icon.style.display = name.includes(value) ? "block" : "none";
        });
    });

    // ✅ Send icon to parent page (hidden input + preview box)
    function copyIcon(tag) {

        // Hidden field in parent
        let inputBox = parent.document.getElementById("icon");

        // Preview box
        let previewBox = parent.document.getElementById("iconPreview");

        if (inputBox) inputBox.value = tag;

        // Show icon inside preview box
        if (previewBox) previewBox.innerHTML = tag;
    }
</script>


