
<?php 



function validateAndUploadFile($file, $oldFile, $name, $folderName, $fileName, $subName) {
    $output = "";
    
    // Use old file if a new file is not provided
    if ($file == '') {
        return $oldFile;
    }
    
    // Get the file extension
    $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
    
    // Allowed extensions for images, documents, and graphic files
    $allowed_extensions = array(
        //"jpg", "jpeg", "png", "gif",    // Image files
        "pdf", "zip",  "rar","doc", "docx", "txt", "ppt", "pptx", "xls", "xlsx", "tiff",  // Document files
        "psd", "ai", "eps", "svg", "cdr", "indd"  // Graphic files
    );
    
    // Validation for allowed extensions
    if (!in_array($extension, $allowed_extensions)) {
        echo "<script>alert('Invalid format. Only specific formats are allowed');</script>";
        return false;
    }
    

    
    // Rename the file
    $rename = md5($name . "_" . $subName);
    $newFileName = $rename . '.' . $extension;
    
    // Move the uploaded file to the directory
    if (!empty($_FILES[$fileName]["tmp_name"])) {
        if (move_uploaded_file($_FILES[$fileName]["tmp_name"], "uploads/" . $folderName . "/" . $newFileName)) {
            return $newFileName;
        } else {
            echo "<script>alert('Failed to upload file');</script>";
            return false;
        }
    }

    return $oldFile;
}



function bindSmsVariables($template, $values) {
    // Ensure values is array
    if (!is_array($values)) {
        $values = [$values];
    }

    // Replace each {#var#} one by one in order
    foreach ($values as $val) {
        $template = preg_replace('/{#var#}/', $val, $template, 1);
    }

    return $template;
}



function validateAndUploadImageWithoutWidthandHeight($imgfile, $oldImage, $name, $folderName, $imageName, $subName) {
    $output = "";
    $imagealter = '';
    
    // Use old image if new image is not provided
    if ($imgfile == '') {
        $imgfile = $oldImage;
    }
    
    // Get the image extension
    $extension = strtolower(pathinfo($imgfile, PATHINFO_EXTENSION));
    
    // Allowed extensions
    $allowed_extensions = array("jpg", "jpeg", "png", "gif");
    
    // Validation for allowed extensions
    if (!in_array($extension, $allowed_extensions)) {
        echo "<script>alert('Invalid format. Only jpg / jpeg/ png /gif format allowed');</script>";
        return false;
    }
    
    // Get image dimensions
    if (!empty($_FILES[$imageName]["name"])) {
        $imagealter = getimagesize($_FILES[$imageName]["tmp_name"]);
    } else {
        $imagealter = getimagesize($folderName . "/" . $oldImage);
    }
    
    if (!$imagealter) {
        echo "<script>alert('Invalid image file');</script>";
        return false;
    }
    
    // Rename the image file
    $rename = md5($name . "_" . $subName);
    $imgnewfile = $rename . '.' . $extension;
    
    // Move the uploaded file to the directory
    if (!empty($_FILES[$imageName]["tmp_name"])) {
        if (move_uploaded_file($_FILES[$imageName]["tmp_name"],  $folderName ."/". $imgnewfile)) {
            return $imgnewfile;
        } else {
            echo "<script>alert('Failed to upload image');</script>";
            return false;
        }
    }
    
    return $oldImage;
}









function validateAndUploadImageWithWidthAndHeight($imgfile, $oldImage, $name, $folderName, $imageName, $subName) {
    $output = "";
    $imagealter = '';
    
    // Use old image if new image is not provided
    if ($imgfile == '') {
        $imgfile = $oldImage;
    }
    
    // Get the image extension
    $extension = strtolower(pathinfo($imgfile, PATHINFO_EXTENSION));
    
    // Allowed extensions
    $allowed_extensions = array("jpg", "jpeg", "png", "gif");
    
    // Validation for allowed extensions
    if (!in_array($extension, $allowed_extensions)) {
        echo "<script>alert('Invalid format. Only jpg / jpeg/ png /gif format allowed');</script>";
        return false;
    }
    
    // Get image dimensions
    if (!empty($_FILES[$imageName]["name"])) {
        $imagealter = getimagesize($_FILES[$imageName]["tmp_name"]);
    } else {
        $imagealter = getimagesize("images/" . $folderName . "/" . $oldImage);
    }
    
    if (!$imagealter) {
        echo "<script>alert('Invalid image file');</script>";
        return false;
    }

    $width = $imagealter[0];  // Image width
    $height = $imagealter[1]; // Image height

    // Check if the image dimensions are exactly 1000px x 300px
    if ($width != 1000 || $height != 300) {
        echo "<script>alert('Image must be exactly 1000px width and 300px height');</script>";
        return false;
    }

    // Rename the image file
    $rename = md5($name . "_" . $subName);
    $imgnewfile = $rename . '.' . $extension;
    
    // Move the uploaded file to the directory
    if (!empty($_FILES[$imageName]["tmp_name"])) {
        if (move_uploaded_file($_FILES[$imageName]["tmp_name"], "images/" . $folderName . "/" . $imgnewfile)) {
            return $imgnewfile;
        } else {
            echo "<script>alert('Failed to upload image');</script>";
            return false;
        }
    }
    
    return $oldImage;
}





function validateAndUploadAudio($audiofile, $oldaudio, $name, $folderName, $audioName, $subName) {
    // Use old audio if new audio is not provided
    if ($audiofile == '') {
        $audiofile = $oldaudio;
    }
    
    // Get the audio file extension
    $extension = strtolower(pathinfo($audiofile, PATHINFO_EXTENSION));
    
    // Allowed extensions
    $allowed_extensions = array("mp3");
    
    // Validation for allowed extensions
    if (!in_array($extension, $allowed_extensions)) {
        echo "<script>alert('Invalid format. Only MP3 format allowed');</script>";
        return false;
    }
    
    // Check if a new file is uploaded
    if (!empty($_FILES[$audioName]["name"])) {
        // Move the uploaded file to the directory
        $rename = md5($name . "_" . $subName);
        $audionewfile = $rename . '.' . $extension;
        
        if (move_uploaded_file($_FILES[$audioName]["tmp_name"],  $folderName . "/" . $audionewfile)) {
            return $audionewfile;
        } else {
            echo "<script>alert('Failed to upload audio');</script>";
            return false;
        }
    }
    
    return $oldaudio;
}




 
function handleMultipleImages($imageFiles, $folderName, $oldImage, $name , $Id) {

	
include('../../conection.php');
    $output = true;
    $count = 0; // Start counting from 0
    foreach($imageFiles['name'] as $key => $image_file) {
        $imgfile = $image_file;
        if($imgfile == ''){
            $imgfile = $oldImage;
        }

        // get the image extension
        $extension = strtolower(pathinfo($imgfile, PATHINFO_EXTENSION));

        // allowed extensions
        $allowed_extensions = array("jpg", "jpeg", "png", "gif");

        // Validation for allowed extensions
        if(!in_array($extension, $allowed_extensions)) {
            echo "<script>alert('Invalid format. Only jpg / jpeg / png / gif format allowed');</script>";
            $output = false;
        } else {
            if(!empty($imageFiles['tmp_name'][$key])) {
                $imagealter = getimagesize($imageFiles['tmp_name'][$key]);
            } else {
                $imagealter = getimagesize("images/".$folderName."/" . $oldImage);
            }
            $image_info = $imagealter;
            $width = $image_info[0];
            $height = $image_info[1];

            // Additional validation for image dimensions (uncomment if needed)
            // if ($width != 2200 && $height != 250) {
            //     echo "<script>alert('Invalid dimensions. Image must be 2200px wide and 250px tall');</script>";
            // } else {
            //     //$IdnameImg =  $student_id;
            // }

            $rename = $name;

            // rename the image file
            $imgnewfile = $rename . "_" . $count . "." . $extension; // Use $count here instead of $key

            // Code for moving image into directory
            move_uploaded_file($imageFiles['tmp_name'][$key], "images/".$folderName."/".$imgnewfile);

            // Increment count after successfully processing the image

			$imageInsert = "INSERT INTO subimage (adsdataId, Imagepath) VALUES ('$Id', '$imgnewfile')";
			$sql = mysqli_query($conn,$imageInsert);

            $count++;
        }
    }

    return $output;
}




function deleteImage($tableName, $columnName, $folderName, $Id, $conn) {

    //include('../../conection.php');

	$deleteImagequery = "SELECT * FROM $tableName WHERE Id='$Id'";
	$imageDeletequery_run = mysqli_query($conn, $deleteImagequery);
	
	if ($imageDeletequery_run) {
		$row = mysqli_fetch_assoc($imageDeletequery_run);
		$imagePath = $folderName."/".$row["$columnName"];
		if (file_exists($imagePath)) {
		if (unlink($imagePath)) 
		{
			
		}
	}
	}

}


function deleteuploadFies($tableName, $columnName, $folderName, $Id) {

    include('../../conection.php');

	$deleteImagequery = "SELECT * FROM $tableName WHERE Id='$Id'";
	$imageDeletequery_run = mysqli_query($conn, $deleteImagequery);
	
	if ($imageDeletequery_run) {
		$row = mysqli_fetch_assoc($imageDeletequery_run);
		$imagePath = "uploads/".$folderName."/".$row["$columnName"];
		if (file_exists($imagePath)) {
		if (unlink($imagePath)) 
		{
			
		}
	}
	}

}




function getdefultConfigValue($conn, string $key, string $valueColumn) {
    // Sanitize inputs to avoid SQL injection
    $key = mysqli_real_escape_string($conn, $key);

    $query = "SELECT `$valueColumn` FROM `defultconfigure` WHERE `ConfigKey` = '$key' LIMIT 1";
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        return $row[$valueColumn];
    }

    return null; // Not found or query failed
}





// Function to generate a colorful icon based on the reviewer's name with inline CSS
function generateIconUrl($name) {
    $colors = [
        'A' => '#FF5733', 'B' => '#33FF57', 'C' => '#3357FF', 'D' => '#FF33A6',
        'E' => '#FF8C33', 'F' => '#A633FF', 'G' => '#33FFF1', 'H' => '#FF3333',
        'I' => '#33FF86', 'J' => '#FFCC33', 'K' => '#FF3399', 'L' => '#33C3FF',
        'M' => '#FF33D2', 'N' => '#FF6600', 'O' => '#FF9999', 'P' => '#FF4C4C',
        'Q' => '#FF8C00', 'R' => '#FFBF00', 'S' => '#FF5733', 'T' => '#33FF57',
        'U' => '#FF3333', 'V' => '#A633FF', 'W' => '#3399FF', 'X' => '#FF33A6',
        'Y' => '#33FFCC', 'Z' => '#FF3333'
    ];

    $first_letter = strtoupper($name[0]);
    $background_color = isset($colors[$first_letter]) ? $colors[$first_letter] : '#000000';

    $icon_svg = <<<SVG
<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg">
    <style>
        .background { fill: $background_color; }
        .letter { font-size: 50px; fill: white; text-anchor: middle; alignment-baseline: middle; font-family: Arial; }
    </style>
    <rect width="100" height="100" class="background"/>
    <text x="50" y="50" class="letter">$first_letter</text>
</svg>
SVG;

    return 'data:image/svg+xml;base64,' . base64_encode($icon_svg);
}



?>