<?php

function getLookUpListByGroupName($groupName, $conn) {

    $select = "SELECT Id, DisplayValue FROM lookupvalues WHERE GroupName = ?";
    $stmt = mysqli_prepare($conn, $select);

    if (!$stmt) {
        return [];
    }

    mysqli_stmt_bind_param($stmt, "s", $groupName);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    $selectList = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $selectList[$row['Id']] = $row['DisplayValue'];
    }

    return $selectList;
}


function getAccIdBySubGrpCode($conn, $accsubgrpcode) {

    $query = "SELECT Id FROM headaccounts WHERE AccSubGrpCode = ?";
    $stmt = mysqli_prepare($conn, $query);

    if (!$stmt) {
        return "";
    }

    mysqli_stmt_bind_param($stmt, "s", $accsubgrpcode);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($row = mysqli_fetch_assoc($result)) {
        return $row['Id'];
    }

    return "";
}
