<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');
?>

<body class="body-area">

    <!-- SIDEBAR -->
    <?php include('../sidebar.php'); ?>

    <!-- NAVBAR -->
    <?php include('../nav.php'); ?>

    <!-- CONTENT AREA -->
    <div class="app-content-area">
        <div class="app-content-wrap">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-xl-12">
                        <div class="page-title-box d-flex-between flex-wrap gap-15">
                            <h1 class="page-title fs-18 lh-1">Room Type Index</h1>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Index</h4>
                            </div>

                            <div class="card-body pt-15">

                                <div class="d-flex justify-content-end mb-3">
                                    <a href="roomtypecreate.php">
                                        <button class="btn btn-primary">Add Room Type</button>
                                    </a>
                                </div>

                                <!-- Fetch Room Types -->
                                <?php
                                $Selectroom = "SELECT * FROM roomtype";
                                $roomquery = mysqli_query($conn, $Selectroom);
                                $count = 0;
                                ?>
                                <div class="table-responsive">
                                <table id="responsivemodal-DataTable" class="table table-bordered text-nowrap w-100">
                                    <thead>
                                        <tr>
                                            <th>SL. No.</th>
                                            <th>Name</th>
                                            <th>Price</th>
                                            <!-- <th>Description</th> -->
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($roomquery as $row): ?>
                                            <tr>
                                                <td><?= ++$count ?></td>
                                                <td><?= $row['name'] ?></td>
                                                <td><?= $row['price'] ?></td>
                                                <!-- <td><?= $row['description'] ?></td> -->
                                                <td>
                                                    <span class="<?= $row['status'] == 1 ? "Active" : "Inactive" ?>">
                                                        <?= $row['status'] == 1 ? "Active" : "Inactive" ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="d-flex gap-2">
                                                        <button class="btn btn-success-light btn-icon viewBtn"
                                                            data-id="<?= $row['Id'] ?>" data-bs-toggle="modal"
                                                            data-bs-target="#viewRoomTypeModal">
                                                            <i class="ri-eye-line"></i>
                                                        </button>

                                                        <a href="roomtypeedit.php?Id=<?= $row['Id'] ?>">
                                                            <button class="btn btn-info-light btn-icon">
                                                                <i class="ri-edit-line"></i>
                                                            </button>
                                                        </a>

                                                        <button type="button" class="btn-icon btn-danger-light deleteBtn"
                                                            data-id="<?php echo $row['Id']; ?>" data-bs-toggle="modal"
                                                            data-bs-target="#deleteConfirmModal">
                                                            <i class="ri-delete-bin-line"></i>
                                                        </button>

                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                                </div>
                                <!-- Delete Confirmation Modal -->
                                <div class="modal fade" id="deleteConfirmModal" tabindex="-1">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">

                                            <div class="modal-header bg-danger text-white">
                                                <h5 class="modal-title">Confirm Delete</h5>
                                                <button type="button" class="btn-close"
                                                    data-bs-dismiss="modal"></button>
                                            </div>

                                            <div class="modal-body">
                                                <p>Are you sure you want to delete this room floor?</p>
                                            </div>

                                            <div class="modal-footer">
                                                <form method="POST" action="code.php" id="deleteForm">
                                                    <input type="hidden" name="Id" id="deleteId">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-bs-dismiss="modal">
                                                        Cancel
                                                    </button>
                                                    <button type="submit" name="deletebtn" class="btn btn-danger">
                                                        Delete
                                                    </button>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>

        <!-- ===================================================== -->
        <!-- VIEW POPUP (ROW/COLUMN LAYOUT) -->
        <!-- ===================================================== -->

        <div class="modal fade" id="viewRoomTypeModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
                <div class="modal-content">

                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title text-white">Room Type Details</h5>
                        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <!-- ROOM DETAILS -->
                        <h4 class="fw-bold mb-3">Room Type</h4>
                        <div class="row g-3">

                            <div class="col-md-3 col-12">
                                <label class="fw-bold">Room Type Name</label>
                                <p id="v_name"></p>
                            </div>

                            <div class="col-md-3 col-12">
                                <label class="fw-bold">Price</label>
                                <p id="v_price"></p>
                            </div>

 <div class="col-md-3 col-12">
                                <label class="fw-bold">GST Slab</label>
                                <p id="v_gstslab"></p>
                            </div>

                            <div class="col-md-3 col-12">
                                <label class="fw-bold">Order By</label>
                                <p id="v_orderby"></p>
                            </div>

                            <div class="col-md-3 col-12">
                                <label class="fw-bold">Status</label>
                                <p id="v_status"></p>
                            </div>

                            <div class="col-md-12">
                                <label class="fw-bold">Description</label>
                                <p id="v_description"></p>
                            </div>

                        </div>

                        <hr>
                        <br>
                        <!-- AMENITIES -->
                        <h4 class="fw-bold mb-3">Amenities</h4>
                        <div class="row" id="amenitiesList"></div>

                        <hr>
                        <br>
                        <!-- IMAGES -->
                        <h4 class="fw-bold mb-3">Room Images</h4>
                        <div class="row" id="imagesList"></div>

                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>

                </div>
            </div>
        </div>


        <div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">

                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body text-center">
                        <p class="fw-bold">Are you sure you want to delete?</p>
                        <input type="hidden" id="deleteRoomTypeId">
                    </div>

                    <div class="modal-footer d-flex justify-content-between">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">No</button>
                        <button class="btn btn-danger" id="confirmDeleteBtn">Yes, Delete</button>
                    </div>

                </div>
            </div>
        </div>


        <?php include('../footer.php'); ?>

        <!-- AJAX SCRIPT -->
        <script>
            $(document).on("click", ".viewBtn", function () {

                let id = $(this).data("id");
                // alert(id);
                $.ajax({
                    url: "view_roomtype_ajax.php",
                    type: "POST",
                    data: { id: id },
                    success: function (response) {
                        // alert(response);
                        let data = JSON.parse(response);



                        // ROOM DETAILS
                        $("#v_name").text(data.room.name);
                        $("#v_price").text("₹" + data.room.price);
                        $("#v_description").text(data.room.description);
                        $("#v_gstslab").text(data.room.GSTSlabName);
                        $("#v_orderby").text(data.room.orderby);
                        $("#v_status").html(
                            `<span class="${data.room.status == 1 ? "Active" : "Inactive"}">
                            ${data.room.status == 1 ? "Active" : "Inactive"}
                         </span>`
                        );

                        // AMENITIES
                        let amenHTML = "";
                        //   alert(data.amenities.length);
                        if (data.amenities.length > 0) {
                            data.amenities.forEach(a => {
                                amenHTML += `
                                <div class="col-md-2 mb-2">
                                    
                                    <div id="iconPreview" 
     style="
    width:150px;
    height:90px;
    border-radius:12px;
    background:#ffffff;
    box-shadow:0 3px 10px rgba(0,0,0,0.15);
    display:flex;
    flex-direction:column;
    align-items:center;
    justify-content:center;
    font-size:35px;
    margin-top:10px;
    text-align:center;
    padding:15px;    


     ">

                                        <div class="fs-2">${a.icons}</div>
                                        <h6 class="icon-name" style="font-size:14px; margin-top:4px;">${a.name}</h6>
                                     </div>  
                                    
                                </div>`;
                            });
                        } else {
                            amenHTML = `<p class="text-center text-muted">No Amenities Available</p>`;
                        }
                        $("#amenitiesList").html(amenHTML);
                        let imgHTML = "";

                        if (data.media && data.media.length > 0) {

                            data.media.forEach(img => {


                                // SHOW PHOTOS
                                if (img.photos && img.photos.length > 0) {

                                    img.photos.forEach(photo => {

                                        // alert(photo);

                                        imgHTML += `
                <div class="col-md-3 mb-3">
                    <div class="p-2 border rounded shadow-sm">
                        <img src="<?php echo $base_url ?>/images/roomtype/${photo}" 
                             class="img-fluid rounded"
                             style="height:150px;object-fit:cover">

                        
                    </div>
                </div>`;
                                    });
                                }

                                // SHOW VIDEO
                                if (img.video) {
                                    imgHTML += `
            <div class="col-md-4 mb-3">
                <div class="p-2 border rounded shadow-sm">
                    <video controls style="width:100%;height:180px;border-radius:8px;object-fit:cover">
                        <source src="${base_url}/images/roomtype/${img.video}">
                    </video>
                </div>
            </div>`;
                                }

                            });

                        } else {
                            imgHTML = `<p class="text-center text-muted">No Images Available</p>`;
                        }


                        $("#imagesList").html(imgHTML);

                    }
                });

            });



            document.querySelectorAll(".deleteBtn").forEach(button => {
                button.addEventListener("click", function () {

                    let id = this.getAttribute("data-id");

                    // Put id into hidden input of modal form
                    document.getElementById("deleteId").value = id;
                });
            });



        </script>

    </div>

</body>

</html>