<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php

include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php'); 
include('../vipaslookup.php');
?>


<body class="body-area">

    <!-- preloader start -->
    <?php include('preloader.php'); ?>
    <!-- preloader end -->

    <!-- Dashboard page wrapper start -->
    <div class="page">

           <!-- Start app-sidebar -->
        <?php include('../sidebar.php'); ?>
        <!-- end app-sidebar -->

        <!-- app-header -->
        <?php include('../nav.php'); ?>
        <!-- app-header -->


        <?php 

if(isset($_GET['Id']))
{
        
        $Id = $_GET['Id'];
        $getRoomData = "SELECT * FROM roomtype WHERE Id = '$Id'";
        $roomDataQuery = mysqli_query($conn, $getRoomData);
      
        // print_r($roomData);
          foreach($roomDataQuery as $row){ 
        ?>

        <!-- app-content-area-start -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Room Type & Amenities Setup Wizard Edit</h1>
                                <nav aria-label="breadcrumb">
                                    <!-- <ol class="breadcrumb breadcrumb-example1 mb-0">
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                        <li class="breadcrumb-item" aria-current="page">Forms</li>
                                        <li class="breadcrumb-item active" aria-current="page">Form Validation</li>
                                    </ol> -->
                                </nav>
                            </div>
                        </div>
                       

                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Edit</h4>
                                </div>
                                <div class="card-body pt-15">
                                        <!-- ================= Progress Bar ================= -->
                                        <div class="progress mb-4" style="height: 25px;">
                                            <div class="progress-bar bg-primary" role="progressbar" style="width: 20%;" id="progressBar">Step 1 of 3</div>
                                        </div>

                                        <form class="row g-3" method="POST" action="code.php" enctype="multipart/form-data" id="multiStepForm">

                                        <!-- ========== STEP 1: Room Type Edit ========== -->
                                        <div class="form-step active">
                                            <h5 class="mb-3">Step 1: Room Type Details</h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="form-label">Name</label>
                                                    <input type="text" name="name" class="form-control" placeholder="Enter Name" value="<?php echo htmlspecialchars($row['name']); ?>">
                                                </div>

                                        

                                                <div class="col-md-3">
                                                    <label class="form-label">Price </label>
                                                    <input type="number" step="0.01" name="price" class="form-control" placeholder="Enter price" value="<?php echo htmlspecialchars($row['price']); ?>" required>
                                                </div>
                                                       <div class="col-md-3">
                    <label class="form-label">GST Slab</label>
                    <!-- <input type="number" step="0.01" name="price" class="form-control" required> -->
                     <?php $gstSlabList = getLocckUpListByGroupName('GSTSlab', $conn);
                     
                     
                     echo $gstSlabList;
                     ?>
                    <select class="form-control" name="gstslabId" required>
                        <!-- <option value="">Select GST Slab</option> -->
                        <?php
                        foreach ($gstSlabList as $id => $displayValue) {
                            $selected = ($row['GSTSlab'] == $id) ? 'selected' : '';
                            echo '<option ' . $selected . '  value="' . $id . '">' . htmlspecialchars($displayValue) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                

                                                <div class="col-md-12">
                                                    <label class="form-label">Description</label>
                                                    <textarea name="description" class="form-control" rows="3" placeholder="Enter Description" ><?php echo htmlspecialchars($row['description']); ?></textarea>
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label">Order By</label>
                                                    <input type="number"  name="orderby" class="form-control" placeholder="Enter Order By" value="<?php echo $row['orderby']; ?>" required>
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label d-block">Status</label>
                                                    <div class="form-check">
                                                        <?php 
                                                            if($row['status'] =="1"){
                                                        ?>
                                                        <br>
                                                        <input type="checkbox" name="status"  id="checkbox1" value="<?php echo $row['status']; ?>" checked style="width: 40px; height: 40px;">

                                                        <?php
                                                        }else{
                                                        ?>
                                                        <br>
                                                        <input class="form-check-input" type="checkbox" name="status" id="status"
                                                        style="width: 30px; height: 30px; cursor: pointer;">
                                                        <?php
                                                        }
                                                        ?>
                                                        <!-- <label class="form-check-label ms-2" for="status">Active</label> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-end mt-3">
                                                <button type="button" class="btn btn-primary next-step">Next</button>
                                            </div>
                                        </div>
                                        <!-- ========== STEP 2: Room Type ========== -->
                                      
<div class="form-step">
    <h5 class="mb-3">Step 2: Amenities</h5>

    <div class="row">
        <div class="col-md-12">
            <label class="form-label">Select Amenities</label>

            <div class="row g-3">

                <?php 
                // Fetch amenities
                $getAmenities = "SELECT * FROM amenities WHERE status = 1 ORDER BY name";
                $amenities = $conn->query($getAmenities);

                // Fetch already selected amenities
                $alreadySelected = [];
                $getSelected = $conn->query("SELECT amenitiesId FROM roomtypeamenities WHERE roomtypeId = $Id");
                while ($sel = $getSelected->fetch_assoc()) {
                    $alreadySelected[] = $sel['amenitiesId'];
                }

                while ($am = $amenities->fetch_assoc()) {

                    $isSelected = in_array($am['Id'], $alreadySelected) ? "selected" : "";
                ?>
                    <!-- Amenity Button -->
                    <div class="col-6 col-md-3">
                        <div class="amenity-btn border rounded p-2 text-center <?php echo $isSelected; ?>"
                             data-id="<?php echo $am['Id']; ?>">

                            <div class="icon-box mb-2 d-flex justify-content-center align-items-center"
                                 style="width:80px;height:80px;margin:auto;border:1px solid #ddd;border-radius:10px;">
                                <?php echo $am['icons']; ?>
                            </div>

                            <div class="fw-bold"><?php echo $am['name']; ?></div>
                        </div>

                        <!-- Hidden Input -->
                        <input type="hidden" name="amenities[]" id="amenity<?php echo $am['Id']; ?>"
                               value="<?php echo $isSelected ? $am['Id'] : ''; ?>">
                    </div>

                <?php } ?>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between mt-3">
        <button type="button" class="btn btn-secondary prev-step">Previous</button>
        <button type="button" class="btn btn-primary next-step">Next</button>
    </div>

    <style>
        .amenity-btn {
    cursor: pointer;
    transition: 0.2s;
}
.amenity-btn:hover {
    background: #f5f9ff;
}
.amenity-btn.selected {
    border-color: #0d6efd;
    background: #e7f0ff;
}
.icon-box svg, .icon-box i {
    font-size: 40px !important;
}

    </style>

<script>
    document.querySelectorAll(".amenity-btn").forEach(btn => {
    btn.addEventListener("click", function () {

        let id = this.getAttribute("data-id");
        let input = document.getElementById("amenity" + id);

        this.classList.toggle("selected");

        if (this.classList.contains("selected")) {
            input.value = id;     // Select
        } else {
            input.value = "";     // Unselect
        }
    });
});
</script>
</div>

<!-- ========== STEP 3: Room Floor ========== -->
        <div class="form-step">
              <h5 class="mb-3">Step 3: Room Images </h5>
            <div class="row">
                <div class="col-12">
  <label class="form-label">Upload Room Images (Up to 4)</label>
  <div class="row">
    <?php 
    // Assuming your DB columns are named photo1, photo2, photo3, photo4

    $slectroommedia = "SELECT * FROM roomtypemedia WHERE roomtypeId = '$Id'";
    $roommediaquery = mysqli_query($conn, $slectroommedia);
    $roomtypemediarow = mysqli_fetch_assoc($roommediaquery);


    for ($i = 1; $i <= 4; $i++): 
        $photoField = 'photo' . $i;
        $photoSrc = !empty($roomtypemediarow[$photoField]) ? $base_url . '/images/roomtype/' . $roomtypemediarow[$photoField] :  '../assets/images/avatar/avatar-thumb-dummy.png'; // fallback image
    ?>
      <div class="col-md-3 col-sm-3 mb-3 text-center">
        <div class="border rounded p-2">
          <img id="preview<?php echo $i; ?>" 
               src="<?php echo $photoSrc; ?>" 
               width="250" height="200" 
               class="img-fluid mb-2" 
               style="height: 200px; object-fit: cover;">
          <input class="form-control form-control-sm" 
                 type="file" 
                 name="room_image<?php echo $i; ?>" 
                 accept="image/*" 
                 onchange="previewImage(event, <?php echo $i; ?>)">
                 <input type="hidden" name="oldroomimage<?php echo $i; ?>" value="<?php echo $roomtypemediarow['photo'.$i]; ?>">
        </div>
      </div>
    <?php endfor; ?>
  </div>
</div>
</div>
<button type="button" class="btn btn-secondary prev-step">Previous</button>
                                        <input type="hidden" name="Id" value="<?php echo htmlspecialchars($row['Id']); ?>">

                                        <div class="col-12 d-flex justify-content-end">
                                            <a href="roomtypeindex.php" class="btn btn-danger me-2">Cancel</a>
                                            <button class="btn btn-primary" name="edit" type="submit">Submit</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <?php
                         }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- app-content-area-end -->

       <?php include('../footer.php'); ?>
       <!-- ================= Scripts ================= -->
<script>
const steps = document.querySelectorAll(".form-step");
const nextBtns = document.querySelectorAll(".next-step");
const prevBtns = document.querySelectorAll(".prev-step");
const progressBar = document.getElementById("progressBar");
let currentStep = 0;

nextBtns.forEach(btn => {
    btn.addEventListener("click", () => {
        const currentForm = steps[currentStep].querySelectorAll("input, select, textarea");
        let valid = true;

        currentForm.forEach(field => {
            if (field.hasAttribute("required") && !field.value) {
                field.classList.add("is-invalid");
                valid = false;
            } else {
                field.classList.remove("is-invalid");
            }
        });

        if (valid) {
            steps[currentStep].classList.remove("active");
            currentStep++;
            steps[currentStep].classList.add("active");
            updateProgressBar();
            window.scrollTo({ top: 0, behavior: "smooth" });
        }
    });
});

prevBtns.forEach(btn => {
    btn.addEventListener("click", () => {
        steps[currentStep].classList.remove("active");
        currentStep--;
        steps[currentStep].classList.add("active");
        updateProgressBar();
        window.scrollTo({ top: 0, behavior: "smooth" });
    });
});

function updateProgressBar() {
    const percent = ((currentStep + 1) / steps.length) * 100;
    progressBar.style.width = percent + "%";
    progressBar.textContent = `Step ${currentStep + 1} of ${steps.length}`;
}

function previewImage(event, id) {
    const reader = new FileReader();
    reader.onload = function() {
        document.getElementById("preview" + id).src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>

<style>
.form-step { display: none; }
.form-step.active { display: block; animation: fadeIn 0.3s ease-in-out; }
@keyframes fadeIn { from {opacity:0;} to {opacity:1;} }
.is-invalid { border-color: red; }
.progress { background: #e9ecef; border-radius: 30px; overflow: hidden; }
.progress-bar { font-weight: 600; line-height: 25px; }
</style>

</body>

</html>