<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php'); 
include('../vipaslookup.php');
?>

<body class="body-area">

<?php include('preloader.php'); ?>
<div class="page">
<?php include('../sidebar.php'); ?>
<?php include('../nav.php'); ?>

<div class="app-content-area">
<div class="app-content-wrap">
<div class="container-fluid">

<div class="card">
<div class="card-header">
    <h4 class="card-title">Room Type & Amenities Setup Wizard</h4>
</div>
<div class="card-body pt-15">

    <!-- ================= Progress Bar ================= -->
    <div class="progress mb-4" style="height: 25px;">
        <div class="progress-bar bg-primary" role="progressbar" style="width: 20%;" id="progressBar">Step 1 of 5</div>
    </div>

    <form class="row g-3" method="POST" action="code.php" enctype="multipart/form-data" id="multiStepForm">
        
        <!-- ========== STEP 1: Room Type Create ========== -->
        <div class="form-step active">
            <h5 class="mb-3">Step 1: Room Type Details</h5>
            <div class="row">
               

                <div class="col-md-6">
                    <label class="form-label">Room Type Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Price Per Night</label>
                    <input type="number" step="0.01" name="price" class="form-control" required>
                </div>

                

                <div class="col-md-12">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Order By</label>
                    <input type="number" name="orderby_type" class="form-control" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label d-block">Status</label>
                    <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="status" id="status"
                            style="width: 30px; height: 30px; cursor: pointer;">
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end mt-3">
                <button type="button" class="btn btn-primary next-step">Next</button>
            </div>
        </div>

        <!-- ========== STEP 2: Room Type ========== -->
        <div class="form-step">

          <h5 class="mb-3">Step 2: Amenities</h5>
            <div class="row">
                <div class="col-md-6">
                    <label class="form-label">Amenities Group</label>
                    <select class="form-control" name="amenitiesgroupId" required>
                        <option value="">Select Amenities Group</option>
                        <?php
                        $getAmenitiesGroup = "SELECT * FROM amenitiesgroup WHERE status = 1 ORDER BY name";
                        $amenitiesGroups = $conn->query($getAmenitiesGroup);
                        if ($amenitiesGroups && $amenitiesGroups->num_rows > 0) {
                            while ($row = $amenitiesGroups->fetch_assoc()) {
                                echo '<option value="' . $row['Id'] . '">' . htmlspecialchars($row['name']) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>

           
            </div>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">Previous</button>
                <button type="button" class="btn btn-primary next-step">Next</button>
            </div>
            <!-- <h5 class="mb-3">Step 3: Room Floor</h5>
            <div class="row">
                <div class="col-md-6">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Order By</label>
                    <input type="number" name="orderby" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label d-block">Status</label>
                    <input class="form-check-input" type="checkbox" name="status" style="width:30px;height:30px;">
                </div>
            </div>
            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">Previous</button>
                <button type="button" class="btn btn-primary next-step">Next</button>
            </div> -->

          
        </div>

        <!-- ========== STEP 3: Room Floor ========== -->
        <div class="form-step">
              <h5 class="mb-3">Step 3: Room Images </h5>
            <div class="row">
                

                <div class="col-12">
                    <label class="form-label">Upload Room Images (Up to 4)</label>
                    <div class="row">
                        <?php for ($i = 1; $i <= 4; $i++): ?>
                        <div class="col-md-3 text-center mb-3">
                            <div class="border rounded p-2">
                                <img id="preview<?php echo $i; ?>" src="../assets/images/avatar/avatar-thumb-dummy.png" class="img-fluid mb-2" style="height:200px;object-fit:cover;">
                                <input class="form-control form-control-sm" type="file" name="room_image<?php echo $i; ?>" accept="image/*" onchange="previewImage(event, <?php echo $i; ?>)">
                            </div>
                        </div>
                        <?php endfor; ?>
                    </div>
                </div>

                <div class="col-md-4">
                    <label class="form-label">Order By</label>
                    <input type="number" name="orderby" class="form-control" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label d-block">Status</label>
                    <input class="form-check-input" type="checkbox" name="status" style="width:30px;height:30px;">
                </div>
            </div>

      
            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">Previous</button>
                <div>
                    <a href="roomtypeindex.php" class="btn btn-danger me-2">Cancel</a>
                    <button type="submit" name="create" class="btn btn-success">Submit All</button>
                </div>
            </div>
        </div>

        <!-- ========== STEP 4: Amenities ========== -->
        <!-- <div class="form-step">
            <h5 class="mb-3">Step 4: Amenities</h5>
            <div class="row">
                <div class="col-md-6">
                    <label class="form-label">Amenities Group</label>
                    <select class="form-control" name="amenitiesgroupId" required>
                        <option value="">Select Amenities Group</option>
                        <?php
                        $getAmenitiesGroup = "SELECT * FROM amenitiesgroup WHERE status = 1 ORDER BY name";
                        $amenitiesGroups = $conn->query($getAmenitiesGroup);
                        if ($amenitiesGroups && $amenitiesGroups->num_rows > 0) {
                            while ($row = $amenitiesGroups->fetch_assoc()) {
                                echo '<option value="' . $row['Id'] . '">' . htmlspecialchars($row['name']) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-md-12">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>

                <div class="col-md-6">
                    <label class="form-label d-block">Icons</label>
                    <input class="form-check-input" type="checkbox" name="icons" style="width:30px;height:30px;">
                </div>

                <div class="col-md-6">
                    <label class="form-label d-block">Status</label>
                    <input class="form-check-input" type="checkbox" name="status" style="width:30px;height:30px;">
                </div>
            </div>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">Previous</button>
                <button type="button" class="btn btn-primary next-step">Next</button>
            </div>
        </div> -->

        <!-- ========== STEP 5: Amenities Group ========== -->
        <!-- <div class="form-step">
            <h5 class="mb-3">Step 5: Amenities Group</h5>
            <div class="row">
                <div class="col-md-12">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3" required></textarea>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Order By</label>
                    <input type="number" name="orderby" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label d-block">Status</label>
                    <input class="form-check-input" type="checkbox" name="status" style="width:30px;height:30px;">
                </div>
            </div>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">Previous</button>
                <div>
                    <a href="roomtypeindex.php" class="btn btn-danger me-2">Cancel</a>
                    <button type="submit" name="create" class="btn btn-success">Submit All</button>
                </div>
            </div>
        </div> -->

    </form>
</div>
</div>

</div>
</div>
</div>

<?php include('../footer.php'); ?>
</div>

<!-- ================= Scripts ================= -->
<script>
const steps = document.querySelectorAll(".form-step");
const nextBtns = document.querySelectorAll(".next-step");
const prevBtns = document.querySelectorAll(".prev-step");
const progressBar = document.getElementById("progressBar");
let currentStep = 0;

nextBtns.forEach(btn => {
    btn.addEventListener("click", () => {
        const currentForm = steps[currentStep].querySelectorAll("input, select, textarea");
        let valid = true;

        currentForm.forEach(field => {
            if (field.hasAttribute("required") && !field.value) {
                field.classList.add("is-invalid");
                valid = false;
            } else {
                field.classList.remove("is-invalid");
            }
        });

        if (valid) {
            steps[currentStep].classList.remove("active");
            currentStep++;
            steps[currentStep].classList.add("active");
            updateProgressBar();
            window.scrollTo({ top: 0, behavior: "smooth" });
        }
    });
});

prevBtns.forEach(btn => {
    btn.addEventListener("click", () => {
        steps[currentStep].classList.remove("active");
        currentStep--;
        steps[currentStep].classList.add("active");
        updateProgressBar();
        window.scrollTo({ top: 0, behavior: "smooth" });
    });
});

function updateProgressBar() {
    const percent = ((currentStep + 1) / steps.length) * 100;
    progressBar.style.width = percent + "%";
    progressBar.textContent = `Step ${currentStep + 1} of ${steps.length}`;
}

function previewImage(event, id) {
    const reader = new FileReader();
    reader.onload = function() {
        document.getElementById("preview" + id).src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>

<style>
.form-step { display: none; }
.form-step.active { display: block; animation: fadeIn 0.3s ease-in-out; }
@keyframes fadeIn { from {opacity:0;} to {opacity:1;} }
.is-invalid { border-color: red; }
.progress { background: #e9ecef; border-radius: 30px; overflow: hidden; }
.progress-bar { font-weight: 600; line-height: 25px; }
</style>

</body>
</html>
