<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php'); 
include('../vipaslookup.php');
?>

<body class="body-area">

    <!-- preloader start -->
    <?php include('preloader.php'); ?>
    <!-- preloader end -->

    <!-- Dashboard page wrapper start -->
    <div class="page">

        <!-- Sidebar -->
        <?php include('../sidebar.php'); ?>

        <!-- Navbar -->
        <?php include('../nav.php'); ?>

        <!-- Content Area -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Booking Services Create</h1>
                            </div>
                        </div>

                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Add Booking Services</h4>
                                </div>
                                <div class="card-body pt-15">
                                    
                                    <form class="row g-3" method="POST" action="code.php">

                                        <!-- BOOKING DROPDOWN -->
                                        <div class="col-md-6 col-12">
    <div class="form-group">
        <label for="booking">Booking</label><br />
        <select class="form-control" name="bookingId" id="booking" required>
            <option value="">Select Booking</option>

            <?php
            // Fetch all bookings
            $getBookings = "SELECT Id, customerId FROM bookings ORDER BY Id DESC";
            $bookings = $conn->query($getBookings);

            if ($bookings && $bookings->num_rows > 0) {

                while ($booking = $bookings->fetch_assoc()) {

                    $customerId = $booking['customerId'];

                    // Fetch customer name (correct table)
                    $custQuery = "SELECT name FROM customers WHERE Id = $customerId";
                    $custResult = $conn->query($custQuery);

                    $customerName = ($custResult && $custResult->num_rows > 0)
                        ? $custResult->fetch_assoc()['name']
                        : 'Unknown Customer';

                    echo '<option value="'.$booking['Id'].'">'.$customerName.'</option>';
                }
            }
            ?>
        </select>
    </div>
</div>





                                        <!-- Order DROPDOWN -->
                                        <!-- <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="service">Order</label><br />
                                                <select class="form-control" name="serviceId" id="service" required>
                                                    <option value="">Select Order</option>
                                                    <?php
                                                    $getServices = "SELECT * FROM order WHERE status=1 ORDER BY orderby";
                                                    $services = $conn->query($getServices);

                                                    if ($services && $services->num_rows > 0) {
                                                        while ($service = $services->fetch_assoc()) {
                                                            echo '<option value="' . $service['Id'] . '">' . $service['name'] . '</option>';
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div> -->

                                        <!-- Room DropDown -->
                                        
                                        <div class="col-md-6">
    <label class="form-label">Room</label>

    <?php
    // Fetch rooms with their room type (no status filter)
    $selectRooms = "
        SELECT r.Id, r.number
        FROM room r
        JOIN roomtype rt ON rt.Id = r.room_type
        ORDER BY r.Id ASC
    ";

    $roomResults = mysqli_query($conn, $selectRooms);
    ?>

    <select name="roomId" class="form-select" required>
        <option value="">Select Room</option>

        <?php foreach ($roomResults as $room): ?>
            <option value="<?php echo htmlspecialchars($room['Id']); ?>">
                <?php echo htmlspecialchars($room['number']); ?>
            </option>
        <?php endforeach; ?>

    </select>
</div>






                                        <!-- PRICE -->
                                        <div class="col-md-6">
                                            <label class="form-label">Price</label>
                                            <input type="number" step="0.01" name="price" class="form-control" placeholder="Enter Price" required>
                                        </div>

                                        <!-- QUANTITY -->
                                        <div class="col-md-6">
                                            <label class="form-label">Quantity</label>
                                            <input type="text" name="quantity" class="form-control" placeholder="Enter Quantity" required>
                                        </div>

                                        <!-- TOTAL -->
                                        <div class="col-md-6">
                                            <label class="form-label">Total</label>
                                            <input type="text" name="total" class="form-control" placeholder="Enter Total" required>
                                        </div>

                                        <!-- ORDER BY -->
                                        <div class="col-md-6">
                                            <label class="form-label">Order By</label>
                                            <input type="number" name="orderby" class="form-control" placeholder="Enter Order By" required>
                                        </div>

                                        <!-- STATUS -->
                                        <div class="col-md-6">
                                            <label class="form-label d-block">Status</label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="status" id="status"
                                                    style="width: 30px; height: 30px; cursor: pointer;">
                                            </div>
                                        </div>

                                        <!-- BUTTONS -->
                                        <div class="col-12 d-flex justify-content-end">
                                            <a href="roombookingorderindex.php" class="btn btn-danger me-2">Cancel</a>
                                            <button class="btn btn-primary" name="create" type="submit">Submit</button>
                                        </div>

                                    </form>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <?php include('../footer.php'); ?>
    </div>

</body>
</html>
