<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php

include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php'); 
include('../vipaslookup.php');
?>


<body class="body-area">

    <!-- preloader start -->
    <div id="loading">
        <div id="loading-center">
            <div id="loading-center-absolute">
                <div class="bd-preloader-content">
                    <div class="bd-preloader-logo">
                        <div class="bd-preloader-circle">
                            <svg width="190" height="190" viewBox="0 0 380 380" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle stroke="#F5F5F5" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                </circle>
                                <circle stroke="red" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                </circle>
                            </svg>
                        </div>
                        <img src="assets/images/logo/preloader-icon.svg" alt="image not found">
                    </div>
                    <p class="bd-preloader-subtitle">Room</p>
                </div>
            </div>
        </div>
    </div>
    <!-- preloader end -->

    <!-- Dashboard page wrapper start -->
    <div class="page">

           <!-- Start app-sidebar -->
        <?php include('../sidebar.php'); ?>
        <!-- end app-sidebar -->

        <!-- app-header -->
        <?php include('../nav.php'); ?>
        <!-- app-header -->


        <?php 

if(isset($_GET['Id']))
{
        
        $roomId = $_GET['Id'];
        $getRoomData = "SELECT * FROM room WHERE Id = '$roomId'";
        $roomDataQuery = mysqli_query($conn, $getRoomData);
      
        // print_r($roomData);
          foreach($roomDataQuery as $row){ 
        ?>

        <!-- app-content-area-start -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Room Edit</h1>
                                <nav aria-label="breadcrumb">
                                    <!-- <ol class="breadcrumb breadcrumb-example1 mb-0">
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                        <li class="breadcrumb-item" aria-current="page">Forms</li>
                                        <li class="breadcrumb-item active" aria-current="page">Form Validation</li>
                                    </ol> -->
                                </nav>
                            </div>
                        </div>
                       

                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Edit</h4>
                                </div>
                                <div class="card-body pt-15">
                                       <form class="row g-3" method="POST" action="code.php">
                                        
                                        <div class="col-md-4">
    <label class="form-label">Room Type</label>

    <?php
    // Fetch room types from database
    $query = "SELECT * FROM roomtype ORDER BY Id ASC";
    $roomTypeList = mysqli_query($conn, $query);
    ?>

    <select name="room_type" class="form-select" required>

        <?php while($rt = mysqli_fetch_assoc($roomTypeList)): ?>
            <?php 
                // Check if this option should be selected
                $selected = ($row['room_type'] == $rt['Id']) ? 'selected' : '';
            ?>

            <option value="<?php echo $rt['Id']; ?>" <?php echo $selected; ?>>
                <?php echo $rt['name']; ?>
            </option>

        <?php endwhile; ?>

    </select>
</div>

                                        
                                        <div class="col-md-4">
    <label class="form-label">Room Floor</label>

    <?php
    // Fetch room floor list from DB
    $query = "SELECT * FROM floor ORDER BY Id ASC";
    $roomFloorList = mysqli_query($conn, $query);
    ?>

    <select name="room_floor" class="form-select" required>

        <?php while($rf = mysqli_fetch_assoc($roomFloorList)): ?>

            <?php 
                // This ensures the same saved value is selected
                $selected = ($row['room_floor'] == $rf['Id']) ? 'selected' : '';
            ?>

            <option value="<?php echo $rf['Id']; ?>" <?php echo $selected; ?>>
                <?php echo $rf['name']; ?>
            </option>

        <?php endwhile; ?>

    </select>
</div>




                                        <div class="col-md-4">
                                            <label class="form-label">Room Name/Number</label>
                                            <input type="text" name="number" class="form-control" placeholder="Enter room number" value="<?php echo htmlspecialchars($row['number']); ?>">
                                        </div>

                                        

                                        <!-- <div class="col-md-4">
                                            <label class="form-label">Price Per Night</label>
                                            <input type="number" step="0.01" name="price" class="form-control" placeholder="Enter price" value="<?php echo htmlspecialchars($row['price']); ?>" required>
                                        </div> -->

                                        <div class="col-md-4">
                                            <label class="form-label">Max Occupancy</label>
                                            <input type="number" name="occupancy" class="form-control" placeholder="Enter max occupancy" value="<?php echo htmlspecialchars($row['occupancy']); ?>" required>
                                        </div>

                                        <div class="col-md-8">
                                            <label class="form-label">Description</label>
                                            <textarea name="description" class="form-control" rows="3" placeholder="Enter room description" value=""> <?php echo htmlspecialchars($row['description']); ?></textarea>
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label">Status</label>
                                                   <?php 
                                            
                                            $roomstatus = getLocckUpListByGroupName('roomstatus', $conn);
                                            ?>
                                            <select name="status" class="form-select" required>

                                               <?php foreach($roomstatus as $id => $displayValue):
                                                
                                                  $selected = ($row['status'] == $id) ? 'selected' : '';
                                                ?>
                                                
                                                <option  <?php echo $selected; ?> value="<?php echo htmlspecialchars($id); ?>"><?php echo htmlspecialchars($displayValue);
    ?></option>
                                            <?php endforeach; ?>
                                            </select>
                                        </div>
                                        <input type="hidden" name="Id" value="<?php echo htmlspecialchars($row['Id']); ?>">

                                        <div class="col-12 d-flex justify-content-end">
                                            <a href="roomindex.php" class="btn btn-danger me-2">Cancel</a>
                                            <button class="btn btn-primary" name="edit" type="submit">Save Room</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <?php
                         }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- app-content-area-end -->

       <?php include('../footer.php'); ?>
</body>

</html>