<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');
?>

<body class="body-area">

    <!-- preloader start -->
    <div id="loading">
        <div id="loading-center">
            <div id="loading-center-absolute">
                <div class="bd-preloader-content">
                    <div class="bd-preloader-logo">
                        <div class="bd-preloader-circle">
                            <svg width="190" height="190" viewBox="0 0 380 380" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <circle stroke="#F5F5F5" cx="190" cy="190" r="180" stroke-width="6"
                                    stroke-linecap="round"></circle>
                                <circle stroke="red" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                </circle>
                            </svg>
                        </div>
                        <img src="assets/images/logo/preloader-icon.svg" alt="image not found">
                    </div>
                    <p class="bd-preloader-subtitle">dashnix</p>
                </div>
            </div>
        </div>
    </div>
    <!-- preloader end -->

    <!-- Dashboard page wrapper start -->
    <div class="page">

        <!-- Sidebar -->
        <?php include('../sidebar.php'); ?>

        <!-- Navbar -->
        <?php include('../nav.php'); ?>

        <!-- Content Area -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Room Create</h1>
                            </div>
                        </div>

                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Add Room Details</h4>
                                </div>
                                <div class="card-body pt-15">
                                    <form class="row g-3" method="POST" action="code.php">

                                        <div class="col-md-4">
                                            <label class="form-label">Room Type</label>
                                            <?php

                                            // $roomTypeList = getLocckUpListByGroupName('roomtype', $conn);
                                            $selectRoomType = "SELECT * FROM roomtype WHERE status = 1";
                                            $results = mysqli_query($conn, $selectRoomType);

                                            ?>
                                            <select name="room_type" class="form-select" required>

                                                <?php foreach ($results as $roomtyperow): ?>
                                                    <option value="<?php echo htmlspecialchars($roomtyperow['Id']); ?>"><?php echo htmlspecialchars($roomtyperow['name']);
                                                       ?></option>
                                                <?php endforeach; ?>

                                                <!-- <option value="">Select Type</option>
                                                <option value="Single">Single</option>
                                                <option value="Double">Double</option>
                                                <option value="Deluxe">Deluxe</option>
                                                <option value="Suite">Suite</option> -->
                                            </select>
                                        </div>


                                        <div class="col-md-4">
                                            <label class="form-label"> Room Floor </label>
                                            <?php

                                            // $roomTypeList = getLocckUpListByGroupName('roomtype', $conn);
                                            $selectRoomType = "SELECT * FROM floor WHERE status = 1";
                                            $results = mysqli_query($conn, $selectRoomType);

                                            ?>
                                            <select name="room_floor" class="form-select" required>

                                                <?php foreach ($results as $roomtyperow): ?>
                                                    <option value="<?php echo htmlspecialchars($roomtyperow['Id']); ?>"><?php echo htmlspecialchars($roomtyperow['name']);
                                                       ?></option>
                                                <?php endforeach; ?>

                                                <!-- <option value="">Select Type</option>
                                                <option value="Single">Single</option>
                                                <option value="Double">Double</option>
                                                <option value="Deluxe">Deluxe</option>
                                                <option value="Suite">Suite</option> -->
                                            </select>
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label">Room Name / Number</label>
                                            <input type="text" name="number" class="form-control"
                                                placeholder="Enter room number" required>
                                        </div>


                                        <!-- 
                                        <div class="col-md-4">
                                            <label class="form-label">Price Per Night</label>
                                            <input type="number" step="0.01" name="price" class="form-control" placeholder="Enter price" required>
                                        </div> -->

                                        <div class="col-md-4">
                                            <label class="form-label">Max Occupancy</label>
                                            <input type="number" name="occupancy" class="form-control"
                                                placeholder="Enter max occupancy" required>
                                        </div>

                                        <div class="col-md-8">
                                            <label class="form-label">Description</label>
                                            <textarea name="description" class="form-control" Id="vipaseditor" rows="3"
                                                placeholder="Enter room description"></textarea>
                                        </div>

                                        <div class="col-md-4">
                                            <label class="form-label">Status</label>
                                            <?php

                                            $roomstatus = getLocckUpListByGroupName('roomstatus', $conn);
                                            ?>
                                            <select name="status" class="form-select" required>

                                                <?php foreach ($roomstatus as $id => $displayValue): ?>
                                                    <option value="<?php echo htmlspecialchars($id); ?>"><?php echo htmlspecialchars($displayValue);
                                                       ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>

                                        <div class="col-12 d-flex justify-content-end">
                                            <a href="roomindex.php" class="btn btn-danger me-2">Cancel</a>
                                            <button class="btn btn-primary" name="create" type="submit">Save
                                                Room</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <?php include('../footer.php'); ?>
    </div>

</body>

</html>