<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');
?>

<body class="body-area">

<div class="page">

<?php include('../sidebar.php'); ?>
<?php include('../nav.php'); ?>

<div class="app-content-area">
<div class="app-content-wrap">
<div class="container-fluid">
<div class="row">

<div class="col-xl-12">
    <div class="page-title-box d-flex-between flex-wrap gap-15">
        <h1 class="page-title fs-18 lh-1">Multiple Room Create</h1>
    </div>
</div>

<div class="col-xl-12">
<div class="card">
<div class="card-header">
    <h4 class="card-title">Add Multiple Rooms</h4>
</div>

<div class="card-body pt-15">

<form class="row g-3" method="POST" action="code.php">

    <!-- =============================== -->
    <!--   CONSTANT : ROOM TYPE          -->
    <!-- =============================== -->
    <div class="col-md-6">
        <label class="form-label">Room Type</label>
        <select name="room_type" class="form-select" required>
            <?php 
                $selectRoomType = "SELECT * FROM roomtype WHERE status = 1";
                $results = mysqli_query($conn, $selectRoomType);
                foreach($results as $rt){
                    echo '<option value="'.$rt['Id'].'">'.$rt['name'].'</option>';
                }
            ?>
        </select>
    </div>

    <!-- =============================== -->
    <!--   CONSTANT : ROOM FLOOR         -->
    <!-- =============================== -->
    <div class="col-md-6">
        <label class="form-label">Room Floor</label>
        <select name="room_floor" class="form-select" required>
            <?php 
                $selectFloor = "SELECT * FROM floor WHERE status = 1";
                $resfl = mysqli_query($conn, $selectFloor);
                foreach($resfl as $fl){
                    echo '<option value="'.$fl['Id'].'">'.$fl['name'].'</option>';
                }
            ?>
        </select>
    </div>

    <div class="col-12 my-3">
        <button type="button" id="addRow" class="btn btn-success btn-sm">+ Add Room</button>
    </div>

    <!-- TEMPLATE FOR REPEATER -->
    <template id="roomTemplate">
        <div class="roomRow border rounded p-3 mb-3">
            <div class="row g-3">

                <div class="col-md-3">
                    <label class="form-label">Room Number</label>
                    <input type="text" name="number[]" class="form-control" required>
                </div>

                <div class="col-md-3">
                    <label class="form-label">Max Occupancy</label>
                    <input type="number" name="occupancy[]" class="form-control" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">Description</label>
                    <textarea name="description[]" class="form-control" rows="1"></textarea>
                </div>

                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status[]" class="form-select">
                        <?php 
                        $roomstatus = getLocckUpListByGroupName('roomstatus', $conn);
                        foreach($roomstatus as $id => $name){
                            echo '<option value="'.$id.'">'.$name.'</option>';
                        }
                        ?>
                    </select>
                </div>

                <div class="col-12 text-end">
                    <button type="button" class="btn btn-danger btn-sm removeRow">Remove</button>
                </div>

            </div>
        </div>
    </template>

    <!-- WHERE NEW ROWS APPEAR -->
    <div id="roomRepeater"></div>

    <div class="col-12 d-flex justify-content-end mt-3">
        <a href="roomindex.php" class="btn btn-danger me-2">Cancel</a>
        <button class="btn btn-primary" name="create" type="submit">Save All Rooms</button>
    </div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<?php include('../footer.php'); ?>

</div>

<script>
document.addEventListener("DOMContentLoaded", () => {

    const repeater = document.getElementById("roomRepeater");
    const template = document.getElementById("roomTemplate");

    // add first empty row
    addRow();

    document.getElementById("addRow").addEventListener("click", addRow);

    function addRow() {
        let clone = template.content.cloneNode(true);
        repeater.appendChild(clone);
    }

    document.addEventListener("click", (e) => {
        if (e.target.classList.contains("removeRow")) {
            let rows = document.querySelectorAll(".roomRow");
            if (rows.length > 1) {
                e.target.closest(".roomRow").remove();
            }
        }
    });
});
</script>

</body>
</html>
