<?php
session_start();
include '../../conection.php';
include '../head.php';
?>

<body class="body-area">

    <!-- preloader start -->
    <?php include '../preloader.php'; ?>

    <!-- Dashboard page wrapper start -->
    <div class="page">

        <!-- authentication area start-->
        <div class="authentication-wrapper basic-authentication">
            <div class="authentication-inner">
                <div class="card">
                    <div class="authentication-top text-center mb-25">
                        <a href="javascript:;" class="authentication-logo logo-black">
                            <img src="<?php echo $base_url; ?>/assets/images/logo/logo-white.svg" alt="logo">
                        </a>
                        <a href="javascript:;" class="authentication-logo logo-white">
                            <img src="<?php echo $base_url; ?>/assets/images/logo/logo-white.svg" alt="logo">
                        </a>
                        <h4 class="mb-5">Welcome to VipHotel</h4>
                        <p>Please sign-in to your account and start the adventure</p>
                    </div>

                    <div class="card-body">

                        <!-- Display session message inside HTML -->
                        <?php if (isset($_SESSION['msg'])): ?>
                            <div class="alert alert-success text-center">
                                <?php 
                                echo $_SESSION['msg']; 
                                unset($_SESSION['msg']); // Remove after displaying
                                ?>
                            </div>
                        <?php endif; ?>

                        <?php if (isset($_SESSION['status'])): ?>
                            <div class="alert alert-danger text-center">
                                <?php 
                                echo $_SESSION['status']; 
                                unset($_SESSION['status']); // Remove after displaying
                                ?>
                            </div>
                        <?php endif; ?>

                    </div>

                    <form method="POST" action="code.php"  method="POST" class="card-body">
                        <div class="mb-10">
                            <label for="nameEmail" class="form-label">Email or Username</label>
                            <input type="text"  class="form-control" name="nameoremail" id="nameEmail" placeholder="Enter Email or Username" required>
                        </div> 
                        <div class="mb-15">
                            <div class="d-flex justify-content-between mb-5">
                                <label for="password" class="form-label mb-0" name="password">Password</label>
                                <a class="text-body" href="forgotpassword.php">
                                    Forgot Password?
                                </a>
                            </div>

                            <div class="form-group">
                                <div class="input-group">
                                    <input type="password" name="password" class="form-control" id="password" placeholder="Enter Password" required>
                                    <button class="input-group-text text-black toggle-password" type="button"> 
                                        <i class="ri-eye-line fs-20"></i> 
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="mb-25">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-me" name="remember-me">
                                <label class="form-check-label" for="remember-me">
                                    Remember Me
                                </label>
                            </div>
                        </div>

                        <div class="mb-25">
                            <button class="btn btn-primary w-100" name="signinbtn" type="submit">Sign in</button>
                        </div>
                    </form>

                    <p class="text-center underline">
                        <span>New on our platform?</span>
                        <a class="fw-bold" href="siginup.php">
                            <span>Create an account</span>
                        </a>
                    </p>
                </div>
            </div>
        </div>
        <!-- authentication area end-->

    </div>
    <!-- Dashboard page wrapper end -->

    <!-- JS -->
    <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/height-equal.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/isotope.pkgd.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/magnific-popup.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/smooth-scrollbar.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/authentication.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/main.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/sidebar.js"></script>

</body>
</html>
