<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">

<?php include '../conection.php'; ?>
<?php include '../head.php'; ?>

<body class="body-area">

    <!-- preloader start -->
    <?php include '../preloader.php'; ?>
    <!-- preloader end -->

    <div class="page">
        <!-- authentication area start-->
        <div class="authentication-wrapper basic-authentication">
            <div class="authentication-inner">
                <div class="card">
                    <div class="authentication-top text-center mb-25">
                        <a href="javascript:;" class="authentication-logo logo-black">
                            <img src="<?php echo $base_url; ?>/assets/images/logo/logo.png" alt="logo">
                        </a>
                        <a href="javascript:;" class="authentication-logo logo-white">
                            <img src="<?php echo $base_url; ?>/assets/images/logo/logo-white.svg" alt="logo">
                        </a>
                        <h4 class="mb-5">Join SumX Valut</h4>
                        <p>Create your account to get started and unlock the full investment experience.</p>
                    </div>

                    <form action="registercode.php" method="post">
                        <div class="mb-10">
                            <label for="name" class="form-label">Username</label>
                            <input type="text" class="form-control" id="name" name="username" placeholder="Enter Username" required>
                        </div>

                        <div class="mb-10">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email" required>
                            <small id="email-status" class="text-danger"></small>
                        </div>

                        <div class="mb-10">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="number" class="form-control" id="phone" name="phone" placeholder="Enter Phone" required>
                            <small id="phone-status" class="text-danger"></small>
                        </div>

                        <div class="mb-15">
                            <label for="password" class="form-label">Password</label>
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" required>
                                    <button class="input-group-text text-black toggle-password" type="button"> 
                                        <i class="ri-eye-line fs-20"></i> 
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="mb-25">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-me">
                                <label class="form-check-label" for="remember-me">
                                    Remember Me
                                </label>
                            </div>
                        </div>

                        <div class="mb-10">
                            <button class="btn btn-primary w-100" name="selfregisteradd" type="submit">Sign up</button>
                        </div>
                    </form>

                    <p class="text-center underline">
                        <span>Already have an account?</span>
                        <a class="fw-bold" href="signin.php"><span>Log in</span></a>
                    </p>
                </div>
            </div>
        </div>
        <!-- authentication area end-->
    </div>

    <!-- JS here -->
    <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/authentication.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/main.js"></script>
    
    <!-- JS -->
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script>
    $(document).ready(function () {
        function toggleSubmit() {
            if ($("#email").hasClass("is-invalid") || $("#phone").hasClass("is-invalid")) {
                $("button[name='selfregisteradd']").prop("disabled", true);
            } else {
                $("button[name='selfregisteradd']").prop("disabled", false);
            }
        }

        // Check email
        $("#email").on("keyup change", function () {
            var email = $(this).val();
            if (email.length > 3) {
                $.post("check_email.php", { email: email }, function (response) {
                    if (response.trim() === "exists") {
                        $("#email-status").text("❌ Email already registered").removeClass("text-success").addClass("text-danger");
                        $("#email").addClass("is-invalid").removeClass("is-valid");
                    } else {
                        $("#email-status").text("✅ Email available").removeClass("text-danger").addClass("text-success");
                        $("#email").addClass("is-valid").removeClass("is-invalid");
                    }
                    toggleSubmit();
                });
            } else {
                $("#email-status").text("");
                $("#email").removeClass("is-valid is-invalid");
                toggleSubmit();
            }
        });

        // Check phone
        $("#phone").on("keyup change", function () {
            var phone = $(this).val();
            if (phone.length >= 10) {
                $.post("check_phone.php", { phone: phone }, function (response) {
                    if (response.trim() === "exists") {
                        $("#phone-status").text("❌ Phone already registered").removeClass("text-success").addClass("text-danger");
                        $("#phone").addClass("is-invalid").removeClass("is-valid");
                    } else {
                        $("#phone-status").text("✅ Phone available").removeClass("text-danger").addClass("text-success");
                        $("#phone").addClass("is-valid").removeClass("is-invalid");
                    }
                    toggleSubmit();
                });
            } else {
                $("#phone-status").text("");
                $("#phone").removeClass("is-valid is-invalid");
                toggleSubmit();
            }
        });
    });
    </script>
</body>
</html>
