<?php
session_start();
include '../conection.php';
include '../head.php';

$token = isset($_GET['token']) ? $_GET['token'] : '';

if (!$token) {
    $_SESSION['status'] = "Invalid password reset link.";
    header("Location: forgotpassword.php");
    exit();
}

// Check if token exists and is valid
$stmt = $conn->prepare("SELECT * FROM register WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    $_SESSION['status'] = "Token is invalid or expired.";
    header("Location: forgotpassword.php");
    exit();
}

// Handle form submission
if (isset($_POST['reset_password'])) {
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $error = "Passwords do not match!";
    } else {
        $hashed_password = md5($new_password); // You can use password_hash() for better security
        $email = $user['email'];

        // Update password and clear token
        $updateStmt = $conn->prepare("UPDATE register SET password = ?, token = NULL WHERE email = ?");
        $updateStmt->bind_param("ss", $hashed_password, $email);
        if ($updateStmt->execute()) {
            $_SESSION['msg'] = "Password reset successfully. Please login.";
            header("Location: signin.php");
            exit();
        } else {
            $error = "Something went wrong. Try again.";
        }
    }
}
?>

<!doctype html>
<html lang="en">
<body class="body-area">
<div class="page">
    <div class="authentication-wrapper basic-authentication">
        <div class="authentication-inner">
            <div class="card">
                <div class="authentication-top text-center mb-25">
                    <h4 class="mb-5">Reset Password</h4>
                    <p>Please use a password you haven’t used before.</p>
                </div>

                <?php if(isset($error)) { echo '<p class="text-danger text-center">'.$error.'</p>'; } ?>
                <form method="post" action="">
                    <div class="mb-15">
                        <label for="new-password" class="form-label">New Password</label>
                        <div class="input-group">
                            <input type="password" name="new_password" class="form-control" id="new-password" placeholder="Enter Password" required>
                            <button class="input-group-text text-black toggle-password" type="button"><i class="ri-eye-line fs-20"></i></button>
                        </div>
                    </div>

                    <div class="mb-25">
                        <label for="confirm-password" class="form-label">Confirm Password</label>
                        <div class="input-group">
                            <input type="password" name="confirm_password" class="form-control" id="confirm-password" placeholder="Enter Password" required>
                            <button class="input-group-text text-black toggle-password" type="button"><i class="ri-eye-line fs-20"></i></button>
                        </div>
                    </div>

                    <div class="mb-10">
                        <button type="submit" name="reset_password" class="btn btn-primary w-100">Set new password</button>
                    </div>
                </form>

                <p class="text-center underline">
                    <a class="fw-bold text-primary" href="auth-signin-basic.html">Back to login</a>
                </p>
            </div>
        </div>
    </div>
</div>

    <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/height-equal.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/isotope.pkgd.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/magnific-popup.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/smooth-scrollbar.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/authentication.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/main.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/sidebar.js"></script>

<script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
<script>
    // Toggle password visibility
    $(document).on('click', '.toggle-password', function() {
        let input = $(this).closest('.input-group').find('input');
        input.attr('type', input.attr('type') === 'password' ? 'text' : 'password');
    });
</script>
</body>
</html>