<!doctype html>
<html class="no-js" lang="en" dir="ltr">

<?php
session_start();
include '../conection.php';
include '../head.php';
include('../vipasbase.php');
include('../smtpmail.php');

// Initialize variables
$emailSent = false;
$message = "";

// Check if form submitted
if (isset($_POST['send_reset'])) {
    $email = trim($_POST['email']);

    // Validate email format
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Check if email exists in DB
        $stmt = $conn->prepare("SELECT username, token FROM admin_register WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $username = $row['username'];
            $token = $row['token'];
          //  $hostlink = "https://yourdomain.com"; // replace with your domain


           $_SESSION['otp'] = $otp;
        $_SESSION['email'] = $email;
        $_SESSION['otp_time'] = time(); // store timestamp


            $subject = "Reset Your Password";
            $otp = rand(100000, 999999);
            // ✅ Store OTP in session
        $_SESSION['otp'] = $otp;
        $_SESSION['email'] = $email;
        $_SESSION['otp_time'] = time(); // store timestamp

        $subject = "Your OTP for Email Verification";
        $body = "
        <html>
        <body style='font-family: Arial, sans-serif; background-color:#f4f4f4; padding:20px;'>
            <div style='max-width:600px; background:#fff; padding:20px; border-radius:10px;'>
                <h2>Verify your Email</h2>
                <p>Dear <b>$username</b>,</p>
                <p>Your One-Time Password (OTP) is:</p>
                <h1 style='text-align:center; color:#008CBA;'>$otp</h1>
                <p>This OTP is valid for <b>10 minutes</b> and can be used only once.</p>
            </div>
        </body>
        </html>";

            // Send email
            SendEmail("", $subject, $body, $email, false, "register");

            $message = "✅ Check your email ($email) to reset your password.";
            $emailSent = true;
               $_SESSION['msg'] = "OTP has been sent to your email $email";
        echo "<script>window.location.href='forgototpvalidation.php';</script>";
        } else {
            $message = "❌ Email not registered.";
        }
    } else {
        $message = "❌ Invalid email format.";
    }
}
?>

<body class="body-area">

    <!-- preloader start -->
    <?php include '../preloader.php'; ?>
    <!-- preloader end -->

    <div class="page">
        <div class="authentication-wrapper basic-authentication">
            <div class="authentication-inner">
                <div class="card">
                    <div class="authentication-top text-center mb-25">
                        <a href="javascript:;" class="authentication-logo logo-black">
                            <img src="<?php echo $base_url; ?>/assets/images/logo/logo-black.svg" alt="logo">
                        </a>
                        <h4 class="mb-5">Forgot Password?</h4>
                        <p>Enter your email to receive password reset instructions.</p>
                    </div>

                    <div class="card-body">

                        <!-- Display message -->
                        <?php if (!empty($message)): ?>
                            <div class="alert <?php echo $emailSent ? 'alert-success' : 'alert-danger'; ?> text-center">
                                <?php echo $message; ?>
                            </div>
                        <?php endif; ?>

                        <!-- Show form only if email not sent -->
                        <?php if (!$emailSent): ?>
                            <form id="forgotForm" method="post" action="">
                                <div class="mb-25">
                                    <label for="nameEmail" class="form-label">Email</label>
                                    <input type="email" class="form-control" id="nameEmail" name="email" placeholder="Enter Email" required>
                                    <small id="emailFeedback" class="d-block mt-1"></small>
                                </div>
                                <div class="mb-10">
                                    <button class="btn btn-primary w-100" type="submit" name="send_reset" id="resetBtn" disabled>
                                        Send reset link
                                    </button>
                                </div>
                            </form>
                        <?php endif; ?>

                        <p class="text-center underline">
                            <a class="fw-bold text-primary" href="signin.php">Back to login</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JS -->
    <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
  <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/height-equal.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/isotope.pkgd.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/magnific-popup.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/smooth-scrollbar.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/authentication.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/main.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/sidebar.js"></script>
    <script>
    $(document).ready(function() {
        $("#nameEmail").on("keyup blur", function() {
            var email = $(this).val().trim();

            if (email.length > 5) {
                $.ajax({
                    url: "emailexists.php",
                    type: "POST",
                    data: { email: email },
                    success: function(response) {
                        response = response.trim();

                        if (response == "exists") {
                            $("#emailFeedback").text("✅ Email found, you can reset.")
                                .removeClass("text-danger").addClass("text-success");
                            $("#resetBtn").prop("disabled", false);
                        } else if (response == "invalid") {
                            $("#emailFeedback").text("❌ Invalid email format.")
                                .removeClass("text-success").addClass("text-danger");
                            $("#resetBtn").prop("disabled", true);
                        } else if (response == "not_exists") {
                            $("#emailFeedback").text("❌ Email not registered.")
                                .removeClass("text-success").addClass("text-danger");
                            $("#resetBtn").prop("disabled", true);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log("AJAX Error: " + error);
                    }
                });
            } else {
                $("#emailFeedback").text("").removeClass("text-success text-danger");
                $("#resetBtn").prop("disabled", true);
            }
        });

        // Optional: hide form smoothly if email sent
        <?php if ($emailSent): ?>
            $("#forgotForm").slideUp();
        <?php endif; ?>
    });
    </script>

</body>
</html>