<?php
session_start();
include '../conection.php';
include '../head.php';
include('../smtpmail.php');

// OTP expiry time in seconds (10 minutes)
$otpExpiry = 600;

// ✅ Verify OTP
if (isset($_POST['verifyotp'])) {
    $email = $_SESSION['email'];
    $enteredOtp = $_POST['otp'];

    if (!isset($_SESSION['otp'])) {
        $_SESSION['status'] = "OTP expired. Please request again.";
        header("Location: otpvalidation.php");
        exit;
    }

    if (time() - $_SESSION['otp_time'] > $otpExpiry) {
        unset($_SESSION['otp']);
        $_SESSION['status'] = "OTP expired. Please request again.";
        header("Location: otpvalidation.php");
        exit;
    }

    if ($enteredOtp == $_SESSION['otp']) {
        // $update = "UPDATE register SET status='active' WHERE email='$email'";
        // mysqli_query($conn, $update);

        unset($_SESSION['otp']);
        unset($_SESSION['otp_time']);
         $_SESSION['email'] = $email;
  echo "<script>window.location.href='resetpassword.php';</script>";
        // $_SESSION['msg'] = "Your account has been verified successfully!";
        // echo "<script>window.location.href='../index.php'</script>";
        exit;
    } else {
        $_SESSION['status'] = "Invalid OTP. Please request a new one.";
        unset($_SESSION['otp']);
        header("Location: otpvalidation.php");
        exit;
    }
}

// ✅ Resend OTP
if (isset($_POST['resend'])) {
    $otp = rand(100000, 999999);
    $_SESSION['otp'] = $otp;
    $_SESSION['otp_time'] = time();

    $email = $_SESSION['email'];
    $subject = "Your New OTP for Email Verification";
  $body = "
<html>
<body style='font-family: Arial, sans-serif; background-color:#f4f4f4; padding:20px;'>
    <div style='max-width:600px; margin:auto; background:#fff; padding:20px; border-radius:10px; box-shadow:0 0 10px rgba(0,0,0,0.1);'>
        <h2 style='color:#333;'>Resend OTP</h2>
        <p>Dear <b>$username</b>,</p>
        <p>You requested a new One-Time Password (OTP). Your new OTP is:</p>
        <h1 style='text-align:center; color:#008CBA; letter-spacing:2px;'>$otp</h1>
        <p style='margin-top:20px;'>Please use this OTP to complete your verification. It is valid for <b>10 minutes</b> and can be used only once.</p>
        <p style='margin-top:20px; font-size:12px; color:#777;'>If you did not request this OTP, please ignore this email.</p>
    </div>
</body>
</html>
";


    SendEmail("", $subject, $body, $email, false, "register");

    $_SESSION['msg'] = "A new OTP has been sent to your email address ($email). Please check your inbox and spam folder.";
    header("Location: otpvalidation.php");
    exit;
}


// ✅ Calculate remaining time for timer
$timeLeft = 0;
if (isset($_SESSION['otp_time'])) {
    $timeLeft = $otpExpiry - (time() - $_SESSION['otp_time']);
    if ($timeLeft < 0) $timeLeft = 0;
}
?>

<body class="body-area">

<div class="page">
    <div class="authentication-wrapper basic-authentication">
        <div class="authentication-inner">
            <div class="card">
                <div class="authentication-top text-center mb-25">
                    <a href="javascript:;" class="authentication-logo logo-black">
                        <img src="<?php echo $base_url; ?>/assets/images/logo/logo.png" alt="logo">
                    </a>
                    <h4 class="mb-5">OTP Validation</h4>
                    <p>Enter your OTP below</p>
                </div>

                <div class="card-body">

                    <!-- ✅ Success message -->
                    <?php if (isset($_SESSION['msg'])): ?>
                        <div class="alert alert-success text-center">
                            <?php echo $_SESSION['msg']; unset($_SESSION['msg']); ?>
                        </div>
                    <?php endif; ?>

                    <!-- ✅ Error message -->
                    <?php if (isset($_SESSION['status'])): ?>
                        <div class="alert alert-danger text-center">
                            <?php echo $_SESSION['status']; unset($_SESSION['status']); ?>
                        </div>
                    <?php endif; ?>

                    <!-- ✅ OTP Form -->
                    <form method="post" action="">
                        <div class="mb-25">
                            <label for="otp" class="form-label">OTP</label>
                            <input type="text" class="form-control" id="otp" name="otp" placeholder="Enter OTP" required>
                        </div>
                        <?php echo $_SESSION['otp'];?>
                        <div class="mb-10">
                            <button class="btn btn-primary w-100" type="submit" name="verifyotp">
                                Verify OTP
                            </button>
                        </div>
                    </form>

                    <!-- ✅ Resend Button with Timer -->
                    <form method="post" action="" id="resendForm">
                        <button id="resendBtn" class="btn btn-link w-100" type="submit" name="resend">
                            Resend OTP (<span id="timer"></span>)
                        </button>
                    </form>

                    <p class="text-center underline">
                        <a class="fw-bold text-primary" href="signin.php">Back to login</a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

    <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
  <script src="<?php echo $base_url; ?>/assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/jquery-3.7.0.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/height-equal.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/isotope.pkgd.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/magnific-popup.min.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/plugins/smooth-scrollbar.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/authentication.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/main.js"></script>
    <script src="<?php echo $base_url; ?>/assets/js/vendor/sidebar.js"></script>
<!-- JS -->
<script>
let timerDisplay = document.getElementById("timer");
let resendBtn = document.getElementById("resendBtn");

// Remaining time from PHP session
let timeLeft = <?php echo $timeLeft; ?>;

// Disable resend button if timer > 0
resendBtn.disabled = timeLeft > 0;

function startTimer(duration) {
    let time = duration;

    let interval = setInterval(() => {
        let minutes = Math.floor(time / 60);
        let seconds = time % 60;
        seconds = seconds < 10 ? "0" + seconds : seconds;
        timerDisplay.textContent = minutes + ":" + seconds;

        if (time <= 0) {
            clearInterval(interval);
            resendBtn.disabled = false;
            timerDisplay.textContent = "0:00";
        }
        time--;
    }, 1000);
}

if (timeLeft > 0) {
    startTimer(timeLeft);
} else {
    timerDisplay.textContent = "0:00";
    resendBtn.disabled = false;
}
</script>
</body>
</html>
