<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">

<?php 

  include('../conection.php');
   include('./loginsection/loginsessionData.php');

include('./head.php'); 


?>

<body class="body-area">

    <!-- preloader start -->
    <div id="loading">
        <div id="loading-center">
            <div id="loading-center-absolute">
                <div class="bd-preloader-content">
                    <div class="bd-preloader-logo">
                        <div class="bd-preloader-circle">
                            <svg width="190" height="190" viewBox="0 0 380 380" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle stroke="#F5F5F5" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                </circle>
                                <circle stroke="red" cx="190" cy="190" r="180" stroke-width="6" stroke-linecap="round">
                                </circle>
                            </svg>
                        </div>
                        <img src="assets/images/logo/preloader-icon.svg" alt="image not found">
                    </div>
                    <p class="bd-preloader-subtitle">dashnix</p>
                </div>
            </div>
        </div>
    </div>
    <!-- preloader end -->

    <!-- Dashboard page wrapper start -->
    <div class="page">

        <!-- Start app-sidebar -->
        <?php include('sidebar.php'); ?>
        <!-- end app-sidebar -->

        <!-- app-header -->
        <?php include('nav.php'); ?>
        <!-- app-header -->

        <!-- app-content-area-start -->
     <!-- app-content-area-start -->
<div class="app-content main-content">

    <div class="container-fluid">

        <!-- Page Title -->
        <div class="row mb-4">
            <div class="col-12">
                <h4 class="fw-bold">Hotel Management Dashboard</h4>
                <p class="text-muted">Overview of hotel performance and daily operations.</p>
            </div>
        </div>

        <!-- TOP STAT CARDS -->
        <div class="row g-4">

            <div class="col-md-3 col-sm-6">
                <div class="card shadow-sm border-0 p-3">
                    <h6 class="fw-bold">Total Rooms</h6>
                    <h2 class="fw-bold mb-0">120</h2>
                    <small class="text-muted">Available | Occupied</small>
                </div>
            </div>

            <div class="col-md-3 col-sm-6">
                <div class="card shadow-sm border-0 p-3">
                    <h6 class="fw-bold">Today's Bookings</h6>
                    <h2 class="fw-bold mb-0">18</h2>
                    <small class="text-muted">New Reservations</small>
                </div>
            </div>

            <div class="col-md-3 col-sm-6">
                <div class="card shadow-sm border-0 p-3">
                    <h6 class="fw-bold">Current Guests</h6>
                    <h2 class="fw-bold mb-0">65</h2>
                    <small class="text-muted">Checked-in guests</small>
                </div>
            </div>

            <div class="col-md-3 col-sm-6">
                <div class="card shadow-sm border-0 p-3">
                    <h6 class="fw-bold">Revenue (Today)</h6>
                    <h2 class="fw-bold mb-0">₹58,400</h2>
                    <small class="text-muted">Room + Services</small>
                </div>
            </div>

        </div>

        <!-- 2-COLUMN SECTION -->
        <div class="row g-4 mt-4">

            <!-- Recent Bookings -->
            <div class="col-lg-8">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Recent Bookings</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Guest</th>
                                    <th>Room</th>
                                    <th>Check-in</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Rahul Patil</td>
                                    <td>Deluxe – 203</td>
                                    <td>22 Dec</td>
                                    <td><span class="badge bg-light text-dark">Checked-In</span></td>
                                </tr>

                                <tr>
                                    <td>Sneha Kulkarni</td>
                                    <td>Suite – 405</td>
                                    <td>22 Dec</td>
                                    <td><span class="badge bg-light text-dark">Confirmed</span></td>
                                </tr>

                                <tr>
                                    <td>Ramesh Gupta</td>
                                    <td>Standard – 114</td>
                                    <td>23 Dec</td>
                                    <td><span class="badge bg-light text-dark">Pending</span></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>

            <!-- Right Side Column -->
            <div class="col-lg-4">

                <!-- Room Status Summary -->
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Room Status</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Available Rooms
                                <span class="fw-bold">45</span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Occupied Rooms
                                <span class="fw-bold">62</span>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Under Maintenance
                                <span class="fw-bold">13</span>
                            </li>

                        </ul>
                    </div>
                </div>

                <!-- Staff Summary -->
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Staff Overview</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-2">Total Staff: <strong>42</strong></p>
                        <p class="mb-2">On Duty Today: <strong>26</strong></p>
                        <p class="mb-0">Shift Pending: <strong>6</strong></p>
                    </div>
                </div>

            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 1: HOUSEKEEPING PANEL -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Housekeeping Panel</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Room No.</th>
                                    <th>Type</th>
                                    <th>Status</th>
                                    <th>Housekeeper</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>301</td>
                                    <td>Deluxe</td>
                                    <td><span class="badge bg-light text-dark">Cleaning</span></td>
                                    <td>Prakash</td>
                                </tr>
                                <tr>
                                    <td>118</td>
                                    <td>Standard</td>
                                    <td><span class="badge bg-light text-dark">Ready</span></td>
                                    <td>Riya</td>
                                </tr>
                                <tr>
                                    <td>407</td>
                                    <td>Suite</td>
                                    <td><span class="badge bg-light text-dark">Pending</span></td>
                                    <td>Vikas</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 2: CHECKOUT / DUE TODAY -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Due Checkout Today</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Guest</th>
                                    <th>Room</th>
                                    <th>Checkout Date</th>
                                    <th>Bill Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Akshay More</td>
                                    <td>202</td>
                                    <td>22 Dec</td>
                                    <td><span class="badge bg-light text-dark">Pending</span></td>
                                </tr>
                                <tr>
                                    <td>Kajal Shinde</td>
                                    <td>109</td>
                                    <td>22 Dec</td>
                                    <td><span class="badge bg-light text-dark">Paid</span></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 3: MONTHLY REVENUE GRAPH (STATIC, NO ANIMATION) -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Monthly Revenue Overview</h5>
                    </div>
                    <div class="card-body">

                        <img src="https://dummyimage.com/900x250/efefef/000000&text=Revenue+Graph+(Static+Image)" 
                             class="img-fluid rounded" alt="graph">

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 4: LOW INVENTORY / AMENITIES -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Low Inventory (Amenities)</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Remaining</th>
                                    <th>Minimum Level</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Towels</td>
                                    <td>14</td>
                                    <td>20</td>
                                </tr>
                                <tr>
                                    <td>Soap Bars</td>
                                    <td>40</td>
                                    <td>50</td>
                                </tr>
                                <tr>
                                    <td>Shampoo Bottles</td>
                                    <td>18</td>
                                    <td>25</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 5: COMPLAINTS / TICKETS -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Complaints / Service Tickets</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Issue</th>
                                    <th>Room</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>AC Not Working</td>
                                    <td>305</td>
                                    <td>High</td>
                                    <td><span class="badge bg-light text-dark">In-Progress</span></td>
                                </tr>
                                <tr>
                                    <td>TV Remote Missing</td>
                                    <td>119</td>
                                    <td>Low</td>
                                    <td><span class="badge bg-light text-dark">Pending</span></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 6: MAINTENANCE REQUESTS -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Maintenance Requests</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Task</th>
                                    <th>Location</th>
                                    <th>Assigned To</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Lift Servicing</td>
                                    <td>Block A</td>
                                    <td>Mahesh</td>
                                    <td><span class="badge bg-light text-dark">In-Progress</span></td>
                                </tr>
                                <tr>
                                    <td>Water Leakage Fix</td>
                                    <td>Room 410</td>
                                    <td>Ganesh</td>
                                    <td><span class="badge bg-light text-dark">Pending</span></td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 7: VISITOR LOG -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Visitor Log</h5>
                    </div>
                    <div class="card-body">

                        <table class="table align-middle">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Whom to Meet</th>
                                    <th>Purpose</th>
                                    <th>In Time</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Sunil Pawar</td>
                                    <td>Manager</td>
                                    <td>Business Meeting</td>
                                    <td>10:20 AM</td>
                                </tr>
                                <tr>
                                    <td>Priya Deshmukh</td>
                                    <td>Guest (Room 214)</td>
                                    <td>Friend Visit</td>
                                    <td>11:45 AM</td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <!-- ========================================================================================= -->
        <!-- MODULE 8: RESERVATION CALENDAR (SIMPLE) -->
        <!-- ========================================================================================= -->
        <div class="row g-4 mt-5 mb-5">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-header bg-white">
                        <h5 class="fw-bold mb-0">Reservation Calendar</h5>
                    </div>
                    <div class="card-body">

                        <img src="https://dummyimage.com/900x350/eeeeee/000000&text=Calendar+View+(Simple)" 
                             class="img-fluid rounded" alt="calendar">

                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
<!-- app-content-area-end -->

        <!-- app-content-area-end -->
</div>
        <!-- footer area start -->
        <?php include('footer.php'); ?>
         
       
</body>

</html>