<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hotel Management Dashboard - Premium UI</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon/fonts/remixicon.css" rel="stylesheet">

    <!-- Font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --bg: #f5f6fa;
            --card: #ffffff;
            --text: #222;
            --muted: #555;
            --sidebar: #ffffff;
            --sidebar-border: #e5e7eb;
        }

        [data-theme="dark"] {
            --bg: #111827;
            --card: #1f2937;
            --text: #f1f5f9;
            --muted: #9ca3af;
            --sidebar: #1f2937;
            --sidebar-border: #374151;
        }

        body {
            background: var(--bg);
            color: var(--text);
            font-family: "Inter", sans-serif;
            transition: 0.3s;
        }

        /* Sidebar */
        .sidebar {
            width: 260px;
            height: 100vh;
            background: var(--sidebar);
            border-right: 1px solid var(--sidebar-border);
            position: fixed;
            padding: 25px 18px;
            overflow-y: auto;
            transition: 0.3s;
        }

        .sidebar.collapsed {
            width: 90px;
        }

        .sidebar h4 {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 25px;
        }

        .sidebar.collapsed h4 {
            display: none;
        }

        .sidebar a {
            display: flex;
            align-items: center;
            padding: 12px 14px;
            border-radius: 12px;
            margin-bottom: 10px;
            color: var(--text);
            text-decoration: none;
            font-weight: 500;
            transition: 0.2s;
        }

        .sidebar a i {
            font-size: 22px;
            margin-right: 12px;
        }

        .sidebar.collapsed a i {
            margin-right: 0;
        }

        .sidebar.collapsed a span {
            display: none;
        }

        .sidebar a:hover,
        .sidebar .active {
            background: #eef1ff;
            color: #3f4ae0;
        }

        /* Topbar */
        .topbar {
            margin-left: 260px;
            background: var(--card);
            padding: 14px 25px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid var(--sidebar-border);
            position: sticky;
            top: 0;
            z-index: 10;
            transition: 0.3s;
        }

        .sidebar.collapsed + .topbar {
            margin-left: 90px;
        }

        .topbar .search-bar {
            width: 320px;
        }

        .topbar input {
            border-radius: 12px;
        }

        .toggle-btn {
            cursor: pointer;
            font-size: 26px;
            margin-right: 15px;
        }

        /* Content */
        .content-area {
            margin-left: 260px;
            padding: 30px;
            transition: 0.3s;
        }

        .sidebar.collapsed ~ .content-area {
            margin-left: 90px;
        }

        /* Cards */
        .card-app {
            border-radius: 18px;
            background: var(--card);
            padding: 22px;
            box-shadow: 0px 4px 14px rgba(0, 0, 0, 0.06);
            border: none;
            transition: 0.3s;
        }

        /* Quick Buttons */
        .quick-btn {
            border-radius: 18px;
            background: #eef1ff;
            padding: 18px;
            transition: 0.3s;
            text-align: center;
        }

        .quick-btn:hover {
            background: #dfe3ff;
        }

        /* Calendar */
        .calendar-box {
            background: #eef1f8;
            height: 350px;
            border-radius: 20px;
        }

        /* Satisfaction Circle */
        .circle-score {
            width: 170px;
            height: 170px;
            border-radius: 50%;
            background: conic-gradient(#3f4ae0 74%, #ccc 0%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: auto;
            font-size: 28px;
            font-weight: 700;
        }

        /* Simple Animation */
        .fade-in {
            animation: fade 0.5s ease;
        }

        @keyframes fade {
            from {opacity: 0;}
            to {opacity: 1;}
        }
    </style>
</head>

<body>

    <!-- SIDEBAR -->
    <div class="sidebar" id="sidebar">
        <h4>🏨 HOTEL PRO</h4>

        <a href="#" class="active"><i class="ri-dashboard-line"></i><span>Dashboard</span></a>
        <a href="#"><i class="ri-hotel-line"></i><span>Rooms</span></a>
        <a href="#"><i class="ri-bookmark-line"></i><span>Bookings</span></a>
        <a href="#"><i class="ri-group-line"></i><span>Guests</span></a>
        <a href="#"><i class="ri-user-settings-line"></i><span>Staff</span></a>
        <a href="#"><i class="ri-tools-line"></i><span>Maintenance</span></a>
        <a href="#"><i class="ri-brush-line"></i><span>Housekeeping</span></a>
        <a href="#"><i class="ri-file-chart-line"></i><span>Reports</span></a>
        <a href="#"><i class="ri-settings-3-line"></i><span>Settings</span></a>
    </div>

    <!-- TOPBAR -->
    <div class="topbar">
        <div class="d-flex align-items-center">
            <i class="ri-menu-line toggle-btn" id="toggleSidebar"></i>
            <input class="form-control search-bar" type="text" placeholder="Search anything...">
        </div>

        <div class="d-flex align-items-center gap-3">
            <i class="ri-notification-3-line fs-4"></i>

            <!-- Dark Mode -->
            <i class="ri-moon-clear-line fs-4" id="darkModeToggle" style="cursor:pointer;"></i>

            <img src="https://i.pravatar.cc/200?img=30" width="45" height="45" class="rounded-circle">
        </div>
    </div>
    <!-- MAIN CONTENT AREA -->
    <div class="content-area fade-in">

        <!-- QUICK ACTIONS -->
        <h4 class="fw-bold mb-3">Quick Actions</h4>

        <div class="row g-3 mb-4">

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-add-line fs-2"></i>
                    <div class="fw-semibold mt-2">Add Booking</div>
                </div>
            </div>

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-login-circle-line fs-2"></i>
                    <div class="fw-semibold mt-2">Check-in</div>
                </div>
            </div>

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-logout-circle-line fs-2"></i>
                    <div class="fw-semibold mt-2">Check-out</div>
                </div>
            </div>

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-hotel-bed-line fs-2"></i>
                    <div class="fw-semibold mt-2">Assign Room</div>
                </div>
            </div>

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-user-add-line fs-2"></i>
                    <div class="fw-semibold mt-2">Add Guest</div>
                </div>
            </div>

            <div class="col-md-2 col-6">
                <div class="quick-btn">
                    <i class="ri-file-chart-line fs-2"></i>
                    <div class="fw-semibold mt-2">Generate Report</div>
                </div>
            </div>

        </div>

        <!-- STATS ROW -->
        <div class="row g-4 mb-4">

            <div class="col-md-3">
                <div class="card-app d-flex justify-content-between">
                    <div>
                        <h6>Total Bookings</h6>
                        <h3 class="fw-bold">1,450</h3>
                    </div>
                    <div class="icon-box"><i class="ri-bookmark-line"></i></div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-app d-flex justify-content-between">
                    <div>
                        <h6>Guests Today</h6>
                        <h3 class="fw-bold">82</h3>
                    </div>
                    <div class="icon-box"><i class="ri-user-3-line"></i></div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-app d-flex justify-content-between">
                    <div>
                        <h6>Available Rooms</h6>
                        <h3 class="fw-bold">34</h3>
                    </div>
                    <div class="icon-box"><i class="ri-hotel-line"></i></div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card-app d-flex justify-content-between">
                    <div>
                        <h6>Revenue This Month</h6>
                        <h3 class="fw-bold">$92,540</h3>
                    </div>
                    <div class="icon-box"><i class="ri-money-dollar-circle-line"></i></div>
                </div>
            </div>

        </div>

        <!-- CALENDAR + POPULAR ROOMS -->
        <div class="row g-4 mb-4">

            <!-- Reservation Calendar -->
            <div class="col-lg-8">
                <div class="card-app">
                    <h5 class="section-title">Reservation Calendar</h5>
                    <div class="calendar-box"></div>
                </div>
            </div>

            <!-- Popular Room Types -->
            <div class="col-lg-4">
                <div class="card-app">
                    <h5 class="section-title">Popular Room Types</h5>

                    <ul class="list-group">

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span>Deluxe Room</span>
                            <strong>42%</strong>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span>Premium Suite</span>
                            <strong>28%</strong>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span>Family Room</span>
                            <strong>19%</strong>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span>Studio Room</span>
                            <strong>11%</strong>
                        </li>

                    </ul>
                </div>
            </div>

        </div>

        <!-- SATISFACTION SCORE + GUEST REQUESTS -->
        <div class="row g-4 mb-4">

            <!-- Guest Satisfaction -->
            <div class="col-lg-4">
                <div class="card-app text-center">
                    <h5 class="section-title">Guest Satisfaction</h5>

                    <div class="circle-score">92%</div>
                    <small class="text-muted d-block mt-2">Based on last 500 reviews</small>

                </div>
            </div>

            <!-- Guest Requests Panel -->
            <div class="col-lg-8">
                <div class="card-app">
                    <h5 class="section-title">Guest Requests</h5>

                    <ul class="list-group">

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-t-shirt-line me-2 text-primary"></i>Laundry – Room 302</span>
                            <span class="fw-semibold">Pending</span>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-restaurant-line me-2 text-warning"></i>Room Service – Room 420</span>
                            <span class="fw-semibold">In Progress</span>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-clipboard-line me-2 text-success"></i>Extra Towels – Room 110</span>
                            <span class="fw-semibold">Completed</span>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-water-flash-line me-2 text-danger"></i>Bathroom Leak – Room 509</span>
                            <span class="fw-semibold text-danger">Urgent</span>
                        </li>

                    </ul>

                </div>
            </div>

        </div>
        <!-- ===================================== -->
        <!-- HOUSEKEEPING DASHBOARD -->
        <!-- ===================================== -->
        <div class="card-app mb-4">
            <h4 class="section-title">Housekeeping Dashboard</h4>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="p-3 rounded" style="background:#eef7ff;">
                        <h6 class="fw-semibold mb-2"><i class="ri-brush-line me-1"></i> Rooms Cleaning</h6>
                        <div class="d-flex justify-content-between mb-1">
                            <span>Completed</span>
                            <strong>32</strong>
                        </div>
                        <div class="progress mb-3" style="height:8px;">
                            <div class="progress-bar bg-success" style="width:72%;"></div>
                        </div>

                        <div class="d-flex justify-content-between mb-1">
                            <span>Pending</span>
                            <strong>12</strong>
                        </div>
                        <div class="progress" style="height:8px;">
                            <div class="progress-bar bg-warning" style="width:36%;"></div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <ul class="list-group">

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-user-line me-2 text-primary"></i>Meera (Housekeeper)</span>
                            <span class="text-muted">Assigned 12 rooms</span>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-user-line me-2 text-success"></i>Arjun (Housekeeper)</span>
                            <span class="text-muted">Assigned 09 rooms</span>
                        </li>

                        <li class="list-group-item border-0 d-flex justify-content-between">
                            <span><i class="ri-user-line me-2 text-danger"></i>Riya (Housekeeper)</span>
                            <span class="text-muted">Assigned 07 rooms</span>
                        </li>

                    </ul>
                </div>

            </div>
        </div>



        <!-- ===================================== -->
        <!-- MAINTENANCE DASHBOARD -->
        <!-- ===================================== -->
        <div class="card-app mb-4">
            <h4 class="section-title">Maintenance Dashboard</h4>

            <ul class="list-group">

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-tools-line me-2 text-danger"></i>AC Failure – Room 605</span>
                    <span class="badge bg-danger">Urgent</span>
                </li>

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-tools-line me-2 text-warning"></i>Shower Leak – Room 214</span>
                    <span class="badge bg-warning text-dark">In Progress</span>
                </li>

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-tools-line me-2 text-primary"></i>TV Issue – Room 407</span>
                    <span class="badge bg-primary">Assigned</span>
                </li>

            </ul>
        </div>




        <!-- ===================================== -->
        <!-- ROOMS OVERVIEW GRID -->
        <!-- ===================================== -->
        <div class="card-app mb-4">
            <h4 class="section-title">Rooms Overview</h4>

            <div class="row g-4">

                <!-- room tile -->
                <div class="col-md-3 col-6">
                    <div class="p-3 border rounded-4 bg-white shadow-sm">
                        <h6 class="fw-bold">Room 201</h6>
                        <p class="text-muted mb-1">Deluxe</p>
                        <span class="badge bg-success">Available</span>
                    </div>
                </div>

                <div class="col-md-3 col-6">
                    <div class="p-3 border rounded-4 bg-white shadow-sm">
                        <h6 class="fw-bold">Room 305</h6>
                        <p class="text-muted mb-1">Premium</p>
                        <span class="badge bg-danger">Occupied</span>
                    </div>
                </div>

                <div class="col-md-3 col-6">
                    <div class="p-3 border rounded-4 bg-white shadow-sm">
                        <h6 class="fw-bold">Room 110</h6>
                        <p class="text-muted mb-1">Standard</p>
                        <span class="badge bg-warning text-dark">Cleaning</span>
                    </div>
                </div>

                <div class="col-md-3 col-6">
                    <div class="p-3 border rounded-4 bg-white shadow-sm">
                        <h6 class="fw-bold">Room 509</h6>
                        <p class="text-muted mb-1">Suite</p>
                        <span class="badge bg-info text-dark">Maintenance</span>
                    </div>
                </div>

                <!-- Add as many room tiles as needed -->

            </div>
        </div>




        <!-- ===================================== -->
        <!-- STAFF DUTY SCHEDULE -->
        <!-- ===================================== -->
        <div class="card-app mb-4">
            <h4 class="section-title">Staff Duty Schedule</h4>

            <ul class="list-group">

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-user-3-line me-2 text-primary"></i>Reception – Aman</span>
                    <span class="text-muted">08:00 AM – 04:00 PM</span>
                </li>

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-user-3-line me-2 text-success"></i>Cleaning – Meera</span>
                    <span class="text-muted">09:00 AM – 05:00 PM</span>
                </li>

                <li class="list-group-item border-0 d-flex justify-content-between">
                    <span><i class="ri-user-3-line me-2 text-warning"></i>Security – Rahul</span>
                    <span class="text-muted">06:00 PM – 02:00 AM</span>
                </li>

            </ul>
        </div>




        <!-- ===================================== -->
        <!-- NOTIFICATION CENTER -->
        <!-- ===================================== -->
        <div class="card-app mb-4">
            <h4 class="section-title">Notification Center</h4>

            <ul class="list-group">

                <li class="list-group-item border-0">
                    <i class="ri-notification-3-line text-primary me-2"></i>
                    New booking received from: <strong>Priya Sharma</strong>
                </li>

                <li class="list-group-item border-0">
                    <i class="ri-alert-line text-warning me-2"></i>
                    Room 214 requires urgent cleaning.
                </li>

                <li class="list-group-item border-0">
                    <i class="ri-money-dollar-circle-line text-success me-2"></i>
                    Payment received: $350 for Booking #1223.
                </li>

                <li class="list-group-item border-0">
                    <i class="ri-error-warning-line text-danger me-2"></i>
                    Complaint reported: Noise Issue – Room 402.
                </li>

            </ul>

        </div>




        <!-- ===================================== -->
        <!-- FILTER SIDEBAR (OFFCANVAS) -->
        <!-- ===================================== -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterPanel">
            <div class="offcanvas-header">
                <h5 class="offcanvas-title">Filter Options</h5>
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
            </div>

            <div class="offcanvas-body">

                <!-- Filter options -->
                <div class="mb-3">
                    <label class="form-label">Room Type</label>
                    <select class="form-select">
                        <option>All</option>
                        <option>Deluxe</option>
                        <option>Premium</option>
                        <option>Suite</option>
                        <option>Standard</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Status</label>
                    <select class="form-select">
                        <option>Any</option>
                        <option>Available</option>
                        <option>Occupied</option>
                        <option>Cleaning</option>
                        <option>Maintenance</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Sort By</label>
                    <select class="form-select">
                        <option>Newest</option>
                        <option>Oldest</option>
                        <option>Price High</option>
                        <option>Price Low</option>
                    </select>
                </div>

                <button class="btn btn-primary w-100">Apply Filters</button>

            </div>
        </div>

    </div> <!-- END CONTENT AREA -->

    <!-- BOOTSTRAP JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // SIDEBAR COLLAPSE
        const sidebar = document.getElementById("sidebar");
        const toggleSidebar = document.getElementById("toggleSidebar");

        toggleSidebar.addEventListener("click", () => {
            sidebar.classList.toggle("collapsed");
        });

        // DARK MODE TOGGLE
        const darkToggle = document.getElementById("darkModeToggle");
        const htmlElement = document.documentElement;

        darkToggle.addEventListener("click", () => {
            const current = htmlElement.getAttribute("data-theme");
            const nextTheme = current === "light" ? "dark" : "light";

            htmlElement.setAttribute("data-theme", nextTheme);

            darkToggle.classList.toggle("ri-moon-clear-line");
            darkToggle.classList.toggle("ri-sun-line");
        });

        // SIMPLE NOTIFICATION TOGGLE (if needed)
        document.querySelectorAll('.notification-btn')?.forEach(btn => {
            btn.addEventListener("click", () => {
                document.querySelector('.notification-dropdown')
                    ?.classList.toggle("show");
            });
        });
    </script>

</body>
</html>
