<?php
include('../../conection.php');
include('../vipaslookup.php');

if (!isset($_POST['id'])) {
    echo json_encode(["status" => "error", "message" => "No Booking ID Provided"]);
    exit;
}

$bookingId = intval($_POST['id']);

// ================================
// GET BOOKING MAIN DATA
// ================================
$bookingQuery = "
    SELECT b.*, 
           c.name AS customer_name, c.email, c.phone, 
           c.idproof, c.idproofnumber, c.idproofimage,
           rt.name AS roomtype_name, rt.description AS roomtype_desc, 
           rt.price AS roomtype_price, rt.occupancy, rt.bath,
           r.number AS room_number,
           ba.bankname, ba.accountno
    FROM booking b
    LEFT JOIN customers c ON b.customerId = c.Id
    LEFT JOIN roomtype rt ON b.room_type = rt.Id
    LEFT JOIN room r ON b.room = r.Id
    LEFT JOIN bankaccount ba ON ba.Id = b.bankaccountId
    WHERE b.Id = $bookingId
";

$result = $conn->query($bookingQuery);

if (!$result || $result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Booking Not Found"]);
    exit;
}

$row = $result->fetch_assoc();

// ================================
// BILLING CALCULATIONS
// ================================
$subtotal = floatval($row['subtotal']);
$discount = floatval($row['discount']);
$cgst = floatval($row['cgst']);
$sgst = floatval($row['sgst']);
$total = floatval($row['total_amount']);
$paid = floatval($row['amount_paid']);
$balance = $total - $paid;

// ================================
// PREPARE JSON RESPONSE
// ================================
$response = [
    "status" => "success",

    // CUSTOMER DETAILS
    "customer" => [
        "name"      => $row['customer_name'],
        "email"     => $row['email'],
        "phone"     => $row['phone'],
        "idproof"   => $row['idproof'],
        "idproofnumber" => $row['idproofnumber'],
        "idimage"   => $row['idproofimage']
    ],

    // ROOM TYPE DETAILS
    "roomtype" => [
        "name"          => $row['roomtype_name'],
        "description"   => $row['roomtype_desc'],
        "price"         => $row['roomtype_price'],
        "occupancy"     => $row['occupancy'],
        "bath"          => $row['bath']
    ],

    // ROOM DETAILS
    "room" => [
        "number" => $row['room_number']
    ],

    // BOOKING DETAILS
    "booking" => [
        "checkin"           => $row['checkin'],
        "checkout"          => $row['checkout'],
        "total_days"        => $row['total_days'],
        "adult"             => $row['adult'],
        "child"             => $row['child'],
        "payment_status"    => $row['payment_status'],
        "booking_status"    => $row['booking_status']
    ],

    // BILLING DETAILS
    "billing" => [
        "subtotal"      => number_format($subtotal, 2),
        "discount"      => number_format($discount, 2),
        "cgst"          => number_format($cgst, 2),
        "sgst"          => number_format($sgst, 2),
        "total"         => number_format($total, 2),
        "amount_paid"   => number_format($paid, 2),
        "balance"       => number_format($balance, 2)
    ],

    // BANK DETAILS
    "bank" => [
        "name" => $row['bankname'] . " (" . $row['accountno'] . ")"
    ]
];

echo json_encode($response);
?>
