<?php
include('../../conection.php');
header('Content-Type: application/json');

// Validate bookingId
if (!isset($_GET['bookingId']) || empty($_GET['bookingId'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Booking ID missing'
    ]);
    exit;
}

$bookingId = mysqli_real_escape_string($conn, $_GET['bookingId']);

// Fetch booking services
$query = "
    SELECT 
        Id,
        bookingId,
        serviceId,
        price,
        quantity,
        total,
        status
    FROM booking_services
    WHERE bookingId = '$bookingId'
";

$result = mysqli_query($conn, $query);

if (!$result || mysqli_num_rows($result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'No booking services found'
    ]);
    exit;
}

$services = [];

while ($row = mysqli_fetch_assoc($result)) {

    // Get service name from service table
    $serviceRes = mysqli_query(
        $conn,
        "SELECT name FROM service WHERE Id = '{$row['serviceId']}'"
    );

    $serviceRow = mysqli_fetch_assoc($serviceRes);

    // Add service name
    $row['serviceName'] = $serviceRow['name'] ?? 'Unknown';

    $services[] = $row;
}

// Final response
echo json_encode([
    'status' => 'success',
    'items'  => $services
]);
