<!-- <?php
include('../../conection.php');

$bookingId = intval($_GET['booking_id'] ?? 0);

/* Get already selected services for booking */
$existing = [];
$res = mysqli_query($conn, "
    SELECT serviceId, quantity 
    FROM booking_services 
    WHERE bookingId = $bookingId
");
while ($r = mysqli_fetch_assoc($res)) {
    $existing[$r['serviceId']] = $r['quantity'];
}

/* Fetch all active services */
$services = mysqli_query($conn, "
    SELECT Id, name, price 
    FROM services 
    WHERE status = 1
    ORDER BY name ASC
");

while ($row = mysqli_fetch_assoc($services)) {

    $checked = isset($existing[$row['Id']]);
    $qty     = $checked ? $existing[$row['Id']] : 1;
?>
<div class="service-row d-flex align-items-center mb-2 border rounded p-2">

    <div class="form-check me-3">
        <input class="form-check-input service-checkbox"
               type="checkbox"
               value="<?= $row['Id']; ?>"
               data-price="<?= $row['price']; ?>"
               <?= $checked ? 'checked' : '' ?>>
    </div>

    <div class="flex-grow-1">
        <strong><?= htmlspecialchars($row['name']); ?></strong><br>
        <small class="text-muted">₹ <?= number_format($row['price'], 2); ?></small>
    </div>

    <div>
        <input type="number"
               class="form-control service-qty"
               value="<?= $qty ?>"
               min="1"
               style="width:80px"
               <?= $checked ? '' : 'disabled' ?>>
    </div>

</div>
<?php } ?> -->

<?php
include('../../conection.php');

$bookingId = intval($_GET['booking_id'] ?? 0);

/*
|--------------------------------------------------------------------------
| Fetch UNPAID old services with PRIMARY KEY
|--------------------------------------------------------------------------
*/
$existing = [];

$q1 = mysqli_query($conn, "
    SELECT Id, serviceId, quantity
    FROM booking_services
    WHERE bookingId = $bookingId
    AND service_ispaid = 'unpaid'
");

while ($row = mysqli_fetch_assoc($q1)) {
    $existing[$row['serviceId']] = [
        'booking_service_id' => $row['Id'],
        'quantity'           => $row['quantity']
    ];
}

/*
|--------------------------------------------------------------------------
| Fetch ALL active services
|--------------------------------------------------------------------------
*/
$services = mysqli_query($conn, "
    SELECT Id, name, price
    FROM services
    WHERE status = 1
    ORDER BY name ASC
");
?>

<div id="servicesList">

<?php while ($service = mysqli_fetch_assoc($services)) :

    $checked = isset($existing[$service['Id']]);
    $qty     = $checked ? $existing[$service['Id']]['quantity'] : 1;
    $bsId    = $checked ? $existing[$service['Id']]['booking_service_id'] : '';
?>

<div class="service-row d-flex align-items-center mb-2 border rounded p-2">

    <!-- Checkbox -->
    <div class="form-check me-3">
        <input class="form-check-input service-checkbox"
               type="checkbox"
               name="services[]"
               value="<?= $service['Id']; ?>"
               data-booking-service-id="<?= $bsId; ?>"
               data-price="<?= $service['price']; ?>"
               <?= $checked ? 'checked' : '' ?>>
    </div>

    <!-- Service name -->
    <div class="flex-grow-1">
        <strong><?= htmlspecialchars($service['name']); ?></strong><br>
        <small class="text-muted">₹ <?= number_format($service['price'], 2); ?></small>
    </div>

    <!-- Quantity -->
    <div>
        <input type="number"
               class="form-control service-qty"
               name="quantity[<?= $service['Id']; ?>]"
               value="<?= $qty ?>"
               min="1"
               style="width:80px"
               <?= $checked ? '' : 'disabled' ?>>
    </div>

</div>

<?php endwhile; ?>

</div>

<script>
document.querySelectorAll('.service-checkbox').forEach(cb => {
    cb.addEventListener('change', function () {

        const row = this.closest('.service-row');
        const qty = row.querySelector('.service-qty');

        if (this.checked) {
            qty.disabled = false;
            if (qty.value <= 0) qty.value = 1;
        } else {
            qty.disabled = true;
            qty.value = 1;
        }
    });
});
</script>
