<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');

if (!isset($_GET['Id'])) {
    die("Invalid Request");
}

$bookingId = $_GET['Id'];

// Fetch booking
$selectbooking = mysqli_query($conn, "SELECT * FROM bookings WHERE Id = $bookingId");
$booking = mysqli_fetch_assoc($selectbooking);

if (!$booking) {
    die("Booking not found!");
}

// Fetch customer
$customerId = $booking['customerId'];
$cdata = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM customers WHERE Id = $customerId"));

// Fetch room type
$roomtypeId = $booking['roomtypeId'];
$roomType = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM roomtype WHERE Id = $roomtypeId"));

// Fetch payments
$transaction = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM transaction WHERE bookingId = $bookingId"));

// Calculation
$hours = (strtotime($booking['checkout']) - strtotime($booking['checkin'])) / 3600;
$totalDays = ceil($hours / 24);

$subtotal = $roomType['price'] * $totalDays;
$discount = $booking['discount'];
$gst = $booking['cgst'] + $booking['sgst'];
$grandTotal = $subtotal - $discount + $gst;

$paid = $transaction['Amount'];
$pending = $grandTotal - $paid;

// PROCESS FINAL CHECKOUT
if (isset($_POST['checkout_now'])) {

    // Update booking status
    mysqli_query($conn, "UPDATE bookings SET status='Checked Out', checkouttime=NOW() WHERE Id=$bookingId");

    // Optional: Insert checkout record
    mysqli_query($conn, "
        INSERT INTO checkout_history (bookingId, checkoutDate, pendingAmount)
        VALUES ($bookingId, NOW(), '$pending')
    ");

    echo "<script>alert('Checkout Completed Successfully!');window.location='bookingindex.php';</script>";
    exit;
}

?>

<!doctype html>
<html lang="en">
<body class="body-area">

<div class="container py-5">

<h3 class="mb-4">Final Checkout</h3>

<div class="card shadow-sm border-0">
<div class="card-body">

    <h5 class="fw-bold mb-3">Guest Summary</h5>

    <div class="row g-3">
        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Guest Name</small>
                <div class="fw-semibold"><?= $cdata['name'] ?></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Phone</small>
                <div class="fw-semibold"><?= $cdata['phone'] ?></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Room Type</small>
                <div class="fw-semibold"><?= $roomType['name'] ?></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Stay Duration</small>
                <div class="fw-semibold"><?= $totalDays ?> Days</div>
            </div>
        </div>
    </div>

    <hr>

    <h5 class="fw-bold mb-3">Payment Summary</h5>

    <div class="row g-3">
        <div class="col-md-4">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Subtotal</small>
                <div class="fw-semibold">₹<?= $subtotal ?></div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Discount</small>
                <div class="fw-semibold">₹<?= $discount ?></div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">GST</small>
                <div class="fw-semibold">₹<?= $gst ?></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Total Amount</small>
                <div class="fw-bold">₹<?= $grandTotal ?></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Paid Amount</small>
                <div class="fw-bold">₹<?= $paid ?></div>
            </div>
        </div>

        <div class="col-12">
            <div class="p-3 border rounded bg-light">
                <small class="text-muted">Pending Amount</small>
                <div class="fw-bold text-danger fs-5">
                    ₹<?= $pending ?>
                </div>
            </div>
        </div>

    </div>

</div>

<!-- FOOTER BUTTONS -->
<div class="card-footer text-end">
    <a href="bookingdetails.php?Id=<?= $bookingId ?>" class="btn btn-secondary">Back</a>

    <form method="POST" style="display:inline;">
        <a href="finalcheckout.php?Id=<?= $bookingId ?>" class="btn btn-success">Final Checkout</a>

    </form>
</div>

</div>

</div>

</body>
</html>
