<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../vipasbase.php');
include('../vipaslookup.php');

/* ================= READ INPUT ================= */
$data = json_decode(file_get_contents("php://input"), true);

$bookingId = intval($data['booking_id'] ?? 0);
$services  = $data['services'] ?? [];
$discount  = floatval($data['discount'] ?? 0);

$reference_number = mysqli_real_escape_string($conn, $data['reference_number'] ?? '');
$PaymentMethodId  = intval($data['payment_method'] ?? 0);
$bankAccountId    = intval($data['bank_account'] ?? 0);

$isPaid = !empty($data['isPaid']);
$servicePaidStatus = $isPaid ? 'paid' : 'unpaid';

$transactionDate = date('Y-m-d H:i:s');

mysqli_begin_transaction($conn);

try {

/* ================= EXISTING UNPAID SERVICES (WITH PK) ================= */
$existing = [];

$exRes = mysqli_query($conn, "
    SELECT Id, serviceId
    FROM booking_services
    WHERE bookingId = $bookingId
    AND service_ispaid = 'unpaid'
");

while ($r = mysqli_fetch_assoc($exRes)) {
    $existing[$r['serviceId']] = $r['Id']; // PK stored
}

/* ================= SERVICE SAVE ================= */
$subTotal = 0;
$receivedServiceIds = [];

foreach ($services as $s) {

    $serviceId = intval($s['service_id']);
    $qty       = intval($s['qty']);

    if ($serviceId <= 0 || $qty <= 0) continue;

    $receivedServiceIds[] = $serviceId;

    /* Fetch price */
    $srvQ = mysqli_query($conn, "
        SELECT price 
        FROM services 
        WHERE Id = $serviceId
        LIMIT 1
    ");

    if (!$srvQ || mysqli_num_rows($srvQ) === 0) continue;

    $srv   = mysqli_fetch_assoc($srvQ);
    $price = floatval($srv['price']);
    $total = $price * $qty;

    $subTotal += $total;

    if (isset($existing[$serviceId])) {

        /* UPDATE ONLY UNPAID ROW (USING PK) */
        $bsId = $existing[$serviceId];

        mysqli_query($conn, "
            UPDATE booking_services SET
                price = $price,
                quantity = $qty,
                total = $total,
                service_ispaid = '$servicePaidStatus'
            WHERE Id = $bsId
        ");

    } else {

        /* INSERT NEW SERVICE */
        mysqli_query($conn, "
            INSERT INTO booking_services
            (bookingId, serviceId, price, quantity, total, service_ispaid, createdby)
            VALUES
            ($bookingId, $serviceId, $price, $qty, $total, '$servicePaidStatus', $LoginUserId)
        ");
    }
}

/* ================= DELETE REMOVED UNPAID SERVICES ONLY ================= */
if ($servicePaidStatus === 'unpaid') {

    if (!empty($receivedServiceIds)) {

        $ids = implode(',', array_map('intval', $receivedServiceIds));

        mysqli_query($conn, "
            DELETE FROM booking_services
            WHERE bookingId = $bookingId
            AND service_ispaid = 'unpaid'
            AND serviceId NOT IN ($ids)
        ");

    } else {

        mysqli_query($conn, "
            DELETE FROM booking_services
            WHERE bookingId = $bookingId
            AND service_ispaid = 'unpaid'
        ");
    }
}

/* ================= FINAL TOTAL ================= */
$finalTotal = max(0, $subTotal - $discount);

/* ================= TRANSACTION (UNCHANGED LOGIC) ================= */
if ($servicePaidStatus === 'paid') {

    $serviceAccHeadId  = getAccIdBySubGrpCode($conn, 'SG');
    $bankAccHeadId     = getAccIdBySubGrpCode($conn, 'BA');
    $TransactionTypeId = getLocckUpId($conn,'TTCR');
    $ModTranTypeId     = getLocckUpId($conn,'TTDR');

    $paymentMethodDisplay = getLocckUpDisplayvalue($conn, $PaymentMethodId);

    /* MAIN TRANSACTION */
    mysqli_query($conn, "
        INSERT INTO transaction
        (bookingservicesId, AccountHeadId, TransactionDate,
         TransactionTypeId, ModTransactionTypeId,
         Amount, ReferenceNumber, PaymentMethodId, CreatedBy)
        VALUES
        ($bookingId, $serviceAccHeadId, '$transactionDate',
         $TransactionTypeId, $TransactionTypeId,
         $finalTotal, '$reference_number', $PaymentMethodId, $LoginUserId)
    ");

    $tranId = mysqli_insert_id($conn);

    /* BANK TRANSACTION */
    if ($paymentMethodDisplay !== 'Cash') {

        mysqli_query($conn, "
            INSERT INTO transaction
            (BankAccountId, AccountHeadId, TransactionDate,
             TransactionTypeId, ModTransactionTypeId,
             Amount, ReferenceNumber, PaymentMethodId,
             TranReferId, CreatedBy)
            VALUES
            ($bankAccountId, $bankAccHeadId, '$transactionDate',
             $TransactionTypeId, $ModTranTypeId,
             $finalTotal, '$reference_number', $PaymentMethodId,
             $tranId, $LoginUserId)
        ");

        $bankTranId = mysqli_insert_id($conn);

        mysqli_query($conn, "
            UPDATE transaction 
            SET TranReferId = $bankTranId 
            WHERE Id = $tranId
        ");
    }
}

mysqli_commit($conn);

/* ================= RESPONSE ================= */
echo json_encode([
    "status"  => true,
    "message" => "Room services and payment updated successfully"
]);

} catch (Exception $e) {

    mysqli_rollback($conn);

    echo json_encode([
        "status"  => false,
        "message" => "Transaction failed"
    ]);
}

/* ================= FUNCTION ================= */
function getAccIdBySubGrpCode($conn, $accsubgrpcode) {

    $Id = 0;
    $q = mysqli_query($conn, "
        SELECT Id 
        FROM headaccounts 
        WHERE AccSubGrpCode = '$accsubgrpcode'
        LIMIT 1
    ");

    if ($q && mysqli_num_rows($q) > 0) {
        $row = mysqli_fetch_assoc($q);
        $Id = intval($row['Id']);
    }
    return $Id;
}
