<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php 

 include('../../conection.php');
   include('../loginsection/loginsessionData.php');

include('../head.php'); 
include('../vipaslookup.php');
?>

<body class="body-area">

    <!-- preloader start -->
    <?php include('preloader.php'); ?>
    <!-- preloader end -->

     <!-- Start app-sidebar -->
        <?php include('../sidebar.php'); ?>
        <!-- end app-sidebar -->

        <!-- app-header -->
        <?php include('../nav.php'); ?>
        <!-- app-header -->
        <!-- app-content-area-start -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1"> Booking Index</h1>
                                <nav aria-label="breadcrumb">
                                    <!-- <ol class="breadcrumb breadcrumb-example1 mb-0">
                                        <li class="breadcrumb-item"><a href="javascript:void(0);">Home</a></li>
                                        <li class="breadcrumb-item" aria-current="page">Forms</li>
                                        <li class="breadcrumb-item active" aria-current="page">Data Table</li>
                                    </ol> -->
                                </nav>
                            </div>
                        </div>

                    
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Index</h4>
                                </div>
                            <?php 
if (isset($_SESSION['success']) && $_SESSION['success'] != '') {
?>
    <div class="alert alert-success alert-dismissible fade show auto-close">
        <?php echo $_SESSION['success']; 
        unset($_SESSION['success']);?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i class="ri-close-large-fill"></i>
        </button>
    </div>
<?php
} else if (isset($_SESSION['status']) && $_SESSION['status'] != '') {
?>
    <div class="alert alert-danger alert-dismissible fade show auto-close">
        <?php echo $_SESSION['status']; 
        unset($_SESSION['status']);?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            <i class="ri-close-large-fill"></i>
        </button>
    </div>
<?php
}
?>

<script>
    setTimeout(function () {
        let alerts = document.querySelectorAll('.auto-close');
        alerts.forEach(function (alert) {
            let bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        });
    }, 3000); // 5 seconds
</script>

                                  
                                <div class="card-body pt-15">
                                    <div class="d-flex justify-content-end">
                                       <a href="bookingcreate.php"> <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#responsiveModal">
                                            Add Booking
                                        </button></a>
                                    </div>

                                    <?php 
                                    
                                    $Selectroom ="SELECT * FROM bookings";
                                    $roomquery = mysqli_query($conn, $Selectroom);
                                $count =0;
                                    ?>
                                    <div class="table-responsive">
                                    <table id="responsivemodal-DataTable" class="table table-bordered text-nowrap w-100">
                                        <thead >
                                            <tr>
                                                <th>SL. No.</th>
                                                <th>Room Type</th>
                                                <th>Room Number</th>
                                                <th>Customer Name</th>
                                                <!-- <th>Phone</th> -->
                                                <!-- <th>ID Proof</th> -->
                                                <th>CheckIN</th>
                                                <!-- <th>CheckOUT</th> -->
                                                <th>Booking Status</th>
                                                <th>Service</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                                foreach($roomquery as $row)
                                    {
                                    
                                            ?>
                                            <tr>
                                                <td><?php echo ++$count; ?></td>
                                                
                                                <td>
    <?php
        // Get roomtypeId from bookings table
        $roomtypeId = $row['roomtypeId'];

        // Fetch room type name
        $roomTypeQuery = "SELECT name FROM roomtype WHERE Id = $roomtypeId";
        $roomTypeResult = mysqli_query($conn, $roomTypeQuery);

        if ($roomTypeResult && mysqli_num_rows($roomTypeResult) > 0) {
            $roomTypeRow = mysqli_fetch_assoc($roomTypeResult);
            echo $roomTypeRow['name'];
        } else {
            echo "N/A";
        }
    ?>
</td>

                                                <td><?php 
                                                
                                                $roomId = $row['roomId'];

                                                // echo $roomId;

                                                if ($roomId != 0) {
                                                     $roomQuery = "SELECT number FROM room WHERE Id = $roomId";
                                                $roomResult = mysqli_query($conn, $roomQuery);
                                                $roomRow = mysqli_fetch_assoc($roomResult);
                                                echo $roomRow['number'];
                                                }else{
                                                    echo "N/A";
                                                }
                                            
                                               
                                              

                                                
                                                ?></td>
                                                <td>
    <?php
        $customerId = $row['customerId'];

        $custQuery = "SELECT name FROM customers WHERE Id = $customerId";
        $custResult = mysqli_query($conn, $custQuery);

        if ($custResult && mysqli_num_rows($custResult) > 0) {
            $custRow = mysqli_fetch_assoc($custResult);
            echo $custRow['name'];
        } else {
            echo "N/A";
        }
    ?>
</td>

                                                <!-- <td><?php echo $row['phone']; ?></td> -->
                                                <!-- <td><?php echo $row['idproof']; ?></td> -->
                                                <td><?php echo date("d-m-Y", strtotime($row['checkin'])); ?></td>
                                                <!-- <td><?php echo date("d-m-Y", strtotime($row['checkout'])); ?></td> -->
                                                <td><?php echo $row['booking_status']; ?></td>
        

                                                <td>
                                                    <?php if ($row['roomId'] != 0) { ?>
<button 
    class="btn-icon btn-info-light serviceBtn"
    data-id="<?php echo $row['Id']; ?>"
    data-bs-toggle="modal"
    data-bs-target="#bookingServicesModal">
  <i class="ri-hotel-bed-fill"></i>
</button>

<?php } ?>
<?php if ($row['roomId'] == 0) { ?>
    <a href="assignroom.php?Id=<?php echo $row['Id']; ?>">
        <button class="btn-icon btn-warning-light" type="button">
          <i class="ri-login-box-line text-warning"></i>
        </button>
    </a>
<?php } ?>

</td>

                                            <td>
                                                   <div class="d-flex-items gap-10">
                                                    <a href="bookingcreateview.php?Id=<?php echo $row['Id']; ?>">
                                                        <button class="btn btn-success-light btn-icon viewBtn"
                                                            data-id="<?= $row['Id'] ?>" data-bs-toggle="modal"
                                                            data-bs-target="#viewBookingModal">
                                                            <i class="ri-eye-line"></i>
                                                        </button>
                                                    </a>

<button type="button" 
        class="btn-icon btn-danger-light deleteBtn" 
        data-id="<?php echo $row['Id']; ?>" 
        data-bs-toggle="modal" 
        data-bs-target="#deleteConfirmModal">
    <i class="ri-delete-bin-line"></i>
</button>
                                                          
                                                        </div>
                                            </td>
                                            </tr>
          <?php   }?>
   </tbody>
                                    </table>
                                  </div>                            
                                        
                                    <!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteConfirmModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <p>Are you sure you want to delete</p>
      </div>

      <div class="modal-footer">
        <form method="POST" action="code.php" id="deleteForm">
            <input type="hidden" name="Id" id="deleteId">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                Cancel
            </button>
            <button type="submit" name="deletebtn" class="btn btn-danger">
                Delete
            </button>
        </form>
      </div>

    </div>
  </div>
</div>
<!-- Booking Services Modal -->
<!-- Booking Services Modal -->
<!-- ================= BOOKING SERVICES MODAL ================= -->
<div class="modal fade" id="bookingServicesModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">

      <!-- HEADER -->
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title text-white">Room Services</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <!-- BODY -->
      <div class="modal-body">

        <input type="hidden" id="bookingId">

        <!-- SERVICES -->
        <div id="serviceList">Loading services...</div>

        <hr>

        <!-- DISCOUNT -->
        <div class="form-check mb-2">
          <input class="form-check-input" type="checkbox" id="applyDiscount">
          <label class="form-check-label fw-semibold">Apply Discount</label>
        </div>

        <div class="mb-3">
          <input type="number" class="form-control" id="discountAmount"
                 placeholder="Enter discount amount" disabled min="0">
        </div>

        <hr>

        <!-- TOTALS -->
        <div class="mt-3">
          <div class="d-flex justify-content-between">
            <span>Sub Total</span>
            <span>₹ <span id="subTotal">0.00</span></span>
          </div>

          <div class="d-flex justify-content-between text-danger">
            <span>Discount</span>
            <span>- ₹ <span id="discountShow">0.00</span></span>
          </div>

          <hr>

          <div class="d-flex justify-content-between fw-bold fs-16">
            <span>Grand Total</span>
            <span>₹ <span id="totalAmount">0.00</span></span>
          </div>
        </div>

        <div class="form-check">
          <input class="form-check-input" name="isPaid" type="checkbox" id="isPaid"  min="0" checked>
          <label class="form-check-label fw-semibold">Paid</label>
        </div>

        <hr>

        <!-- PAYMENT DETAILS -->
        <div class="row g-3">
          <h5 class="fw-bold">Payment Details</h5>

          <!-- PAYMENT METHOD -->
          <div class="col-md-4">
            <label class="form-label">Payment Method</label>
            <?php $modeList = getLocckUpListByGroupName('PaymentMethod', $conn); ?>
            <select id="paymetmethod" class="form-select" required>
              <?php
              foreach ($modeList as $id => $displayValue) {
                echo '<option value="'.$id.'">'.$displayValue.'</option>';
              }
              ?>
            </select>
          </div>

          <!-- BANK ACCOUNT -->
          <div class="col-md-4" id="bankAccountWrapper">
            <label class="form-label">Bank Account</label>
            <select class="form-select" id="bankaccountId">
              <option value="">Select Bank Account</option>
              <?php
              $bankAccounts = $conn->query("SELECT Id, bankname, accountno FROM bankaccount ORDER BY bankname");
              while ($row = $bankAccounts->fetch_assoc()) {
                echo '<option value="'.$row['Id'].'">'.$row['bankname'].' ('.$row['accountno'].')</option>';
              }
              ?>
            </select>
          </div>

          <!-- REFERENCE -->
          <div class="col-md-4">
            <label class="form-label">Reference Number</label>
            <input type="text" id="reference_number" class="form-control">
          </div>
        </div>

      </div>

      <!-- FOOTER -->
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button class="btn btn-success" id="saveServices">Save Services</button>
      </div>

    </div>
  </div>
</div>


<script>
document.addEventListener("DOMContentLoaded", function () {

    let bookingId = 0;

    const paymentMethod  = document.getElementById("paymetmethod");
    const bankWrapper    = document.getElementById("bankAccountWrapper");
    const bankAccount    = document.getElementById("bankaccountId");
    const applyDiscount  = document.getElementById("applyDiscount");
    const discountAmount = document.getElementById("discountAmount");
    const isPaidCheckbox = document.getElementById("isPaid");

    /* ===== PAYMENT METHOD TOGGLE ===== */
    function toggleBankAccount() {
        const text = paymentMethod.options[paymentMethod.selectedIndex].text.toLowerCase();
        if (text === "cash") {
            bankWrapper.style.display = "none";
            bankAccount.required = false;
            bankAccount.value = "";
        } else {
            bankWrapper.style.display = "block";
            bankAccount.required = true;
        }
    }
    toggleBankAccount();
    paymentMethod.addEventListener("change", toggleBankAccount);

    /* ===== LOAD SERVICES ===== */
    document.querySelectorAll(".serviceBtn").forEach(btn => {
        btn.addEventListener("click", function () {

            bookingId = this.dataset.id;
            document.getElementById("bookingId").value = bookingId;

            fetch("fetch_services.php?booking_id=" + bookingId)
                .then(res => res.text())
                .then(html => {
                    document.getElementById("serviceList").innerHTML = html;
                    calculateTotal();
                });
        });
    });

    /* ===== DISCOUNT ===== */
    applyDiscount.addEventListener("change", function () {
        discountAmount.disabled = !this.checked;
        if (!this.checked) discountAmount.value = "";
        calculateTotal();
    });

    /* ===== SERVICE EVENTS ===== */
    document.addEventListener("change", function (e) {

        if (e.target.classList.contains("service-checkbox")) {

            const row = e.target.closest(".service-row");
            const qty = row.querySelector(".service-qty");

            if (e.target.checked) {
                qty.disabled = false;
                if (qty.value <= 0) qty.value = 1;
            } else {
                qty.disabled = true;
                qty.value = 0;
            }
            calculateTotal();
        }

        if (
            e.target.classList.contains("service-qty") ||
            e.target.id === "discountAmount"
        ) {
            calculateTotal();
        }
    });

    /* ===== CALCULATE TOTAL ===== */
    function calculateTotal() {

        let subTotal = 0;

        document.querySelectorAll(".service-checkbox:checked").forEach(cb => {
            const row   = cb.closest(".service-row");
            const price = parseFloat(cb.dataset.price) || 0;
            const qty   = parseInt(row.querySelector(".service-qty").value) || 0;
            subTotal += price * qty;
        });

        let discount = applyDiscount.checked ? parseFloat(discountAmount.value) || 0 : 0;
        if (discount > subTotal) discount = subTotal;

        document.getElementById("subTotal").innerText     = subTotal.toFixed(2);
        document.getElementById("discountShow").innerText = discount.toFixed(2);
        document.getElementById("totalAmount").innerText  = (subTotal - discount).toFixed(2);
    }

    /* ===== SAVE SERVICES ===== */
    document.getElementById("saveServices").addEventListener("click", function () {

        let services = [];

        document.querySelectorAll(".service-checkbox:checked").forEach(cb => {
            const row = cb.closest(".service-row");
            const qty = parseInt(row.querySelector(".service-qty").value) || 0;
            if (qty > 0) {
                services.push({
                    service_id: cb.value,
                    qty: qty
                });
            }
        });

        if (services.length === 0) {
            alert("Please select at least one service");
            return;
        }

        const paymentText = paymentMethod.options[paymentMethod.selectedIndex].text.toLowerCase();

        if (paymentText !== "cash" && !bankAccount.value) {
            alert("Please select bank account");
            return;
        }

        fetch("bookingservicescode.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({
                booking_id: bookingId,
                services: services,
                payment_method: paymentMethod.value,
                bank_account: paymentText === "cash" ? 0 : bankAccount.value,
                reference_number: document.getElementById("reference_number").value,
                discount: applyDiscount.checked ? discountAmount.value : 0,
                isPaid: isPaidCheckbox.checked ? isPaidCheckbox.value : 0 
            })
        })
        .then(res => res.json())
        .then(resp => {
            alert(resp.message);
            location.reload();
        });
    });

});
</script>



                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        

        <!-- ===================================================== -->
<!-- VIEW BOOKING POPUP (ROW/COLUMN LAYOUT) -->
<!-- ===================================================== -->





        <div class="modal fade" id="deleteConfirmModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">

                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body text-center">
                        <p class="fw-bold">Are you sure you want to delete?</p>
                        <input type="hidden" id="deleteRoomTypeId">
                    </div>

                    <div class="modal-footer d-flex justify-content-between">
                        <button class="btn btn-secondary" data-bs-dismiss="modal">No</button>
                        <button class="btn btn-danger" id="confirmDeleteBtn">Yes, Delete</button>
                    </div>

                </div>
            </div>
        </div>


        <?php include('../footer.php'); ?>

   
        </div>
</body>

</html>