<!doctype html>
<html lang="en">

<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');
include('../vipasbase.php');

/* ===================== GET BOOKING ID ===================== */
$bookingId = intval($_GET['Id'] ?? 0);
if ($bookingId <= 0) {
    header("Location: bookingindex.php");
    exit;
}

/* ===================== FETCH BOOKING ===================== */
$bookingQ = mysqli_query($conn, "SELECT * FROM bookings WHERE Id=$bookingId");
$bookingrow = mysqli_fetch_assoc($bookingQ);
if (!$bookingrow) {
    header("Location: bookingindex.php");
    exit;
}

/* ===================== DATE CALC ===================== */
$checkin  = strtotime($bookingrow['checkin']);
$checkout = strtotime($bookingrow['checkout']);
$hours = ($checkout - $checkin) / 3600;
$days = $hours <= 24 ? 1 : ceil($hours / 24);

/* ===================== CUSTOMER ===================== */
$custQ = mysqli_query($conn, "SELECT * FROM customers WHERE Id=".$bookingrow['customerId']);
$customer = mysqli_fetch_assoc($custQ);

/* ===================== BALANCE ===================== */
$balance = $bookingrow['total_amount'] - $bookingrow['amount_paid'];

/* ===================== TRANSACTIONS ===================== */
$txnQ = mysqli_query($conn, "
    SELECT *
    FROM transaction
    WHERE bookingId = $bookingId
    ORDER BY TransactionDate DESC
");

/* ===================== HELPERS ===================== */



?>

<head>
<style>
body{background:#f4f6f9}
.card{border-radius:14px;box-shadow:0 6px 18px rgba(0,0,0,.06);border:0;margin-bottom:18px}
.card-header{background:#fff;border-bottom:1px solid #e9ecef;padding:18px}
.section-title{font-weight:600;border-bottom:1px dashed #ccc;margin-bottom:15px}
.form-view{background:#fff;padding:14px;border-radius:10px;border:1px solid #e9ecef}
.form-view small{color:#6c757d}
.billing-box{background:#fff;padding:18px;border-radius:12px;border:1px solid #e9ecef}
.action-bar{background:#fff;padding:16px;border-radius:14px;border:1px solid #e9ecef}
@media print{.btn,.sidebar,.navbar,.action-bar{display:none}}
</style>
</head>

<body>

<?php include('preloader.php'); ?>

<div class="page">
<?php include('../sidebar.php'); ?>
<?php include('../nav.php'); ?>

<div class="app-content-area">
<div class="container-fluid">

<!-- HEADER -->
<div class="card">
<div class="card-header d-flex justify-content-between">
<div>
<h4>Booking Code #<?= $bookingrow['bookingcode'] ?></h4>
<small><?= date('d-m-Y h:i A',strtotime($bookingrow['createddate'])) ?></small>
</div>
<div>
<span class="badge bg-success"><?= $bookingrow['booking_status'] ?></span>
<span class="badge bg-warning text-dark"><?= $bookingrow['payment_status'] ?></span>
</div>
</div>
</div>

<!-- GUEST -->
<div class="card"><div class="card-body">
<h5 class="section-title">👤 Guest Info</h5>
<div class="row">
<div class="col-md-4"><div class="form-view"><small>Name</small><p><?= $customer['name'] ?></p></div></div>
<div class="col-md-4"><div class="form-view"><small>Email</small><p><?= $customer['email'] ?></p></div></div>
<div class="col-md-4"><div class="form-view"><small>Phone</small><p><?= $customer['phone'] ?></p></div></div>
</div>
</div></div>

<!-- ROOM -->
<?php
$rt = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM roomtype WHERE Id=".$bookingrow['roomtypeId']));
$rm = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM room WHERE Id=".$bookingrow['roomId']));
?>
<div class="card"><div class="card-body">
<h5 class="section-title">🛏 Room & Stay</h5>
<div class="row">
<div class="col-md-3"><div class="form-view"><small>Room Type</small><p><?= $rt['name'] ?></p></div></div>
<div class="col-md-3"><div class="form-view"><small>Room No</small><p><?= $rm['number'] ?></p></div></div>
<div class="col-md-3"><div class="form-view"><small>Price / Day</small><p>₹<?= number_format($rt['price'],2) ?></p></div></div>
<div class="col-md-3"><div class="form-view"><small>Total Days</small><p><?= $days ?></p></div></div>
</div>
</div></div>

<!-- BILLING -->
<div class="card"><div class="card-body">
<h5 class="section-title">💳 Billing Summary</h5>
<div class="billing-box">
<div class="row text-center">
    <?php
    $total = $bookingrow['total_amount'];
    $discount = $bookingrow['discount'];
    $cgst = $bookingrow['cgst'];
    $sgst = $bookingrow['sgst'];
    $paid = $total - $discount + $cgst + $sgst;
    ?>
<div class="col-md-3"><small>Total</small><h6>₹<?= number_format($bookingrow['total_amount'],2) ?></h6></div>
<div class="col-md-3"><small>Discount</small><h6 class="text-danger">₹<?= number_format($bookingrow['discount'],2) ?></h6></div>
<div class="col-md-3"><small>Tax</small><h6>₹<?= number_format($bookingrow['cgst']+$bookingrow['sgst'],2) ?></h6></div>
<div class="col-md-3"><small>Paid</small><h6 class="text-success">₹<?= number_format($paid,2) ?></h6></div>
</div>
<hr>
<!-- <div class="text-center">
<small>Balance</small>
<h5 class="<?= $balance>0?'text-danger':'text-success' ?>">₹<?= number_format($balance,2) ?></h5>
</div> -->
</div>
</div></div>

<!-- TRANSACTIONS -->
<div class="card"><div class="card-body">
<h5 class="section-title">🧾 Bill Type & Transactions</h5>

<?php if(mysqli_num_rows($txnQ)): ?>
<table class="table table-bordered">
<thead class="table-light">
<tr>
<th>Date</th>
<td>VoucherNo</td>
<th>Bill Type</th>
<th>Payment</th>
<th>Amount</th>
<th>Reference</th>
<th>Remarks</th>
</tr>
</thead>
<tbody>
<?php while($t=mysqli_fetch_assoc($txnQ)): ?>
<tr>
<td><?= date('d-m-Y h:i A',strtotime($t['TransactionDate'])) ?></td>
<td><?= $t['VoucherNo']?></td>
<td><span class="badge bg-info"><?= getLocckUpDisplayvalue($conn,$t['TransactionTypeId']) ?></span></td>
<td><?= getLocckUpDisplayvalue($conn,$t['PaymentMethodId']) ?></td>
<td class="text-success fw-bold">₹<?= number_format($t['Amount'],2) ?></td>
<td><?= $t['ReferenceNumber'] ?: '-' ?></td>
<td><?= $t['Description'] ?: '-' ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
<?php else: ?>
<p class="text-muted">No transactions found.</p>
<?php endif; ?>

</div></div>

<!-- ACTIONS -->
<div class="action-bar d-flex justify-content-between">
<div>
<?php if($bookingrow['booking_status']=='Confirmed'): ?>
<a href="checkout.php?id=<?= $bookingId ?>" class="btn btn-warning">Check Out</a>
<?php endif; ?>
</div>
<div>
<a href="edit.php?id=<?= $bookingId ?>" class="btn btn-primary">Edit</a>
<?php if($bookingrow['booking_status']!='Confirmed'): ?>
<a href="cancel_booking.php?id=<?= $bookingId ?>" class="btn btn-danger">Cancel</a>
<?php endif; ?>
</div>
</div>

</div>
</div>
</div>

<?php include('../footer.php'); ?>
</body>
</html>
