<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">

<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');
include('../vipasbase.php');
?>

<body class="body-area">

    <!-- Preloader -->
    <?php include('preloader.php'); ?>

    <div class="page">

        <!-- Sidebar -->
        <?php include('../sidebar.php'); ?>

        <!-- Navbar -->
        <?php include('../nav.php'); ?>

        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Booking Create</h1>
                            </div>
                        </div>
                        <form method="POST" action="code.php" enctype="multipart/form-data">

                            <?php
$query = mysqli_query($conn, "SELECT VoucherNo FROM transaction ORDER BY Id DESC LIMIT 1");
$row   = mysqli_fetch_assoc($query);

$OrgNamePrefix = getdefultConfigValue($conn,"bookingvocherPrefix","ValString");

// If records exist, increment number
if($row && !empty($row['VoucherNo'])){


    // Extract number part (removing prefix A-)
    $lastNumber = intval(str_replace($OrgNamePrefix, "", $row['VoucherNo']));

    // Increment number
    $nextNumber = $lastNumber + 1;

    // Format back 5 digits
    $VoucherNo = $OrgNamePrefix . str_pad($nextNumber, 5, "0", STR_PAD_LEFT);

} else {
    // First registration starts at A-00001
    $VoucherNo = $OrgNamePrefix."00001";
}

// echo $regno; // Final Generated RegNo
?>

                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h4 class="card-title mb-0">Add New Booking</h4>

                                        <div class="text-end">
                                            <h5 class="mb-0 fw-bold text-primary">
                                                <span style="font-size: 18px; color: #000;"> Voucher No: </span> <br>
                                                <b> <?php echo $VoucherNo; ?></b>
                                            </h5>
                                            <input type="hidden" name="VoucherNo" value="<?php echo $VoucherNo; ?>">
                                        </div>
                                    </div>


                                    <div class="card-body pt-15">

                                        <!-- START FORM -->


                                        <div class="row g-3">
                                            <!-- SECTION: ROOM DETAILS -->
                                            <h5 class="mt-3 mb-0 fw-bold text-primary">Room Details</h5>

                                            <hr>

                                            <div class="col-md-6">
                                                <label class="form-label">Room Type <span
                                                        class="text-danger">*</span></label>
                                                <select name="room_type" id="room_type" class="form-select">
                                                    <option value="">Select Room Type</option>

                                                    <?php
                                                $roomTypes = mysqli_query($conn, "SELECT * FROM roomtype WHERE status = 1 ORDER BY orderby ASC");
                                                foreach ($roomTypes as $row) {
                                                    $roomtypeId = $row['Id'];
//                                                     // availability calculation
$statusId = getLocckUpId($conn,'RAVL');

$totalRooms = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM room WHERE room_type=$roomtypeId AND status = $statusId"));
$bookedRooms = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM bookings WHERE roomtypeId=$roomtypeId AND booking_status='Confirmed'")) ?? 0;
$availableRooms = $totalRooms - $bookedRooms;

                                                ?>

                                                    <option value="<?= $row['Id'] ?>">
                                                        <?php echo htmlspecialchars($row['name']) ?>
                                                        (<?php echo $availableRooms ?> )
                                                    </option>
                                                    <?php } ?>
                                                </select>
                                            </div>

                                            <div class="col-md-6">
                                                <label class="form-label">Available Rooms <span
                                                        class="text-danger">*</span></label>
                                                <select name="room" id="room_list" class="form-select">
                                                    <option value="">Select Room</option>
                                                </select>
                                            </div>

                                            <div class="col-md-12 mt-3">
                                                <div id="room_details" class="p-3 border rounded "
                                                    style="display:none; background:#e3f2fd;">
                                                    <h6 class="fw-bold mb-2">Room Details</h6>
                                                    <p><strong>Price:</strong> ₹<span id="rt_price"></span></p>
                                                    <p><strong>GST Slab:</strong><span id="rt_gstslab"></span></p>
                                                    <p><strong>Occupancy:</strong> <span id="rt_occupancy"></span></p>
                                                    <p><strong>Bath:</strong> <span id="rt_bath"></span></p>
                                                    <p><strong>Description:</strong> <span id="rt_description"></span>
                                                    </p>
                                                </div>
                                            </div>


                                            <!-- SECTION: CUSTOMER DETAILS -->
                                            <h5 class="mt-4 mb-0 fw-bold text-primary">Guest Information</h5>
                                            <hr>

                                            <div class="col-md-4">
                                                <label class="form-label">Guest Full Name <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" name="name" class="form-control">
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Email Address <span
                                                        class="text-danger">*</span></label>
                                                <input type="email" name="email" class="form-control">
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Mobile Number <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" name="phone" maxlength="10" class="form-control">
                                            </div>

                                            <div class="col-md-6">
                                                <label class="form-label">ID Proof <span
                                                        class="text-danger">*</span></label>

                                                <?php
        // Fetch list from lookup table
        $idProofList = getLocckUpListByGroupName('IDPROOF', $conn);
    ?>

                                                <select name="idproof" class="form-control">
                                                    <option value="">Select ID Proof</option>

                                                    <?php
        if (!empty($idProofList)) {
            foreach ($idProofList as $id => $displayValue) {
                echo '<option value="' . htmlspecialchars($id) . '">' . htmlspecialchars($displayValue) . '</option>';
            }
        } else {
            echo '<option disabled>No ID Proof found</option>';
        }
        ?>
                                                </select>
                                            </div>
                                            <!-- Capture Photo Section -->
                                            <div class="col-md-6 col-12 mt-3">
                                                <label class="form-label">Capture Photo <span
                                                        class="text-danger">*</span></label>

                                                <!-- Live Camera Preview -->
                                                <video id="cameraPreview" width="100%" height="250" autoplay
                                                    class="border rounded mb-2" style="display:none;"></video>

                                                <!-- Captured Image Preview -->
                                                <canvas id="capturedCanvas" width="400" height="250"
                                                    class="border rounded mb-2" style="display:none;"></canvas>

                                                <div class="d-flex gap-2 mb-2">
                                                    <button type="button" class="btn btn-primary" onclick="openCamera()"
                                                        id="openBtn">Open Camera</button>
                                                    <button type="button" class="btn btn-success"
                                                        onclick="capturePhoto()" id="captureBtn"
                                                        disabled>Capture</button>
                                                    <button type="button" class="btn btn-warning"
                                                        onclick="retakePhoto()" id="retakeBtn"
                                                        style="display:none;">Retake</button>
                                                    <button type="button" class="btn btn-danger"
                                                        onclick="closeCamera()">Close</button>
                                                </div>

                                                <!-- Hidden input to store captured photo -->
                                                <input type="hidden" name="capturedImage" id="capturedImageInput">
                                            </div>




                                            <div class="col-md-6">
                                                <label class="form-label">ID Proof Number <span
                                                        class="text-danger">*</span></label>
                                                <input type="text" name="idproofnumber" class="form-control"
                                                    placeholder="Enter ID Number">
                                            </div>

                                            <!-- <div class="col-md-6">
                                            <label class="form-label">Upload ID Proof Image <span class="text-danger">*</span></label>
                                            <input type="file" name="idproofimage" class="form-control" accept="image/*" >
                                        </div> -->


                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <label for="exampleInputName1">Upload ID Proof Image <span
                                                            class="text-danger">*</span></label>
                                                    <input type="file" name="idproofimage" class="form-control"
                                                        id="userName" onchange="previewImage(this)" accept="image/*"
                                                        placeholder="Enter Name">
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="form-group">
                                                    <div id="imagePreview"
                                                        class="col-lg-4 col-md-4 col-sm-12 mb-3 text-center">
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- SECTION: STAY DURATION -->
                                            <h5 class="mt-4 mb-0 fw-bold text-primary">Stay Duration</h5>
                                            <hr>


                                            <div class="col-md-3">
                                                <label class="form-label">Check-In <span
                                                        class="text-danger">*</span></label>
                                                <input type="datetime-local" name="checkin" id="checkin" value=""
                                                    class="form-control datetimepicker-input">

                                                <!-- <input class="form-control" name="name" id="datetime-local" type="" value="2024-12-28T12:30:00"> -->
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Check-Out <span
                                                        class="text-danger">*</span></label>
                                                <input type="datetime-local" name="checkout" id="checkout"
                                                    class="form-control datetimepicker-input">
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Adult <span
                                                        class="text-danger">*</span></label>
                                                <select type="number" name="adult" class="form-control">
                                                    <option value="">Select Adult</option>
                                                    <option value="0">0</option>
                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                    <option value="4">4</option>
                                                    <option value="5">5</option>
                                                </select>
                                            </div>

                                            <div class="col-md-3">
                                                <label class="form-label">Child <span
                                                        class="text-danger">*</span></label>
                                                <select type="number" name="child" class="form-control">
                                                    <option value="">Select Child</option>
                                                    <option value="0">0</option>
                                                    <option value="1">1</option>
                                                    <option value="2">2</option>
                                                    <option value="3">3</option>
                                                    <option value="4">4</option>
                                                    <option value="5">5</option>
                                                </select>
                                            </div>

                                            <!-- SECTION: PAYMENT DETAILS -->
                                            <h5 class="mt-4 mb-0 fw-bold text-primary">Payment & Status</h5>
                                            <hr>

                                            <div class="col-md-4">
                                                <label class="form-label">Room Price (Per Day)</label>
                                                <input type="text" id="price_per_day" class="form-control" readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Total Days</label>
                                                <input type="text" id="total_days" name="total_days"
                                                    class="form-control" value="1" readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Subtotal</label>
                                                <input type="text" id="subtotal" name="subtotal" class="form-control"
                                                    readonly>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Discount (₹)</label>
                                                <input type="number" id="discount" name="discount" value="0"
                                                    class="form-control">
                                            </div>
                                            <div class="col-md-4">
                                                <label id="cgst_label">CGST (0%)</label>
                                                <input type="number" id="cgst" name="cgst" class="form-control"
                                                    readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label id="sgst_label">SGST (0%)</label>
                                                <input type="number" id="sgst" name="sgst" class="form-control"
                                                    readonly>
                                            </div>



                                            <div class="col-md-4">
                                                <label class="form-label">Grand Total</label>
                                                <input type="text" id="total_amount" name="total_amount"
                                                    class="form-control text-primary fw-bold" readonly>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Amount Paid</label>
                                                <input type="number" name="amount_paid" step="0.01" id="amount_paid"
                                                    class="form-control">
                                            </div>

                                            <!-- <div class="col-md-4">
                                            <label class="form-label">Balance Amount</label>
                                            <input type="text" name="balance" id="balance" class="form-control" readonly>
                                        </div> -->

                                            <!-- <div class="col-md-4">
                                            <label class="form-label">Payment Status</label>
                                            <select name="payment_status" class="form-select" >
                                                <option value="">Select</option>
                                                <option value="Confirmed">Paid</option>
                                                <option value="Pending">Pending</option>
                                            </select>
                                        </div> -->

                                            <!-- <div class="col-md-4">
                                            <label class="form-label">Booking Status</label>
                                            <select name="booking_status" class="form-select" >
                                                <option value="">Select</option>
                                                <option value="Confirmed">Confirmed</option>
                                                <option value="Pending">Pending</option>
                                            </select>
                                        </div> -->


                                            <div class="col-md-4">
                                                <label class="form-label">Payment Method</label>

                                                <?php
        // Fetch list from lookup table
        $modeList = getLocckUpListByGroupName('PaymentMethod', $conn);
    ?>

                                                <select name="paymetmethod" id="paymetmethod" class="form-select"
                                                    required>
                                                    <!-- <option value="">Select Mode</option> -->

                                                    <?php
        if (!empty($modeList)) {
            foreach ($modeList as $id => $displayValue) {
                echo '<option value="' . htmlspecialchars($id) . '">' . htmlspecialchars($displayValue) . '</option>';
            }
        } else {
            echo '<option disabled>No Payment Modes Found</option>';
        }
        ?>
                                                </select>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="bankaccountId" class="form-label">Bank Account</label>
                                                    <select class="form-control" name="bankaccountId"
                                                        id="bankaccountId">
                                                        <option value="">Select Bank Account</option>
                                                        <?php
            $getBankAccounts = "SELECT Id, bankname, accountno FROM bankaccount ORDER BY bankname";
            $bankAccounts = $conn->query($getBankAccounts);

            if ($bankAccounts && $bankAccounts->num_rows > 0) {
                while ($row = $bankAccounts->fetch_assoc()) {

                    // Display format: HDFC Bank (1234567890)
                    $label = htmlspecialchars($row['bankname'] . " (" . $row['accountno'] . ")");

                    echo '<option value="' . $row['Id'] . '">' . $label . '</option>';
                }
            }
            ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <label class="form-label">Reffernce Number</label>
                                                <input type="text" name="reference_number" class="form-control">
                                            </div>







                                            <!-- SUBMIT BUTTON -->
                                            <div class="col-12 d-flex justify-content-end mt-3">
                                                <a href="bookingindex.php" class="btn btn-danger me-2">Cancel</a>
                                                <button class="btn btn-primary px-4" name="create" type="submit">Submit
                                                    Booking</button>
                                            </div>
                                        </div>
                        </form>
                        <!-- END FORM -->

                    </div>

                </div>
            </div>

        </div>

    </div>
    </div>
    </div>

    <!-- Footer -->
    <?php include('../footer.php'); ?>

    </div>


    <!-- ======================= JAVASCRIPT ======================== -->

    <script>
    $(document).ready(function() {
        $('a[href="https://www.froala.com/wysiwyg-editor?k=u"]').hide();
    });

    function previewImage(input) {
        var preview = document.getElementById('imagePreview');
        preview.innerHTML = '';
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                var img = document.createElement('img');
                img.src = e.target.result;
                img.className = "img-fluid";
                preview.appendChild(img);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
    </script>

    <script>
    document.addEventListener("DOMContentLoaded", function() {

        /* ================= PAYMENT METHOD ================= */
        const paymentMethod = document.getElementById("paymetmethod");
        const bankAccount = document.getElementById("bankaccountId");

        if (paymentMethod && bankAccount) {
            function toggleBank() {
                const selectedText = paymentMethod.options[paymentMethod.selectedIndex].text.trim()
                .toLowerCase();

                if (selectedText === "cash") {
                    bankAccount.disabled = true;
                    bankAccount.required = false;
                    bankAccount.value = "";
                } else {
                    bankAccount.disabled = false;
                    bankAccount.required = true;
                }
            }
            toggleBank();
            paymentMethod.addEventListener("change", toggleBank);
        }

        /* ================= ROOM TYPE CHANGE ================= */
        document.getElementById("room_type").addEventListener("change", function() {

            let typeId = this.value;
            if (!typeId) return;

            fetch("getRoomDetails.php?room_type=" + typeId)
                .then(res => res.json())
                .then(data => {

                    if (data.status !== "success") return;

                    document.getElementById("room_details").style.display = "block";

                    let price = parseFloat(data.roomtype.price) || 0;

                    document.getElementById("rt_price").innerText = price;
                    document.getElementById("rt_occupancy").innerText = data.roomtype.occupancy;
                    document.getElementById("rt_bath").innerText = data.roomtype.bath;
                    document.getElementById("rt_description").innerText = data.roomtype.description;

                    let roomSelect = document.getElementById("room_list");

                    roomSelect.innerHTML = "<option value=''>Select Room</option>";

                    data.rooms.forEach(room => {
                        roomSelect.innerHTML +=
                            `<option value="${room.Id}">${room.number}</option>`;
                    });


                    document.getElementById("price_per_day").value = price;
                    document.getElementById("total_days").value = 1;




                    /* ===== FETCH GST SLAB ===== */
                    fetch("get_gstslab.php", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/x-www-form-urlencoded"
                            },
                            body: "slabId=" + data.roomtype.GSTSlab
                        })
                        .then(res => res.text())
                        .then(gst => {
                            document.getElementById("rt_gstslab").innerText = gst.trim();
                            calculateAmount(); // recalc AFTER GST loaded
                        });

                });
        });

        /* ================= LISTENERS ================= */
        document.getElementById("checkin").addEventListener("change", calculateDays);
        document.getElementById("checkout").addEventListener("change", calculateDays);
        document.getElementById("discount").addEventListener("input", calculateAmount);
        document.getElementById("amount_paid").addEventListener("input", calculateAmount);

        /* ================= CALCULATE DAYS ================= */
        function calculateDays() {
            let checkinVal = document.getElementById("checkin").value;
            let checkoutVal = document.getElementById("checkout").value;

            if (!checkinVal || !checkoutVal) {
                document.getElementById("total_days").value = 1;
                calculateAmount();
                return;
            }

            let checkin = new Date(checkinVal);
            let checkout = new Date(checkoutVal);

            if (checkout <= checkin) {
                document.getElementById("total_days").value = 1;
                calculateAmount();
                return;
            }

            let diffMs = checkout - checkin;
            let hours = diffMs / (1000 * 60 * 60);

            let days;
            if (hours <= 24) {
                days = 1; // ✅ exactly 24 hours = 1 day
            } else {
                days = Math.ceil(hours / 24);
            }

            document.getElementById("total_days").value = days;
            calculateAmount();
        }


        /* ================= CALCULATE AMOUNT ================= */
        function calculateAmount() {

            let price = parseFloat(document.getElementById("price_per_day").value) || 0;
            let days = parseFloat(document.getElementById("total_days").value) || 1;
            let discount = parseFloat(document.getElementById("discount").value) || 0;
            let paid = parseFloat(document.getElementById("amount_paid").value) || 0;

            let subtotal = price * days;
            let afterDiscount = subtotal - discount;

            let gstText = document.getElementById("rt_gstslab").innerText.trim();

            let gstRate = 0;
            let halfPercent = 0;

            if (gstText === "5%") {
                gstRate = 0.05;
                halfPercent = 2.5;
            } else if (gstText === "12%") {
                gstRate = 0.12;
                halfPercent = 6;
            } else if (gstText === "18%") {
                gstRate = 0.18;
                halfPercent = 9;
            } else if (gstText === "28%") {
                gstRate = 0.28;
                halfPercent = 14;
            }

            /* 🔁 UPDATE LABELS */
            document.getElementById("cgst_label").innerText = `CGST (${halfPercent}%)`;
            document.getElementById("sgst_label").innerText = `SGST (${halfPercent}%)`;

            let gst = afterDiscount * gstRate;
            let cgst = gst / 2;
            let sgst = gst / 2;
            let total = afterDiscount + gst;
            let balance = total - paid;

            document.getElementById("subtotal").value = subtotal.toFixed(2);
            document.getElementById("cgst").value = cgst.toFixed(2);
            document.getElementById("sgst").value = sgst.toFixed(2);
            document.getElementById("total_amount").value = total.toFixed(2);
            document.getElementById("amount_paid").value = total.toFixed(2);
        }

    });
    </script>



    <script>
    let stream = null;

    // Open Camera
    function openCamera() {
        const video = document.getElementById("cameraPreview");
        const captureBtn = document.getElementById("captureBtn");

        navigator.mediaDevices.getUserMedia({
                video: true
            })
            .then(s => {
                stream = s;
                video.srcObject = s;
                video.style.display = "block";
                captureBtn.disabled = false; // Enable capture button
            })
            .catch(err => {
                alert("Camera permission denied!");
            });
    }

    // Capture Photo
    function capturePhoto() {
        const video = document.getElementById("cameraPreview");
        const canvas = document.getElementById("capturedCanvas");
        const hiddenInput = document.getElementById("capturedImageInput");
        const retakeBtn = document.getElementById("retakeBtn");

        // Draw image on canvas
        canvas.style.display = "block";
        const context = canvas.getContext("2d");
        context.drawImage(video, 0, 0, canvas.width, canvas.height);

        // Stop camera stream
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
        }

        // Hide video, show canvas preview
        video.style.display = "none";

        // Save Base64
        hiddenInput.value = canvas.toDataURL("image/png");

        // Show Retake button
        retakeBtn.style.display = "inline-block";
    }

    // Retake Photo
    function retakePhoto() {
        const video = document.getElementById("cameraPreview");
        const canvas = document.getElementById("capturedCanvas");
        const retakeBtn = document.getElementById("retakeBtn");
        const captureBtn = document.getElementById("captureBtn");

        // Hide old captured image
        canvas.style.display = "none";

        // Hide retake button until next capture
        retakeBtn.style.display = "none";

        // Restart camera
        openCamera();

        video.style.display = "block";
        captureBtn.disabled = false;
    }

    // Close Camera
    function closeCamera() {
        const video = document.getElementById("cameraPreview");
        const captureBtn = document.getElementById("captureBtn");

        if (stream) {
            stream.getTracks().forEach(track => track.stop());
        }

        video.style.display = "none";
        captureBtn.disabled = true;
    }
    </script>


</body>

</html>