<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">

<?php
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php');
include('../vipaslookup.php');

$bookingId = $_GET['Id'];

$selectbooking = mysqli_query($conn, "SELECT * FROM bookings WHERE Id = $bookingId");
$bookingdata = mysqli_fetch_assoc($selectbooking);

$customerId = $bookingdata['customerId'];
$selectcustomer = mysqli_query($conn, "SELECT * FROM customers WHERE Id = $customerId");
$customerdata = mysqli_fetch_assoc($selectcustomer);

$roomtypeId = $bookingdata['roomtypeId'];
$selectroomtype = mysqli_query($conn, "SELECT * FROM roomtype WHERE Id = $roomtypeId");
$roomtypedata = mysqli_fetch_assoc($selectroomtype);

$selecttransaction = mysqli_query($conn, "SELECT * FROM transaction WHERE bookingId = $bookingId");
$transactiondata = mysqli_fetch_assoc($selecttransaction);
?>

<body class="body-area">

<?php include('preloader.php'); ?>

<div class="page">

<?php include('../sidebar.php'); ?>
<?php include('../nav.php'); ?>

<div class="app-content-area">
<div class="container-fluid">

<h4 class="mb-3">Booking Details</h4>

<div class="row">

    <!-- ================= LEFT COLUMN ================= -->
    <div class="col-lg-12">

    <div class="row">
        <!-- ROOM DETAILS -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm" style="border-radius:12px;">
                <div class="card-body">

                    <h6 class="fw-bold mb-3 pb-2" style="border-bottom:1px solid #eaeaea;">Room Details</h6>

                    <div class="row g-3">

                        <div class="col-12">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Booking Mode</div>
                                <div class="fw-semibold mt-1"><?= $bookingdata['modeofbooking'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Room Type</div>
                                <div class="fw-semibold mt-1"><?= $roomtypedata['name'] ?></div>
                                <input type="hidden" id="roomtypeId" value="<?= $roomtypedata['Id'] ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Price / Day</div>
                                <div class="fw-semibold mt-1">₹<?= $roomtypedata['price'] ?></div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>

        <!-- GUEST INFORMATION -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm" style="border-radius:12px;">
                <div class="card-body">

                    <h6 class="fw-bold mb-3 pb-2" style="border-bottom:1px solid #eaeaea;">Guest Information</h6>

                    <div class="row g-3">

                        <div class="col-12">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Name</div>
                                <div class="fw-semibold mt-1"><?= $customerdata['name'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Email</div>
                                <div class="fw-semibold mt-1"><?= $customerdata['email'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Phone</div>
                                <div class="fw-semibold mt-1"><?= $customerdata['phone'] ?></div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>

        <!-- STAY DURATION -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm" style="border-radius:12px;">
                <div class="card-body">

                    <h6 class="fw-bold mb-3 pb-2" style="border-bottom:1px solid #eaeaea;">Stay Duration</h6>

                    <div class="row g-3">

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Check-In</div>
                                <div class="fw-semibold mt-1"><?= $bookingdata['checkin'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Check-Out</div>
                                <div class="fw-semibold mt-1"><?= $bookingdata['checkout'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Adults</div>
                                <div class="fw-semibold mt-1"><?= $bookingdata['adult'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Children</div>
                                <div class="fw-semibold mt-1"><?= $bookingdata['child'] ?></div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>

    </div>
    </div>


    <!-- ================= RIGHT COLUMN ================= -->
    <div class="col-lg-12">

        <!-- PAYMENT DETAILS -->
        <div class="mb-4">
            <div class="card border-0 shadow-sm" style="border-radius:12px;">
                <div class="card-body">

                    <h6 class="fw-bold mb-3 pb-2" style="border-bottom:1px solid #eaeaea;">Payment Details</h6>

                    <div class="row g-3">

                        <?php 
                        $hours = (strtotime($bookingdata['checkout']) - strtotime($bookingdata['checkin'])) / 3600;
                        $totalDays = ceil($hours / 24);
                        ?>

                        <div class="col-md-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Total Days</div>
                                <div class="fw-semibold mt-1"><?= $totalDays ?></div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Subtotal</div>
                                <div class="fw-semibold mt-1">₹<?= $roomtypedata['price'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Discount</div>
                                <div class="fw-semibold mt-1">₹<?= $bookingdata['discount'] ?></div>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">GST</div>
                                <div class="fw-semibold mt-1">
                                    CGST: ₹<?= $bookingdata['cgst'] ?><br>
                                    SGST: ₹<?= $bookingdata['sgst'] ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Total Amount</div>
                                <div class="fw-bold fs-6 mt-1"><?= $transactiondata['Amount'] ?></div>
                            </div>
                        </div>

                        <div class="col-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Paid Amount</div>
                                <div class="fw-semibold mt-1"><?= $transactiondata['Amount'] ?></div>
                            </div>
                        </div>

                        <div class="col-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Payment Method</div>
                                <div class="fw-semibold mt-1"><?= getLocckUpDisplayvalue($conn, $transactiondata['PaymentMethodId']); ?></div>
                            </div>
                        </div>

                        <div class="col-3">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Bank Account</div>
                                <div class="fw-semibold mt-1"><?= $bankdata['bankname']; ?></div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="p-3 border rounded" style="background:#fafafa;">
                                <div class="text-muted small">Reference No</div>
                                <div class="fw-semibold mt-1"><?= $transactiondata['ReferenceNumber'] ?: '—' ?></div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>

    </div>

</div>



<!-- ======================= CARD 2: CHECK-IN REQUIREMENTS ======================= -->
<div class="card shadow-sm">
<div class="card-body">

<h5 class="text-primary fw-bold">Check-In Requirements</h5>
<hr>

<form action="code.php" method="POST" enctype="multipart/form-data">
<div class="row g-4">

    <!-- AVAILABLE ROOMS -->
    <div class="col-md-6">
        <label class="form-label">Available Rooms <span class="text-danger">*</span></label>
        <select name="roomId" id="room_list" class="form-select">
            <option value="">Select Room</option>
        </select>
    </div>

    <!-- ID PROOF -->
    <div class="col-md-6">
        <label class="form-label">ID Proof <span class="text-danger">*</span></label>

        <?php $idProofList = getLocckUpListByGroupName('IDPROOF', $conn); ?>

        <select name="idproof" class="form-control">
            <option value="">Select ID Proof</option>
            <?php foreach ($idProofList as $id => $displayValue) { ?>
                <option value="<?= $id ?>"><?= $displayValue ?></option>
            <?php } ?>
        </select>
    </div>

    <!-- CAPTURE PHOTO -->
    <div class="col-md-12">
        <label class="form-label">Capture Photo <span class="text-danger">*</span></label>

        <video id="cameraPreview" width="100%" height="250" autoplay class="border rounded mb-2" style="display:none;"></video>
        <canvas id="capturedCanvas" width="400" height="250" class="border rounded mb-2" style="display:none;"></canvas>

        <div class="d-flex gap-2 mb-2">
            <button type="button" class="btn btn-primary" onclick="openCamera()" id="openBtn">Open Camera</button>
            <button type="button" class="btn btn-success" onclick="capturePhoto()" id="captureBtn" disabled>Capture</button>
            <button type="button" class="btn btn-warning" onclick="retakePhoto()" id="retakeBtn" style="display:none;">Retake</button>
            <button type="button" class="btn btn-danger" onclick="closeCamera()">Close</button>
        </div>

        <input type="hidden" name="capturedImage" id="capturedImageInput">
    </div>

    <!-- ID PROOF NUMBER -->
    <div class="col-md-6">
        <label class="form-label">ID Proof Number <span class="text-danger">*</span></label>
        <input type="text" name="idproofnumber" class="form-control" placeholder="Enter ID Number">
    </div>

    <!-- ID PROOF IMAGE UPLOAD -->
    <div class="col-md-6">
        <label class="form-label">Upload ID Proof Image <span class="text-danger">*</span></label>
        <input type="file" name="idproofimage" class="form-control" accept="image/*" onchange="previewImage(this)">
    </div>

    <div class="col-md-6">
        <div id="imagePreview" class="text-center"></div>
    </div>

</div>

<input type="hidden" name="bookingId" value="<?=  $bookingId ?>">
<input type="hidden" name="customerId" value="<?= $customerId ?>">
<!-- BUTTON FOOTER -->
<div class="card-footer text-end">
    <a href="bookingindex.php" class="btn btn-secondary">Back</a>
    <button type="submit" name="assignroombtn" class="btn btn-primary">Assign Room</button>
    <!-- <a href="bookingedit.php?Id=<?= $data['Id'] ?>" class="btn btn-primary">Edit</a> -->
</div>

</form>

</div>

</div>

</div>
</div>

<?php include('../footer.php'); ?>
</div>


<style>
    /* ================= IMAGE PREVIEW FIXED SIZE ================= */

#imagePreview {
    width: 100%;
    max-width: 280px;
    height: 180px;
    border: 1px dashed #ced4da;
    border-radius: 12px;
    background: #fafafa;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    margin-top: 10px;
}

#imagePreview img {
    width: 100%;
    height: 100%;
    object-fit: cover; /* important */
    border-radius: 12px;
}

</style>

<!-- FETCH ROOMS -->
<script>
document.addEventListener("DOMContentLoaded", function () {

    let roomTypeEl = document.getElementById("roomtypeId");
    if (!roomTypeEl || roomTypeEl.value === "") return;

    let typeId = roomTypeEl.value;

    fetch("getRoomDetails.php?room_type=" + typeId)
        .then(res => res.json())
        .then(data => {

            if (data.status !== "success") return;

            let roomSelect = document.getElementById("room_list");
            roomSelect.innerHTML = "<option value=''>Select Room</option>";

            data.rooms.forEach(room => {
                roomSelect.innerHTML += `<option value="${room.Id}">${room.number}</option>`;
            });

        });

});

$(document).ready(function() {
        $('a[href="https://www.froala.com/wysiwyg-editor?k=u"]').hide();
    });

function previewImage(input) {
        var preview = document.getElementById('imagePreview');
        preview.innerHTML = '';
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                var img = document.createElement('img');
                img.src = e.target.result;
                img.className = "img-fluid";
                preview.appendChild(img);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

</script>


<script>
       let stream = null;

// Open Camera
function openCamera() {
    const video = document.getElementById("cameraPreview");
    const captureBtn = document.getElementById("captureBtn");

    navigator.mediaDevices.getUserMedia({ video: true })
        .then(s => {
            stream = s;
            video.srcObject = s;
            video.style.display = "block";
            captureBtn.disabled = false; // Enable capture button
        })
        .catch(err => {
            alert("Camera permission denied!");
        });
}

// Capture Photo
function capturePhoto() {
    const video = document.getElementById("cameraPreview");
    const canvas = document.getElementById("capturedCanvas");
    const hiddenInput = document.getElementById("capturedImageInput");
    const retakeBtn = document.getElementById("retakeBtn");

    // Draw image on canvas
    canvas.style.display = "block";
    const context = canvas.getContext("2d");
    context.drawImage(video, 0, 0, canvas.width, canvas.height);

    // Stop camera stream
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }

    // Hide video, show canvas preview
    video.style.display = "none";

    // Save Base64
    hiddenInput.value = canvas.toDataURL("image/png");

    // Show Retake button
    retakeBtn.style.display = "inline-block";
}

// Retake Photo
function retakePhoto() {
    const video = document.getElementById("cameraPreview");
    const canvas = document.getElementById("capturedCanvas");
    const retakeBtn = document.getElementById("retakeBtn");
    const captureBtn = document.getElementById("captureBtn");

    // Hide old captured image
    canvas.style.display = "none";

    // Hide retake button until next capture
    retakeBtn.style.display = "none";

    // Restart camera
    openCamera();

    video.style.display = "block";
    captureBtn.disabled = false;
}

// Close Camera
function closeCamera() {
    const video = document.getElementById("cameraPreview");
    const captureBtn = document.getElementById("captureBtn");

    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }

    video.style.display = "none";
    captureBtn.disabled = true;
}
</script>

</body>
</html>
