document.addEventListener('DOMContentLoaded', function () {
    const searchInput = document.querySelector('.search-bar input');
    const iconContainer = document.querySelector('.line-awesome-icon');
    const iconItems = iconContainer.querySelectorAll('.col-xl-3');

    searchInput.addEventListener('input', function () {
        const searchTerm = this.value.trim().toLowerCase();

        iconItems.forEach(item => {
            const iconText = item.textContent.toLowerCase();

            if (searchTerm === '') {
                // Show all when search is empty
                item.style.display = 'flex';
                item.classList.remove('match');
                // Remove any existing highlights
                const textNodes = Array.from(item.childNodes).filter(node => node.nodeType === Node.TEXT_NODE);
                if (textNodes.length > 0) {
                    item.innerHTML = `<i class="${item.querySelector('i').className}"></i> ${textNodes[0].textContent.trim()}`;
                }
            } else if (iconText.includes(searchTerm)) {
                // Show matching items
                item.style.display = 'flex';
                item.classList.add('match');

                // Highlight matching text
                const iconClass = item.querySelector('i').className;
                const textContent = item.textContent.replace(iconClass, '').trim();

                item.innerHTML = `
                    <i class="${iconClass}"></i> 
                    ${textContent.replace(
                    new RegExp(searchTerm, 'gi'),
                    match => `<span class="highlight">${match}</span>`
                )}
                `;
            } else {
                // Hide non-matching items
                item.style.display = 'none';
                item.classList.remove('match');
            }
        });
    });
});