<!doctype html>
<html class="no-js" lang="zxx" dir="ltr">
<?php
// ========================== Includes ==========================
include('../../conection.php');
include('../loginsection/loginsessionData.php');
include('../head.php'); 
include('../vipaslookup.php');
?>

<body class="body-area">

    <!-- ========================== Preloader ========================== -->
    <?php include('preloader.php'); ?>

    <!-- ========================== Dashboard Wrapper ========================== -->
    <div class="page">

        <!-- Sidebar -->
        <?php include('../sidebar.php'); ?>

        <!-- Navbar -->
        <?php include('../nav.php'); ?>

        <!-- ========================== Content Area ========================== -->
        <div class="app-content-area">
            <div class="app-content-wrap">
                <div class="container-fluid">
                    
                    <!-- ========================== Page Title ========================== -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="page-title-box d-flex-between flex-wrap gap-15">
                                <h1 class="page-title fs-18 lh-1">Amenities Create</h1>
                            </div>
                        </div>
                    </div>

                    <!-- ========================== Form Section ========================== -->
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">

                                <!-- Card Header -->
                                <div class="card-header">
                                    <h4 class="card-title">Add Amenities</h4>
                                </div>

                                <!-- Card Body -->
                                <div class="card-body pt-15">
                                    <form class="row g-3" method="POST" action="code.php">




                                    <div class="row">
                                        <div class="col-md-6">
 <div class="row">
                                            
                                            <!-- Amenities Group Dropdown -->
                                            <div class="col-md-6 mb-3">
                                                <div class="form-group">
                                                    <label for="amenitiesgroupId" class="form-label">Amenities Group</label>
                                                    <select class="form-control" name="amenitiesgroupId" id="amenitiesgroupId" required>
                                                        <option value="">Select Amenities Group</option>
                                                        <?php
                                                        $getAmenitiesGroup = "SELECT * FROM amenitiesgroup WHERE status = 1 ORDER BY name";
                                                        $amenitiesGroups = $conn->query($getAmenitiesGroup);
                                                        if ($amenitiesGroups && $amenitiesGroups->num_rows > 0) {
                                                            while ($row = $amenitiesGroups->fetch_assoc()) {
                                                                echo '<option value="' . $row['Id'] . '">' . htmlspecialchars($row['name']) . '</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <!-- Name Input -->
                                            <div class="col-md-6 mb-3">
                                                <div class="form-group">
                                                    <label for="name" class="form-label">Name</label>
                                                    <input type="text" name="name" id="name" class="form-control" placeholder="Enter Name" required>
                                                </div>
                                            </div>

                                            <!-- ========================== Description ========================== -->
                                        <div class="col-md-12">
                                            <label class="form-label">Description</label>
                                            <textarea name="description" class="form-control" rows="3" placeholder="Enter Description" required></textarea>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label d-block">Order By</label>
                                            <div class="form-check">
                                                <input class="form-control" type="number" name="orderby" id="orderby">
                                            </div>
                                        </div>

                                               <div class="col-md-6">
                                            <label class="form-label d-block">Status</label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="status" id="status"
                                                    style="width: 30px; height: 30px; cursor: pointer;">
                                            </div>
                                        </div>
                                        <!-- ========================== Icons & Status ========================== -->
                                        <div class="col-md-6">
                                            <label class="form-label d-block">Icons</label>
<!-- Hidden input (will store copied icon tag) -->
<input type="hidden" name="icon" id="icon">

<!-- Preview box -->
<div id="iconPreview" 
     style="
        width:80px;
        height:80px;
        border-radius:12px;
        background:#ffffff;
        box-shadow:0 3px 10px rgba(0,0,0,0.15);
        display:flex;
        align-items:center;
        justify-content:center;
        font-size:35px;
        margin-top:10px;
     ">
</div>

                                        </div>

                                 

                                        <!-- ========================== Buttons ========================== -->
                                        <div class="col-12 d-flex justify-content-end">
                                            <a href="amenitiesindex.php" class="btn btn-danger me-2">Cancel</a>
                                            <button class="btn btn-primary" name="create" type="submit">Submit</button>
                                        </div>
                                        </div>
                                        </div>
<div class="col-md-6">

<iframe src="../vipicon.php" width="100%" height="100%" frameborder="0">

</iframe>
   

</div>
                                    </div>


                                        <!-- ========================== Amenities Group & Name ========================== -->
                                       

                                        

                                    </form>
                                </div> <!-- End Card Body -->

                            </div> <!-- End Card -->
                        </div>
                    </div>

                </div> <!-- End Container -->
            </div>
        </div>

        <!-- ========================== Footer ========================== -->
        <?php include('../footer.php'); ?>

    </div> <!-- End Page Wrapper -->

</body>
</html>
