<?php
include('./conection.php');
// include('./viphoteladda/vipasbase.php');

// require_once('./viphoteladda/vipasbase.php');


function generateIconUrl($name) {
    $colors = [
        'A' => '#FF5733', 'B' => '#33FF57', 'C' => '#3357FF', 'D' => '#FF33A6',
        'E' => '#FF8C33', 'F' => '#A633FF', 'G' => '#33FFF1', 'H' => '#FF3333',
        'I' => '#33FF86', 'J' => '#FFCC33', 'K' => '#FF3399', 'L' => '#33C3FF',
        'M' => '#FF33D2', 'N' => '#FF6600', 'O' => '#FF9999', 'P' => '#FF4C4C',
        'Q' => '#FF8C00', 'R' => '#FFBF00', 'S' => '#FF5733', 'T' => '#33FF57',
        'U' => '#FF3333', 'V' => '#A633FF', 'W' => '#3399FF', 'X' => '#FF33A6',
        'Y' => '#33FFCC', 'Z' => '#FF3333'
    ];

    $first_letter = strtoupper($name[0]);
    $background_color = isset($colors[$first_letter]) ? $colors[$first_letter] : '#000000';

    $icon_svg = <<<SVG
<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg">
    <style>
        .background { fill: $background_color; }
        .letter { font-size: 50px; fill: white; text-anchor: middle; alignment-baseline: middle; font-family: Arial; }
    </style>
    <rect width="100" height="100" class="background"/>
    <text x="50" y="50" class="letter">$first_letter</text>
</svg>
SVG;

    return 'data:image/svg+xml;base64,' . base64_encode($icon_svg);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Sanitize inputs
    $roomtypeId = isset($_POST['roomtypeId']) ? trim($_POST['roomtypeId']) : null;
    $reviewer_name = isset($_POST['reviewer_name']) ? mysqli_real_escape_string($conn, trim($_POST['reviewer_name'])) : '';
    $reviewer_email = isset($_POST['reviewer_email']) ? mysqli_real_escape_string($conn, trim($_POST['reviewer_email'])) : '';
    $rating = isset($_POST['rating']) ? (int)$_POST['rating'] : 0;
    $comment = isset($_POST['comment']) ? mysqli_real_escape_string($conn, trim($_POST['comment'])) : '';



    if (empty($roomtypeId)) {
        die("Room type ID is required.");
    }
  
    if (empty($reviewer_name) || empty($reviewer_email) || $rating <= 0 || empty($comment)) {
        die("Please fill in all required fields.");
    }
//   echo $roomtypeId;
    $icon_url = generateIconUrl($reviewer_name);

    // echo $icon_url;

    // Insert query
    $query = "INSERT INTO roomreviews (roomtypeId, reviewer_name, reviewer_email, rating, comment, image, created_at) 
              VALUES ('$roomtypeId', '$reviewer_name', '$reviewer_email', $rating, '$comment', '$icon_url', NOW())";

    if (mysqli_query($conn, $query)) {
        $success_message = "Review submitted successfully!";
    } else {
        $success_message = "Error: " . mysqli_error($conn);
    }

    header("Location: roomdetail.php?id=$roomtypeId");
    exit();
}
?>
