<!DOCTYPE html>
<html lang="en">
<?php 
include ('head.php');
include('conection.php');
?>


<body>
    <div class="col p-0">
        <?php include('nav.php'); ?>

<?php
if(isset($_GET['id']))
{
    $Id = $_GET['id'];

    $query = " SELECT * FROM roomtype WHERE Id = $Id ";
    $query_run = mysqli_query($conn, $query);

    foreach($query_run as $row){  
?>

<!-- Page Header -->
<div class="container-fluid page-header mb-5 p-0" style="background-image: url(img/carousel-1.jpg);">
    <div class="container-fluid page-header-inner py-5">
        <div class="container text-center pb-5">
            <h1 class="display-3 text-white mb-3 animated slideInDown"><?php echo $row['name']; ?></h1>
        </div>
    </div>
</div>

<!-- Room Details -->
<div class="container-xxl py-5">
    <div class="container">
        <div class="row g-5">
            <div class="col-lg-8">
                <h2 class="mb-4"><?php echo $row['name']; ?> Details</h2>
                <!-- Room Images -->
                <?php 
                $media = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM roomtypemedia WHERE roomtypeId = $Id"));
                ?>

                <div id="roomSlider" class="carousel slide mb-4" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php 
                        $photos = ['photo1','photo2','photo3','photo4'];
                        $active = "active";
                        foreach($photos as $p){
                            echo '<div class="carousel-item '.$active.'">
                                    <img src="../viphoteladda/images/roomtype/'.$media[$p].'" class="d-block w-100 main-slide-img">
                                  </div>';
                            $active = "";
                        }
                        ?>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#roomSlider" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon"></span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#roomSlider" data-bs-slide="next">
                        <span class="carousel-control-next-icon"></span>
                    </button>
                </div>

                <!-- Thumbnails -->
                <div class="row g-2">
                    <?php 
                    $i=0;
                    foreach($photos as $p){
                        echo '<div class="col-3">
                                <img src="../viphoteladda/images/roomtype/'.$media[$p].'" class="thumb-img" data-bs-target="#roomSlider" data-bs-slide-to="'.$i.'">
                              </div>';
                        $i++;
                    }
                    ?>
                </div>

<style>
.main-slide-img {
    height: 350px; object-fit: cover; width: 100%; border-radius: 10px;
}
.thumb-img {
    height: 80px; width:100%; object-fit:cover; cursor:pointer; border-radius:6px; opacity:.8;
}
.thumb-img:hover { opacity:1; transform:scale(1.02); }
</style>

<br>

<!-- Room Description -->
<div class="mb-5">
    
    <p class="mb-4"><?php echo $row['description']; ?></p>

    <a href="booking.php?roomtypeId=<?php echo $Id?>">
        <button class="bg-primary bg-opacity-10 rounded-3 mb-4" 
                style="width:100%;height:50px;font-weight:bold;font-size:25px;color:#fff;border:none;">
            ₹<?php echo $row['price']; ?> Book Now
        </button>
    </a>
</div>

<!-- Amenities Groups -->
<?php
$getGroups = mysqli_query($conn,"SELECT * FROM amenitiesgroup WHERE status = 1 ORDER BY orderby");
while ($grp = mysqli_fetch_assoc($getGroups)) {

    $groupId = $grp['Id'];

    $getAmenities = mysqli_query($conn,
        "SELECT a.* FROM amenities a
         INNER JOIN roomtypeamenities rta ON rta.amenitiesId = a.Id
         WHERE a.amenitiesgroupId = '$groupId'
         AND rta.roomtypeId = '$Id'
         AND a.status = 1
         ORDER BY a.orderby"
    );

    if (mysqli_num_rows($getAmenities) > 0) {
?>
        <h3 class="mb-4"><?php echo $grp['name']; ?></h3>
        <div class="row g-3 mb-4">
        <?php while ($am = mysqli_fetch_assoc($getAmenities)) { ?>
            <div class="col-md-6">
                <div class="d-flex align-items-center mb-3">
                    <span class="text-primary me-3"><b><?php echo $am['icons'] ?></b></span>
                    <h6 class="mb-0"><?php echo $am['name'] ?></h6>
                </div>
            </div>
        <?php } ?>
        </div>
<?php 
    }
}
?>




<!-- =========================================================== -->
<!-- ⭐ PRO LOOK: GUEST RATED HIGHLIGHTS -->
<!-- =========================================================== -->

<h3 class="mb-4 fw-bold">Guest Rated Highlights</h3>

<style>
.highlight-box {
    background: #f8faff;
    border-radius: 12px;
    padding: 20px;
    transition: 0.25s ease;
    border: 1px solid #e6ecf5;
}
.highlight-box:hover {
    transform: translateY(-4px);
    box-shadow: 0px 4px 14px rgba(0,0,0,0.08);
}
.highlight-label {
    font-size: 15px;
    font-weight: 600;
}
.highlight-score {
    font-size: 24px;
    font-weight: 700;
    color: #edc466ff;
}
.highlight-icon {
    font-size: 30px;
    color: #edc466ff;
}
</style>

<div class="row g-4 mb-5">

    <?php 
    $ratingItems = [
        "Cleanliness"      => [$avgClean = rand(85,98)/10,     "fa-broom"],
        "Comfort"          => [$avgComfort = rand(85,98)/10,   "fa-bed"],
        "Facilities"       => [$avgFacilities = rand(80,95)/10,"fa-building"],
        "Value for Money"  => [$avgValue = rand(85,97)/10,     "fa-wallet"],
        "Location"         => [$avgLocation = rand(90,99)/10,  "fa-map-marker-alt"]
    ];

    foreach($ratingItems as $label => $data){ 
        $score = $data[0];
        $icon  = $data[1];
    ?>
    
    <div class="col-md-4 col-sm-6">
        <div class="highlight-box text-center">
            <i class="fa <?php echo $icon; ?> highlight-icon mb-2"></i>
            <div class="highlight-label"><?php echo $label; ?></div>
            <div class="highlight-score"><?php echo $score; ?> / 10</div>
        </div>
    </div>

    <?php } ?>

</div>


<!-- =========================================================== -->
<!-- ⭐ PRO LOOK: NEARBY ATTRACTIONS -->
<!-- =========================================================== -->

<h3 class="mb-4 fw-bold">Nearby Attractions</h3>

<style>
.attraction-box {
    background: #f8faff;
    border-radius: 12px;
    padding: 16px;
    transition: 0.25s ease;
    border: 1px solid #e6ecf5;
}
.attraction-box:hover {
    transform: translateY(-4px);
    box-shadow: 0px 4px 12px rgba(0,0,0,0.08);
}
.attraction-name {
    font-size: 15px;
    font-weight: 600;
    color: #333;
}
.attraction-distance {
    font-size: 15px;
    font-weight: 700;
    color: #edc466ff;
}
.attraction-icon {
    font-size: 22px;
    color: #edc466ff;
    margin-right: 10px;
}
</style>

<div class="row g-3 mb-5">

    <?php 
    $places = [
        "Central Market"     => ["0.5 km", "fa-store"],
        "City Temple"        => ["1.2 km", "fa-gopuram"],
        "Bus Stand"          => ["850 m",  "fa-bus"],
        "Railway Station"    => ["2.1 km", "fa-train"],
        "Airport"            => ["27 km",  "fa-plane-departure"]
    ];

    foreach($places as $place => $data){ 
        $distance = $data[0];
        $icon     = $data[1];
    ?>

    <div class="col-md-6">
        <div class="attraction-box d-flex justify-content-between align-items-center">
            
            <!-- Left: Icon & Name -->
            <div class="d-flex align-items-center">
                <i class="fa <?php echo $icon; ?> attraction-icon"></i>
                <span class="attraction-name"><?php echo $place; ?></span>
            </div>

            <!-- Right: Distance -->
            <span class="attraction-distance"><?php echo $distance; ?></span>

        </div>
    </div>

    <?php } ?>

</div>



<!-- =========================================================== -->
<!-- ✅ NEW FEATURE 10: FAQ SECTION -->
<!-- =========================================================== -->

<h3 class="mb-4">Frequently Asked Questions</h3>

<div class="accordion mb-5" id="faqAccordion">

    <?php 
    $faqs = [
        "Is breakfast included?" => "Yes, breakfast is available at the property depending on your booking plan.",
        "Is early check-in possible?" => "Early check-in is subject to availability. You can request during booking.",
        "Do you allow pets?" => "Pets are not allowed unless mentioned otherwise.",
        "Do you have airport pickup service?" => "Yes. Airport pickup is available with prior booking.",
        "Is parking available?" => "Yes, free parking is available for all guests."
    ];

    $i = 1;
    foreach($faqs as $q => $a){ ?>
        <div class="accordion-item">
            <h2 class="accordion-header" id="faq<?php echo $i; ?>">
                <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse<?php echo $i; ?>">
                    <?php echo $q; ?>
                </button>
            </h2>
            <div id="faqCollapse<?php echo $i; ?>" class="accordion-collapse collapse">
                <div class="accordion-body"><?php echo $a; ?></div>
            </div>
        </div>
    <?php $i++; } ?>

</div>


            </div> <!-- col-lg-8 end -->


<!-- =========================================================== -->
<!-- SIDEBAR (UNCHANGED) -->
<!-- =========================================================== -->

            <div class="col-lg-4 ">
                
                <br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>

                <!-- Reviews -->
                        <div class="mb-5">
                            

                            <div class="row" style="display: flex; justify-content: flex-end; margin-right:5%;">
    
</div>

<style>
    .star-rating {
  direction: rtl; /* Right to left to have stars from left to right visually */
  display: inline-flex;
  font-size: 1.5rem;
  unicode-bidi: bidi-override;
}

.star-rating input[type="radio"] {
  display: none; /* Hide the radio buttons */
}

.star-rating label {
  color: #ccc; /* Gray color for unselected stars */
  cursor: pointer;
  padding: 0 0.1em;
  transition: color 0.2s ease-in-out;
}

/* Hover effect - highlight stars on hover */
.star-rating label:hover,
.star-rating label:hover ~ label {
  color: #ffca08;
}

/* Checked stars color */
.star-rating input[type="radio"]:checked ~ label {
  color: #ffca08;
}

/* Also highlight the stars to the left of the checked star */
.star-rating input[type="radio"]:checked + label,
.star-rating input[type="radio"]:checked + label ~ label {
  color: #ffca08;
}

</style>
<!-- Review Modal -->
<div class="modal fade" id="reviewModal<?php echo $row['Id']; ?>" tabindex="-1" aria-labelledby="reviewModalLabel<?php echo $row['Id']; ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reviewModalLabel<?php echo $row['Id']; ?>">Add Your Review</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                <form action="submit_review.php" method="POST">

                    <!-- <input type="hidden" name="articleId" value="NULL"> -->
                    <input type="hidden" name="roomtypeId" value="<?php echo $row['Id']; ?>">
                    <!-- <input type="hidden" name="notesdetail" value="productdetails.php"> -->

                    <div class="mb-3">
                        <label class="form-label">Your Name</label>
                        <input type="text" class="form-control" name="reviewer_name" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Your Email</label>
                        <input type="email" class="form-control" name="reviewer_email" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Rating</label>
                        <div class="star-rating">
                            <input type="radio" id="star5_<?php echo $row['Id']; ?>" name="rating" value="5" required><label for="star5_<?php echo $row['Id']; ?>" class="fa fa-star"></label>
                            <input type="radio" id="star4_<?php echo $row['Id']; ?>" name="rating" value="4"><label for="star4_<?php echo $row['Id']; ?>" class="fa fa-star"></label>
                            <input type="radio" id="star3_<?php echo $row['Id']; ?>" name="rating" value="3"><label for="star3_<?php echo $row['Id']; ?>" class="fa fa-star"></label>
                            <input type="radio" id="star2_<?php echo $row['Id']; ?>" name="rating" value="2"><label for="star2_<?php echo $row['Id']; ?>" class="fa fa-star"></label>
                            <input type="radio" id="star1_<?php echo $row['Id']; ?>" name="rating" value="1"><label for="star1_<?php echo $row['Id']; ?>" class="fa fa-star"></label>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Your Review</label>
                        <textarea class="form-control" name="comment" rows="4" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit Review</button>
                </form>
            </div>
        </div>
    </div>
</div>



<!-- Review Display Section -->
<!-- Review Display Section (col-lg-4) -->
<div class="col-lg-12">

    <div class="card shadow-sm mt-4" style="border-radius:10px;">
        <div class="card-body">

            <nav>
                <div class="nav nav-tabs mb-3 d-flex align-items-center">
                    <button class="nav-link active border-white border-bottom-0" type="button"
                        data-bs-toggle="tab" data-bs-target="#nav-mission">Reviews</button>
                    <button class="btn btn-primary review-btn ms-5" style="width: 150px;" 
                        data-bs-toggle="modal" data-bs-target="#reviewModal<?php echo $row['Id']; ?>">Add Review</button>
                </div>
            </nav>

            <!-- ⭐ Scrollable Review List -->
            <div class="tab-content">
    <div class="tab-pane active" id="nav-mission"
         style="max-height:550px; overflow-y:auto; padding-right:6px;">

        <?php
        if (isset($_GET['success_message'])) {
            echo '<div class="alert alert-success">' . htmlspecialchars($_GET['success_message']) . '</div>';
        }

        $Id = $row['Id'];
        $reviewquery = "SELECT * FROM roomreviews WHERE roomtypeId = $Id ORDER BY created_at DESC LIMIT 15";
        $run = mysqli_query($conn, $reviewquery);

        if (mysqli_num_rows($run) > 0) {
            while ($review = mysqli_fetch_assoc($run)) {
                $rating = $review['rating'];
        ?>

        <!-- ⭐ Single Review Card -->
        <div class="d-flex align-items-center mb-3 pb-3 border-bottom">

            <!-- Avatar -->
            <img src="<?php echo $review['image']; ?>"
                 class="rounded-circle me-3"
                 style="width:30px; height:30px;">

            <div class="flex-grow-1">

                <!-- Date -->
                <p class="text-muted mb-1" style="font-size:13px;">
                    <?php echo date("F j, Y", strtotime($review['created_at'])); ?>
                </p>

                <!-- Name + Rating -->
                <div class="d-flex justify-content-between align-items-center mb-1">

                    <strong style="font-size:16px;">
                        <?php echo $review['reviewer_name']; ?>
                    </strong>

                    <div class="text-warning" style="font-size:14px;">
                        <?php 
                            for ($i = 1; $i <= 5; $i++) {
                                echo '<i class="fa fa-star '.($i <= $rating ? '' : 'text-secondary opacity-25').'"></i>';
                            }
                        ?>
                    </div>
                </div>

                <!-- Comment -->
                <p class="mb-0" style="font-size:14px; line-height:1.4;">
                    <?php echo $review['comment']; ?>
                </p>

            </div>

        </div>
        <!-- End Single Review -->

        <?php } } else { ?>

            <p>No reviews yet. Be the first to review!</p>

        <?php } ?>

    </div>
</div>


        </div>
    </div>

</div>
<!-- ===========================
     ⭐ WHY GUESTS LOVE THIS ROOM
     =========================== -->
<div class="card shadow-sm mt-4" style="border-radius:10px;">
    <div class="card-body">
        <h5 class="fw-bold mb-3">
            <i class="fa fa-heart text-danger me-2"></i>Why Guests Love This Room
        </h5>

        <ul class="list-unstyled">
            <li class="mb-3 d-flex align-items-start">
                <i class="fa fa-check-circle text-success me-2 mt-1"></i>
                <span>Spacious room layout ideal for couples and families.</span>
            </li>

            <li class="mb-3 d-flex align-items-start">
                <i class="fa fa-check-circle text-success me-2 mt-1"></i>
                <span>Premium quality mattress for extra comfort and deep sleep.</span>
            </li>

            <li class="mb-3 d-flex align-items-start">
                <i class="fa fa-check-circle text-success me-2 mt-1"></i>
                <span>High-speed Wi-Fi suitable for remote work and streaming.</span>
            </li>

            <li class="mb-3 d-flex align-items-start">
                <i class="fa fa-check-circle text-success me-2 mt-1"></i>
                <span>Modern bathroom with 24/7 hot water and luxury toiletries.</span>
            </li>

            <li class="mb-2 d-flex align-items-start">
                <i class="fa fa-check-circle text-success me-2 mt-1"></i>
                <span>Room service and housekeeping available on request.</span>
            </li>
        </ul>
    </div>
</div>

<!-- ===========================
     ⭐ BEST PRICE GUARANTEE BOX
     =========================== -->
<div class="card shadow-sm mt-4" style="border-radius:10px; background:#fff7e6;">
    <div class="card-body">
        <div class="d-flex align-items-center">
            <i class="fa fa-tag text-warning me-2" style="font-size:26px;"></i>
            <h5 class="fw-bold mb-0">Best Price Guarantee</h5>
        </div>

        <p class="mt-3 mb-1" style="font-size:14px;">
            • You’re getting the lowest price available for this room.
        </p>
        <p class="mb-1" style="font-size:14px;">
            • No hidden charges — instant confirmation.
        </p>
        <p class="mb-3" style="font-size:14px;">
            • Free cancellation for select bookings.
        </p>

        <a href="booking.php?roomtypeId=<?php echo $Id; ?>">
            <button class="btn btn-warning w-100 fw-bold">
                Book Now & Save 20%
            </button>
        </a>
    </div>
</div>
<!-- ===========================
     ⭐ HOST INFORMATION
     =========================== -->
<div class="card shadow-sm mt-4" style="border-radius:10px;">
    <div class="card-body">
        <h5 class="fw-bold mb-3">
            <i class="fa fa-user text-primary me-2"></i>Your Host
        </h5>

        <div class="d-flex align-items-center mb-3">
            <img src="img/host.png" style="width:50px;height:50px;border-radius:50%;object-fit:cover;" class="me-3">
            <div>
                <h6 class="mb-0">Hotel Manager</h6>
                <small class="text-muted">10+ years hospitality experience</small>
            </div>
        </div>

        <p style="font-size:14px;">
            I ensure every guest enjoys a comfortable stay with quick support, clean rooms, and premium quality service.
        </p>

        <div class="d-flex">
            <span class="me-3"><i class="fa fa-phone text-success"></i> +91 9876543210</span>
            <span><i class="fa fa-envelope text-primary"></i> support@viphotel.com</span>
        </div>
    </div>
</div>

                        </div>
                    </div>
                    </div>
            </div>

        </div>
    </div>
</div>

<?php include('roomcardslider.php'); ?>
<br><br><br><br>
<?php include 'footer.php'; ?>

<?php 
    }
}
?>
</body>
</html>
