<!-- Swiper CSS (paste in head or before this block) -->
<link rel="stylesheet" href="https://unpkg.com/swiper@9/swiper-bundle.min.css" />

<style>
/* small custom styles for cards inside swiper */
.room-item {
  background: #fff;
  border-radius: 0.5rem;
  overflow: hidden;
  box-shadow: 0 6px 20px rgba(0,0,0,0.08);
  height: 100%;
  display: flex;
  flex-direction: column;
}
.room-item .position-relative { position: relative; }
.room-item img { display:block; width:100%; height:200px; object-fit:cover; }
.price-badge {
  position: absolute;
  left: 1rem;
  bottom: -1.25rem;
  transform: translateY(50%);
  background: #0d6efd;
  color: #fff;
  padding: .35rem .9rem;
  border-radius: 30px;
  font-weight:600;
  box-shadow: 0 6px 16px rgba(13,110,253,0.15);
}
.swiper-slide { padding: 1rem 0.5rem; box-sizing: border-box; }

/* FIX — Swiper v9 container */
.swiper {
  padding-bottom: 2.5rem !important;
}

/* FIX — ensure slides align properly */
.swiper-wrapper {
  display: flex !important;
}

/* FIX — make navigation buttons visible & clickable */
.swiper-button-next,
.swiper-button-prev {
  z-index: 10 !important;
}

@media (max-width:575px){
  .room-item img{ height:150px; }
  .price-badge{ font-size:0.85rem; }
}
</style>

<div class="container-xxl py-5">
  <div class="container">
    <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
      <h6 class="section-title text-center text-primary text-uppercase">Related Rooms</h6>
      <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Other Rooms</span></h1>
    </div>

    <!-- Swiper -->
    <div class="swiper myRoomSwiper">
      <div class="swiper-wrapper">

        <?php 
        $selectRoomTypes = "
            SELECT r.*, m.photo1 
            FROM roomtype r
            LEFT JOIN roomtypemedia m ON r.Id = m.roomtypeId
            WHERE r.status = 1 and m.roomtypeId != $Id
            LIMIT 10
        ";
        $roomTypes = $conn->query($selectRoomTypes);

        if ($roomTypes) {
            foreach ($roomTypes as $room) {

                $photo = !empty($room['photo1']) ? trim($room['photo1']) : '';
                $imagePath = $photo ? '../viphoteladda/images/roomtype/' . $photo : 'img/default-room.jpg';
                $displayPrice = !empty($room['price']) ? $room['price'] : "0";
        ?>

        <div class="swiper-slide">
          <div class="col-12">
            <div class="room-item">
              <div class="position-relative">
                <img class="img-fluid" src="<?php echo $imagePath; ?>" alt="Room Image">
                <div class="position-absolute start-0 top-100 translate-middle-y bg-primary text-white rounded py-1 px-3 ms-4">
                  ₹<?php echo $displayPrice; ?> / Night
                </div>
              </div>

              <div class="p-4 mt-4" style="flex:1; display:flex; flex-direction:column; justify-content:space-between;">
                <div>
                  <div class="d-flex justify-content-between mb-3 align-items-center">
                    <h5 class="mb-0"><?php echo $room['name']; ?></h5>
                    <div class="ps-2">
                      <small class="fa fa-star text-primary"></small>
                      <small class="fa fa-star text-primary"></small>
                      <small class="fa fa-star text-primary"></small>
                      <small class="fa fa-star text-primary"></small>
                      <small class="fa fa-star text-primary"></small>
                    </div>
                  </div>

                  <div class="d-flex mb-3 text-muted small">
                    <small class="border-end me-3 pe-3">
                      <i class="fa fa-bed text-primary me-2"></i><?php echo $room['occupancy']; ?> Bed
                    </small>
                    <small class="border-end me-3 pe-3">
                      <i class="fa fa-bath text-primary me-2"></i><?php echo $room['bath']; ?> Bath
                    </small>
                    <small><i class="fa fa-wifi text-primary me-2"></i>Wifi</small>
                  </div>

                  <p class="text-body mb-3">
                    <?php echo substr($room['description'], 0, 80); ?>...
                  </p>
                </div>

                <div class="d-flex justify-content-between mt-2">
                  <a class="btn btn-sm btn-primary rounded py-2 px-4" href="roomdetail.php?id=<?php echo $room['Id']; ?>">View Detail</a>
                  <a class="btn btn-sm btn-dark rounded py-2 px-4" href="booking.php?roomtypeId=<?php echo $room['Id']; ?>">Book Now</a>
                </div>
              </div>
            </div>
          </div>
        </div>

        <?php 
            } 
        } 
        ?>

      </div>

      <!-- Add Pagination -->
      <div class="swiper-pagination"></div>

      <!-- Add Arrows -->
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
    </div>

  </div>
</div>

<!-- Swiper JS -->
<script src="https://unpkg.com/swiper@9/swiper-bundle.min.js"></script>

<script>
  const roomSwiper = new Swiper('.myRoomSwiper', {
    loop: true,
    slidesPerView: 3,
    spaceBetween: 20,
    pagination: {
      el: '.swiper-pagination',
      clickable: true,
    },
    navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
    },
    breakpoints: {
      0: { slidesPerView: 1, spaceBetween: 10 },
      576: { slidesPerView: 1.2, spaceBetween: 12 },
      768: { slidesPerView: 2, spaceBetween: 16 },
      992: { slidesPerView: 3, spaceBetween: 20 }
    },
    autoplay: {
      delay: 4500,
      disableOnInteraction: true,
    },
    a11y: true
  });
</script>
