<?php
// -------------------------------
// PAYU CONFIG
// -------------------------------
$MERCHANT_KEY  = "XqdMZY";
$SALT          = "BwR40pq81TWAYboyR45EX6daZl3pcnM8";
// $PAYU_BASE_URL = "https://secure.payu.in"; // Production
$PAYU_BASE_URL = "https://test.payu.in"; // Testing

// -------------------------------
// STEP 1: GENERATE TXN ID
// -------------------------------
$txnid = substr(hash('sha256', mt_rand() . microtime()), 0, 20);

// -------------------------------
// STEP 2: CHECK IF PAYU SENT RESPONSE
// -------------------------------
if (!empty($_POST['status'])) {

    // -------------------------------
    // SUCCESS / FAILURE RESPONSE
    // -------------------------------
    $status       = $_POST["status"];
    $firstname    = $_POST["firstname"];
    $amount       = $_POST["amount"];
    $txnid        = $_POST["txnid"];
    $posted_hash  = $_POST["hash"];
    $key          = $_POST["key"];
    $email        = $_POST["email"];
    $productinfo  = $_POST["productinfo"];

    // -------------------------------
    // RE-CALCULATE HASH
    // -------------------------------
    $retHashSeq = $SALT.'|'.$status.'||||||||||'.$email.'|'.$firstname.'|'.$productinfo.'|'.$amount.'|'.$txnid.'|'.$key;
    $hash = strtolower(hash("sha512", $retHashSeq));

    echo "<h2>PAYU RESPONSE</h2>";

    if ($hash != $posted_hash) {
        echo "<h3 style='color:red'>❌ Invalid Transaction. Hash mismatch!</h3>";
    } else {

        if ($status == "success") {
            echo "<h3 style='color:green'>✅ Payment Successful</h3>";
        } else {
            echo "<h3 style='color:red'>❌ Payment Failed</h3>";
        }

        echo "Transaction ID: $txnid<br>";
        echo "Amount: $amount<br>";
        echo "Status: $status<br>";
    }

    exit;
}

// -------------------------------
// STEP 3: IF USER CLICKS PAY NOW
// -------------------------------
if (isset($_POST['paynow'])) {

    $amount     = $_POST['amount'];
    $firstname  = $_POST['firstname'];
    $email      = $_POST['email'];
    $phone      = $_POST['phone'];
    $productinfo = "Product Purchase";

    // -------------------------------
    // HASH STRING
    // -------------------------------
    $hash_string = $MERCHANT_KEY . "|" . $txnid . "|" . $amount . "|" . $productinfo . "|" . $firstname . "|" . $email;
    $hash_string .= "||||||||||" . $SALT;

    // -------------------------------
    // FINAL HASH
    // -------------------------------
    $hash = strtolower(hash('sha512', $hash_string));
?>
    <!-- AUTO SUBMIT PAYU FORM -->
    <form id="payuForm" method="post" action="<?php echo $PAYU_BASE_URL.'/_payment'; ?>">
        <input type="hidden" name="key" value="<?php echo $MERCHANT_KEY; ?>">
        <input type="hidden" name="txnid" value="<?php echo $txnid; ?>">
        <input type="hidden" name="amount" value="<?php echo $amount; ?>">
        <input type="hidden" name="productinfo" value="<?php echo $productinfo; ?>">
        <input type="hidden" name="firstname" value="<?php echo $firstname; ?>">
        <input type="hidden" name="email" value="<?php echo $email; ?>">
        <input type="hidden" name="phone" value="<?php echo $phone; ?>">
        <input type="hidden" name="hash" value="<?php echo $hash; ?>">

        <input type="hidden" name="surl" value="http://<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']; ?>">
        <input type="hidden" name="furl" value="http://<?php echo $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']; ?>">

    </form>

    <h3>Redirecting to PayU...</h3>

    <script>
        document.getElementById("payuForm").submit();
    </script>

<?php
    exit;
}
?>

<!-- ------------------------------- -->
<!-- USER PAYMENT INPUT FORM -->
<!-- ------------------------------- -->

<h2>PayU Payment</h2>

<form method="post">
    <label>Full Name</label><br>
    <input type="text" name="firstname" required><br><br>

    <label>Email</label><br>
    <input type="email" name="email" required><br><br>

    <label>Phone</label><br>
    <input type="text" name="phone" required><br><br>

    <label>Amount (₹)</label><br>
    <input type="number" name="amount" required><br><br>

    <button type="submit" name="paynow">Pay Now</button>
</form>
