<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Royal Taj Palace | Indian Culinary Experience</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f8f5f0;
            color: #333;
            line-height: 1.6;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* Header Styles */
        .header {
            background: linear-gradient(rgba(0, 0, 0, 0.85), rgba(0, 0, 0, 0.9)), url('https://images.unsplash.com/photo-1585937421612-70ca003675ed?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 40px 20px;
            text-align: center;
            border-radius: 0 0 20px 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            margin-bottom: 40px;
            position: relative;
            overflow: hidden;
        }

        .header::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle at 30% 20%, rgba(188, 152, 92, 0.1) 0%, transparent 50%);
        }

        .hotel-name {
            font-size: 3.5rem;
            font-weight: 400;
            letter-spacing: 2px;
            margin-bottom: 10px;
            font-family: 'Playfair Display', serif;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            color: #f8ecc9;
        }

        .hotel-tagline {
            font-size: 1.3rem;
            font-weight: 300;
            letter-spacing: 6px;
            margin-bottom: 30px;
            text-transform: uppercase;
            color: #d4c9b9;
        }

        .menu-title {
            font-size: 2.8rem;
            font-weight: 300;
            margin: 20px 0;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.3);
            display: inline-block;
            color: white;
        }

        .currency-note {
            font-size: 0.9rem;
            color: #d4c9b9;
            margin-top: 10px;
            font-style: italic;
        }

        /* Menu Navigation */
        .menu-nav {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 40px;
            background-color: white;
            padding: 15px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            position: relative;
        }

        .nav-btn {
            padding: 12px 28px;
            background-color: #f1ede6;
            border: none;
            border-radius: 30px;
            font-weight: 600;
            color: #5a4d3f;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            white-space: nowrap;
            flex-shrink: 0;
        }

        .nav-btn:hover {
            background-color: #d4c9b9;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(139, 115, 85, 0.2);
        }

        .nav-btn.active {
            background-color: #a0522d;
            color: white;
        }

        /* Mobile Slider Navigation */
        .mobile-slider-nav {
            display: none;
            position: relative;
            margin-bottom: 20px;
            width: 100%;
        }

        .slider-container {
            position: relative;
            width: 100%;
            overflow: hidden;
        }

        .slider-wrapper {
            display: flex;
            transition: transform 0.3s ease;
            gap: 10px;
            padding: 10px 5px;
            overflow-x: auto;
            scroll-behavior: smooth;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }

        .slider-wrapper::-webkit-scrollbar {
            display: none;
        }

        .slider-nav-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: rgba(160, 82, 45, 0.8);
            color: white;
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            font-size: 1.2rem;
            cursor: pointer;
            z-index: 10;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
        }

        .slider-nav-btn.prev {
            left: 5px;
        }

        .slider-nav-btn.next {
            right: 5px;
        }

        .slider-nav-btn:disabled {
            opacity: 0.3;
            cursor: not-allowed;
        }

        /* Cart Button */
        .cart-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
        }

        .cart-btn {
            background-color: #a0522d;
            color: white;
            border: none;
            border-radius: 50px;
            padding: 12px 25px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
            box-shadow: 0 5px 15px rgba(160, 82, 45, 0.3);
            transition: all 0.3s ease;
        }

        .cart-btn:hover {
            background-color: #8a4525;
            transform: translateY(-2px);
        }

        .cart-count {
            background-color: #f8ecc9;
            color: #a0522d;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }

        /* Menu Sections */
        .menu-section {
            display: none;
            background-color: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 40px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
            animation: fadeIn 0.5s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .menu-section.active {
            display: block;
        }

        .section-header {
            text-align: center;
            margin-bottom: 40px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eae2d6;
            position: relative;
        }

        .section-header::after {
            content: "";
            position: absolute;
            bottom: -2px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 2px;
            background-color: #a0522d;
        }

        .section-title {
            font-size: 2.2rem;
            color: #a0522d;
            font-weight: 400;
            font-family: 'Playfair Display', serif;
        }

        .section-subtitle {
            font-style: italic;
            color: #999;
            font-size: 1.1rem;
            margin-top: 5px;
        }

        /* Menu Items */
        .menu-category {
            margin-bottom: 50px;
        }

        .category-title {
            font-size: 1.5rem;
            color: #5a4d3f;
            padding-bottom: 10px;
            margin-bottom: 25px;
            border-bottom: 2px solid #d4c9b9;
            font-weight: 600;
            position: relative;
        }

        .category-title::after {
            content: "• • •";
            position: absolute;
            bottom: -12px;
            left: 50%;
            transform: translateX(-50%);
            color: #a0522d;
            font-size: 1.2rem;
            letter-spacing: 3px;
        }

        .menu-item {
            display: flex;
            gap: 20px;
            margin-bottom: 30px;
            padding: 20px;
            border: 1px solid #eae2d6;
            border-radius: 10px;
            transition: all 0.3s ease;
            background-color: #fff;
        }

        .menu-item:hover {
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
            transform: translateY(-3px);
        }

        .item-image {
            flex: 0 0 150px;
            height: 150px;
            border-radius: 10px;
            overflow: hidden;
        }

        .item-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .menu-item:hover .item-image img {
            transform: scale(1.05);
        }

        .item-details {
            flex: 1;
            min-width: 0; /* Prevents flex item from overflowing */
        }

        .item-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 10px;
        }

        .item-name {
            font-size: 1.3rem;
            font-weight: 600;
            color: #333;
            margin-right: 10px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .item-description {
            color: #666;
            margin-bottom: 15px;
            line-height: 1.5;
            font-size: 0.95rem;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .item-prices {
            display: flex;
            gap: 20px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }

        .price-full, .price-half {
            display: flex;
            flex-direction: column;
            flex-shrink: 0;
        }

        .price-label {
            font-size: 0.8rem;
            color: #888;
            margin-bottom: 5px;
        }

        .price-value {
            font-size: 1.2rem;
            font-weight: 700;
            color: #a0522d;
        }

        .price-value::before {
            content: "₹";
            font-size: 1rem;
            margin-right: 2px;
        }

        .item-actions {
            display: flex;
            gap: 10px;
            align-items: center;
            flex-wrap: wrap;
        }

        .quantity-selector {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .quantity-btn {
            background-color: #f1ede6;
            border: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            color: #5a4d3f;
        }

        .quantity {
            font-weight: 600;
            min-width: 20px;
            text-align: center;
        }

        .add-to-cart {
            background-color: #a0522d;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px 20px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .add-to-cart:hover {
            background-color: #8a4525;
        }

        /* Badge styles */
        .spicy-badge {
            display: inline-block;
            background-color: #ffe5e5;
            color: #c0392b;
            font-size: 0.75rem;
            padding: 3px 10px;
            border-radius: 20px;
            margin-left: 10px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .veg-badge {
            display: inline-block;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #4a8c4a;
            margin-left: 10px;
            position: relative;
        }

        .veg-badge::after {
            content: "🟢";
            position: absolute;
            top: -2px;
            left: -2px;
            font-size: 0.9rem;
        }

        .non-veg-badge {
            display: inline-block;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background-color: #c0392b;
            margin-left: 10px;
            position: relative;
        }

        .non-veg-badge::after {
            content: "🔴";
            position: absolute;
            top: -2px;
            left: -2px;
            font-size: 0.9rem;
        }

        .signature-badge {
            display: inline-block;
            background-color: #f8ecc9;
            color: #b38b3e;
            font-size: 0.75rem;
            padding: 3px 10px;
            border-radius: 20px;
            margin-left: 10px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        /* Cart Modal */
        .cart-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 2000;
            justify-content: center;
            align-items: center;
        }

        .cart-modal.active {
            display: flex;
        }

        .cart-content {
            background-color: white;
            width: 90%;
            max-width: 800px;
            max-height: 80vh;
            border-radius: 15px;
            padding: 30px;
            overflow-y: auto;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
        }

        .cart-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #eae2d6;
        }

        .cart-header h2 {
            color: #a0522d;
            font-size: 1.8rem;
        }

        .close-cart {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #666;
        }

        .cart-items {
            margin-bottom: 20px;
        }

        .cart-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #eae2d6;
        }

        .cart-item-info {
            display: flex;
            flex-direction: column;
        }

        .cart-item-name {
            font-weight: 600;
            margin-bottom: 5px;
        }

        .cart-item-quantity {
            color: #666;
            font-size: 0.9rem;
        }

        .cart-item-price {
            font-weight: 600;
            color: #a0522d;
        }

        .cart-item-price::before {
            content: "₹";
        }

        .cart-total {
            text-align: right;
            font-size: 1.2rem;
            font-weight: 600;
            color: #a0522d;
            margin-bottom: 20px;
            padding-top: 15px;
            border-top: 2px solid #eae2d6;
        }

        .cart-total::before {
            content: "Total: ₹";
        }

        .cart-actions {
            display: flex;
            gap: 15px;
            justify-content: flex-end;
        }

        .cart-btn-secondary {
            background-color: #f1ede6;
            color: #5a4d3f;
            border: none;
            border-radius: 5px;
            padding: 12px 25px;
            font-weight: 600;
            cursor: pointer;
        }

        .cart-btn-primary {
            background-color: #a0522d;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 12px 25px;
            font-weight: 600;
            cursor: pointer;
        }

        /* Footer */
        .footer {
            text-align: center;
            padding: 40px 20px;
            background-color: #2c2c2c;
            color: #aaa;
            border-radius: 15px 15px 0 0;
            margin-top: 40px;
            position: relative;
            overflow: hidden;
        }

        .footer::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, #a0522d, #f8ecc9, #a0522d);
        }

        .footer h3 {
            color: #f8ecc9;
            margin-bottom: 15px;
            font-weight: 400;
            font-size: 1.8rem;
            font-family: 'Playfair Display', serif;
        }

        .contact-info {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 40px;
            margin-top: 25px;
        }

        .contact-item {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .contact-item i {
            color: #a0522d;
            font-size: 1.2rem;
        }

        .gst-notice {
            background-color: rgba(160, 82, 45, 0.1);
            border: 1px solid rgba(160, 82, 45, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin-top: 30px;
            font-size: 0.85rem;
            color: #d4c9b9;
        }

        /* Toast Notification */
        .toast {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #4a8c4a;
            color: white;
            padding: 15px 25px;
            border-radius: 5px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            z-index: 1001;
            display: none;
            align-items: center;
            gap: 10px;
        }

        .toast.active {
            display: flex;
            animation: slideUp 0.3s ease;
        }

        @keyframes slideUp {
            from { bottom: -50px; opacity: 0; }
            to { bottom: 20px; opacity: 1; }
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .hotel-name {
                font-size: 3rem;
            }
            
            .hotel-tagline {
                font-size: 1.2rem;
                letter-spacing: 5px;
            }
            
            .menu-title {
                font-size: 2.4rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .menu-item {
                gap: 15px;
            }
        }

        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            
            .hotel-name {
                font-size: 2.4rem;
            }
            
            .hotel-tagline {
                font-size: 1.1rem;
                letter-spacing: 4px;
            }
            
            .menu-title {
                font-size: 2rem;
            }
            
            /* Hide regular nav, show mobile slider */
            .menu-nav {
                display: none;
            }
            
            .mobile-slider-nav {
                display: block;
            }
            
            .slider-nav-btn {
                display: none; /* Hide arrows on small screens, rely on swipe */
            }
            
            .slider-wrapper {
                padding: 10px 15px;
            }
            
            .nav-btn {
                padding: 10px 20px;
                font-size: 0.9rem;
            }
            
            .section-title {
                font-size: 1.8rem;
            }
            
            .menu-section {
                padding: 20px;
            }
            
            .menu-item {
                flex-direction: column;
                gap: 15px;
            }
            
            .item-image {
                flex: 0 0 200px;
                width: 100%;
                height: 200px;
            }
            
            .item-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 5px;
            }
            
            .item-name {
                font-size: 1.2rem;
                white-space: normal;
            }
            
            .item-description {
                -webkit-line-clamp: 3;
            }
            
            .item-prices {
                gap: 15px;
            }
            
            .price-full, .price-half {
                flex: 1;
                min-width: 120px;
            }
            
            .cart-container {
                top: 15px;
                right: 15px;
            }
            
            .cart-btn {
                padding: 10px 20px;
                font-size: 0.9rem;
            }
            
            .cart-content {
                padding: 20px;
                width: 95%;
            }
        }

        @media (max-width: 480px) {
            .hotel-name {
                font-size: 1.8rem;
            }
            
            .hotel-tagline {
                font-size: 0.9rem;
                letter-spacing: 3px;
            }
            
            .menu-title {
                font-size: 1.6rem;
            }
            
            .section-title {
                font-size: 1.5rem;
            }
            
            .slider-wrapper {
                padding: 8px 10px;
            }
            
            .nav-btn {
                padding: 8px 16px;
                font-size: 0.85rem;
            }
            
            .category-title {
                font-size: 1.3rem;
            }
            
            .item-image {
                height: 180px;
            }
            
            .item-prices {
                flex-direction: column;
                gap: 10px;
            }
            
            .price-full, .price-half {
                min-width: 100%;
            }
            
            .item-actions {
                flex-direction: column;
                align-items: stretch;
                gap: 15px;
            }
            
            .quantity-selector {
                justify-content: center;
            }
            
            .add-to-cart {
                width: 100%;
                justify-content: center;
            }
            
            .contact-info {
                flex-direction: column;
                gap: 20px;
                text-align: left;
            }
            
            .contact-item {
                justify-content: center;
            }
            
            .cart-container {
                top: 10px;
                right: 10px;
            }
            
            .cart-btn {
                padding: 8px 15px;
                font-size: 0.8rem;
            }
            
            .cart-count {
                width: 20px;
                height: 20px;
                font-size: 0.8rem;
            }
            
            .cart-header h2 {
                font-size: 1.5rem;
            }
            
            .cart-actions {
                flex-direction: column;
                gap: 10px;
            }
            
            .cart-btn-secondary, .cart-btn-primary {
                width: 100%;
                text-align: center;
            }
        }

        @media (min-width: 769px) and (max-width: 1024px) {
            .menu-item {
                flex-direction: row;
            }
            
            .item-image {
                flex: 0 0 130px;
                height: 130px;
            }
            
            .item-name {
                font-size: 1.2rem;
            }
            
            .item-description {
                -webkit-line-clamp: 2;
            }
        }

        /* Touch device optimizations */
        @media (hover: none) and (pointer: coarse) {
            .nav-btn:hover, .add-to-cart:hover, .cart-btn:hover {
                transform: none;
            }
            
            .menu-item:hover {
                transform: none;
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            }
            
            .quantity-btn, .add-to-cart, .nav-btn {
                min-height: 44px; /* Better touch target */
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Cart Button -->
        <div class="cart-container">
            <button class="cart-btn" id="openCartBtn">
                <i class="fas fa-shopping-cart"></i>
                <span>Cart</span>
                <span class="cart-count" id="cartCount">0</span>
            </button>
        </div>

        <!-- Header -->
        <header class="header">
            <h1 class="hotel-name">ROYAL TAJ PALACE</h1>
            <p class="hotel-tagline">FIVE STAR INDIAN DINING</p>
            <h2 class="menu-title">ROYAL INDIAN MENU</h2>
            <p>A journey through India's finest culinary traditions</p>
            <p class="currency-note">All prices in Indian Rupees (₹) | GST extra as applicable</p>
        </header>

        <!-- Desktop Menu Navigation -->
        <div class="menu-nav">
            <button class="nav-btn active" data-section="starters">STARTERS</button>
            <button class="nav-btn" data-section="tandoor">TANDOOR SPECIALS</button>
            <button class="nav-btn" data-section="mains">MAIN COURSES</button>
            <button class="nav-btn" data-section="desserts">DESSERTS</button>
            <button class="nav-btn" data-section="beverages">BEVERAGES</button>
        </div>

        <!-- Mobile Slider Navigation -->
        <div class="mobile-slider-nav">
            <div class="slider-container">
                <button class="slider-nav-btn prev" id="sliderPrevBtn" disabled>
                    <i class="fas fa-chevron-left"></i>
                </button>
                <div class="slider-wrapper" id="sliderWrapper">
                    <button class="nav-btn active" data-section="starters">STARTERS</button>
                    <button class="nav-btn" data-section="tandoor">TANDOOR</button>
                    <button class="nav-btn" data-section="mains">MAINS</button>
                    <button class="nav-btn" data-section="desserts">DESSERTS</button>
                    <button class="nav-btn" data-section="beverages">DRINKS</button>
                </div>
                <button class="slider-nav-btn next" id="sliderNextBtn">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>
        </div>

        <!-- Starters Section -->
        <section id="starters" class="menu-section active">
            <div class="section-header">
                <h2 class="section-title">APPETIZERS & STARTERS</h2>
                <p class="section-subtitle">A sublime beginning to your royal dining experience</p>
            </div>

            <div class="menu-category">
                <h3 class="category-title">VEGETARIAN DELIGHTS</h3>
                
                <div class="menu-item" data-id="1">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1599487488170-d11ec9c172f0?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Paneer Tikka">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Paneer Tikka <span class="veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Succulent cubes of cottage cheese marinated in aromatic spices, yogurt, and grilled in a tandoor. Served with mint chutney and onion rings.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">850</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">450</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="850" data-half-price="450">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="2">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1565557623262-b51c2513a641?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Hara Bhara Kabab">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Hara Bhara Kabab <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Green vegetable patties made with spinach, green peas, potatoes, and spices, shallow fried to perfection. A healthy and flavorful starter.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">750</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">400</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="750" data-half-price="400">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="3">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1563379091339-03246963d9d6?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Crispy Corn Pepper">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Crispy Corn Pepper <span class="veg-badge"></span> <span class="spicy-badge">SPICY</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Crispy fried corn kernels tossed with bell peppers, onions, and a spicy Schezwan sauce. A delightful Indo-Chinese fusion starter.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">680</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">350</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="680" data-half-price="350">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="4">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1589647363585-f4a7d3877b10?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Aloo Tikki Chaat">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Aloo Tikki Chaat <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Crispy potato patties served with chickpeas, yogurt, tamarind chutney, and mint chutney, topped with sev and pomegranate seeds.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">620</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">320</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="620" data-half-price="320">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="menu-category">
                <h3 class="category-title">NON-VEGETARIAN SELECTIONS</h3>
                
                <div class="menu-item" data-id="5">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1603360946369-dc9bb6258143?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Murgh Malai Kabab">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Murgh Malai Kabab <span class="non-veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Tender chicken chunks marinated in cream, cheese, and mild spices, grilled in tandoor. Delicately flavored with cardamom and saffron.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1100</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">580</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1100" data-half-price="580">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="6">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1626645738196-c2a7c87a8f58?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Tandoori Prawns">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Tandoori Jhinga (Prawns) <span class="non-veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Large tiger prawns marinated in yogurt and traditional tandoori spices, skewered and grilled to perfection. Served with lemon wedges.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1350</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">700</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1350" data-half-price="700">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Tandoor Section -->
        <section id="tandoor" class="menu-section">
            <div class="section-header">
                <h2 class="section-title">TANDOOR SPECIALITIES</h2>
                <p class="section-subtitle">Clay oven delicacies with authentic smoky flavors</p>
            </div>

            <div class="menu-category">
                <h3 class="category-title">FROM THE CLAY OVEN</h3>
                
                <div class="menu-item" data-id="7">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1606491956689-2ea866880c84?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Tandoori Murgh">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Tandoori Murgh (Full) <span class="non-veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Whole chicken marinated in yogurt, ginger-garlic paste, and traditional tandoori spices, cooked in clay oven. Served with onion rings and mint chutney.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1850</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">950</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1850" data-half-price="950">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="8">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1546833999-b9f581a1996d?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Paneer Tikka Masala">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Paneer Tikka Masala <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Tandoor-grilled paneer cubes simmered in a rich, creamy tomato and cashew gravy with aromatic spices. A vegetarian delight.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1250</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">650</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1250" data-half-price="650">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="menu-category">
                <h3 class="category-title">TANDOORI BREADS</h3>
                
                <div class="menu-item" data-id="9">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1586190848861-99aa4a171e90?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Butter Naan">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Butter Naan <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Soft, leavened flatbread cooked in tandoor, brushed with butter. Perfect accompaniment to any curry or gravy dish.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Piece</span>
                                <span class="price-value">220</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="220">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="10">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Garlic Naan">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Garlic Naan <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Freshly baked naan topped with finely chopped garlic and cilantro, brushed with butter. Aromatic and flavorful.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Piece</span>
                                <span class="price-value">250</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="250">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Main Courses Section -->
        <section id="mains" class="menu-section">
            <div class="section-header">
                <h2 class="section-title">MAIN COURSES</h2>
                <p class="section-subtitle">Royal gravies and aromatic rice preparations</p>
            </div>

            <div class="menu-category">
                <h3 class="category-title">VEGETARIAN CURRIES</h3>
                
                <div class="menu-item" data-id="11">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1631452180519-c014fe946bc7?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Paneer Butter Masala">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Paneer Butter Masala <span class="veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Cubes of cottage cheese in a rich, creamy tomato gravy with butter, cream, and aromatic spices. A classic North Indian favorite.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1250</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">650</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1250" data-half-price="650">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="12">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1633945274405-b6c8069047b0?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Malai Kofta">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Malai Kofta <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Creamy vegetable dumplings made with paneer and potatoes, served in a rich, creamy gravy with nuts and spices.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1150</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">600</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1150" data-half-price="600">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="menu-category">
                <h3 class="category-title">NON-VEGETARIAN CURRIES</h3>
                
                <div class="menu-item" data-id="13">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1603894584373-5ac82b2ae398?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Butter Chicken">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Butter Chicken <span class="non-veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Tender chicken pieces in a creamy tomato-based gravy enriched with butter, cream, and aromatic spices. Served with butter naan.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1550</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">800</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1550" data-half-price="800">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="14">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1633177310970-6c8c9c37d4df?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Rogan Josh">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Rogan Josh (Lamb) <span class="non-veg-badge"></span> <span class="spicy-badge">SPICY</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Aromatic lamb curry from Kashmir cooked with yogurt, saffron, and traditional spices. Rich, flavorful, and mildly spicy.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1850</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">950</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1850" data-half-price="950">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="menu-category">
                <h3 class="category-title">BIRYANI & RICE</h3>
                
                <div class="menu-item" data-id="15">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1563379091339-03246963d9d6?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Hyderabadi Biryani">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Hyderabadi Dum Biryani (Chicken) <span class="non-veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Fragrant basmati rice layered with marinated chicken, saffron, fried onions, and cooked on dum (slow steam). Served with raita.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Full Portion</span>
                                <span class="price-value">1650</span>
                            </div>
                            <div class="price-half">
                                <span class="price-label">Half Portion</span>
                                <span class="price-value">850</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="1650" data-half-price="850">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Desserts Section -->
        <section id="desserts" class="menu-section">
            <div class="section-header">
                <h2 class="section-title">DESSERTS & SWEETS</h2>
                <p class="section-subtitle">Traditional Indian sweets to complete your royal feast</p>
            </div>

            <div class="menu-category">
                <h3 class="category-title">INDIAN SWEETS</h3>
                
                <div class="menu-item" data-id="16">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1563729784474-d77dbb933a9e?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Gulab Jamun">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Gulab Jamun (2 pcs) <span class="veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Soft, melt-in-the-mouth milk dumplings deep-fried and soaked in sugar syrup flavored with cardamom and rose water.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Serving</span>
                                <span class="price-value">450</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="450">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="17">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1599487488170-d11ec9c172f0?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Rasmalai">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Rasmalai (2 pcs) <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Soft cottage cheese patties soaked in sweetened, thickened milk flavored with cardamom, saffron, and garnished with pistachios.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Serving</span>
                                <span class="price-value">550</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="550">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Beverages Section -->
        <section id="beverages" class="menu-section">
            <div class="section-header">
                <h2 class="section-title">BEVERAGES & DRINKS</h2>
                <p class="section-subtitle">Refreshing drinks to complement your meal</p>
            </div>

            <div class="menu-category">
                <h3 class="category-title">NON-ALCOHOLIC</h3>
                
                <div class="menu-item" data-id="18">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1628992682633-bf2d40cb595f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Mango Lassi">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Mango Lassi <span class="veg-badge"></span> <span class="signature-badge">SIGNATURE</span></h4>
                            </div>
                        </div>
                        <p class="item-description">Refreshing yogurt-based drink blended with ripe mangoes, sugar, and a hint of cardamom. Served chilled.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Glass</span>
                                <span class="price-value">350</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="350">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="menu-item" data-id="19">
                    <div class="item-image">
                        <img src="https://images.unsplash.com/photo-1563379091339-03246963d9d6?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=800&q=80" alt="Masala Chai">
                    </div>
                    <div class="item-details">
                        <div class="item-header">
                            <div>
                                <h4 class="item-name">Masala Chai <span class="veg-badge"></span></h4>
                            </div>
                        </div>
                        <p class="item-description">Traditional Indian tea brewed with milk, ginger, cardamom, cinnamon, and aromatic spices. Served piping hot.</p>
                        <div class="item-prices">
                            <div class="price-full">
                                <span class="price-label">Per Cup</span>
                                <span class="price-value">280</span>
                            </div>
                        </div>
                        <div class="item-actions">
                            <div class="quantity-selector">
                                <button class="quantity-btn minus">-</button>
                                <span class="quantity">1</span>
                                <button class="quantity-btn plus">+</button>
                            </div>
                            <button class="add-to-cart" data-full-price="280">
                                <i class="fas fa-cart-plus"></i> Add to Cart
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="footer">
            <h3>ROYAL TAJ PALACE</h3>
            <p>Authentic Indian Cuisine • Royal Dining Experience • Master Chefs</p>
            
            <div class="contact-info">
                <div class="contact-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>101 Maharaja Road, Diplomatic Enclave, New Delhi 110001</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <span>Reservations: +91 11 1234 5678</span>
                </div>
                <div class="contact-item">
                    <i class="fas fa-clock"></i>
                    <span>Dining Hours: 12:00 PM - 11:30 PM</span>
                </div>
            </div>
            
            <div class="gst-notice">
                <p><strong>Pricing Information:</strong> All prices are in Indian Rupees (₹). 18% GST applicable on all food and beverages. 10% service charge applicable on total bill. Prices are subject to change without prior notice.</p>
            </div>
            
            <p style="margin-top: 25px; font-size: 0.9rem; color: #d4c9b9;">*Vegetarian and vegan options available. Please inform server of any allergies.</p>
            <p style="margin-top: 10px; font-size: 0.85rem; color: #999;">© 2023 Royal Taj Palace. All rights reserved.</p>
        </footer>
    </div>

    <!-- Cart Modal -->
    <div class="cart-modal" id="cartModal">
        <div class="cart-content">
            <div class="cart-header">
                <h2>Your Order</h2>
                <button class="close-cart" id="closeCartBtn">&times;</button>
            </div>
            <div class="cart-items" id="cartItems">
                <!-- Cart items will be added here dynamically -->
                <p style="text-align: center; color: #999; padding: 40px 0;">Your cart is empty</p>
            </div>
            <div class="cart-total" id="cartTotal">0</div>
            <div class="cart-actions">
                <button class="cart-btn-secondary" id="clearCartBtn">Clear Cart</button>
                <button class="cart-btn-primary" id="checkoutBtn">Proceed to Checkout</button>
            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div class="toast" id="toast">
        <i class="fas fa-check-circle"></i>
        <span id="toastMessage">Item added to cart!</span>
    </div>

    <script>
        // Cart functionality
        let cart = [];
        const cartCount = document.getElementById('cartCount');
        const cartItems = document.getElementById('cartItems');
        const cartTotal = document.getElementById('cartTotal');
        const cartModal = document.getElementById('cartModal');
        const openCartBtn = document.getElementById('openCartBtn');
        const closeCartBtn = document.getElementById('closeCartBtn');
        const clearCartBtn = document.getElementById('clearCartBtn');
        const checkoutBtn = document.getElementById('checkoutBtn');
        const toast = document.getElementById('toast');
        const toastMessage = document.getElementById('toastMessage');

        // Mobile slider navigation elements
        const sliderPrevBtn = document.getElementById('sliderPrevBtn');
        const sliderNextBtn = document.getElementById('sliderNextBtn');
        const sliderWrapper = document.getElementById('sliderWrapper');
        const mobileNavBtns = sliderWrapper.querySelectorAll('.nav-btn');

        // Tab navigation functionality
        document.addEventListener('DOMContentLoaded', function() {
            const navButtons = document.querySelectorAll('.nav-btn');
            const menuSections = document.querySelectorAll('.menu-section');
            
            // Function to switch sections
            function switchSection(sectionId) {
                // Remove active class from all buttons and sections
                navButtons.forEach(btn => btn.classList.remove('active'));
                menuSections.forEach(section => section.classList.remove('active'));
                
                // Add active class to clicked button
                document.querySelectorAll(`.nav-btn[data-section="${sectionId}"]`).forEach(btn => {
                    btn.classList.add('active');
                });
                
                // Show corresponding section
                document.getElementById(sectionId).classList.add('active');
                
                // Update slider position for mobile
                updateSliderPosition();
            }
            
            // Desktop and mobile nav button event listeners
            navButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const sectionId = this.getAttribute('data-section');
                    switchSection(sectionId);
                    
                    // Smooth scroll to section on mobile
                    if (window.innerWidth <= 768) {
                        document.getElementById(sectionId).scrollIntoView({ 
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });
            
            // Mobile slider navigation
            function updateSliderPosition() {
                const activeBtn = sliderWrapper.querySelector('.nav-btn.active');
                if (activeBtn) {
                    const containerWidth = sliderWrapper.parentElement.clientWidth;
                    const btnLeft = activeBtn.offsetLeft;
                    const btnWidth = activeBtn.clientWidth;
                    
                    // Center the active button
                    sliderWrapper.scrollLeft = btnLeft - (containerWidth / 2) + (btnWidth / 2);
                    
                    // Update arrow button states
                    updateSliderArrows();
                }
            }
            
            function updateSliderArrows() {
                const scrollLeft = sliderWrapper.scrollLeft;
                const maxScroll = sliderWrapper.scrollWidth - sliderWrapper.clientWidth;
                
                sliderPrevBtn.disabled = scrollLeft <= 0;
                sliderNextBtn.disabled = scrollLeft >= maxScroll - 5; // Allow for rounding errors
            }
            
            // Slider arrow button events
            sliderPrevBtn.addEventListener('click', () => {
                sliderWrapper.scrollBy({ left: -200, behavior: 'smooth' });
            });
            
            sliderNextBtn.addEventListener('click', () => {
                sliderWrapper.scrollBy({ left: 200, behavior: 'smooth' });
            });
            
            // Update slider arrows on scroll
            sliderWrapper.addEventListener('scroll', updateSliderArrows);
            
            // Initial slider update
            if (window.innerWidth <= 768) {
                updateSliderPosition();
                updateSliderArrows();
            }
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth <= 768) {
                    updateSliderPosition();
                    updateSliderArrows();
                }
            });
            
            // Quantity selectors
            document.querySelectorAll('.quantity-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const container = this.closest('.quantity-selector');
                    const quantitySpan = container.querySelector('.quantity');
                    let quantity = parseInt(quantitySpan.textContent);
                    
                    if (this.classList.contains('minus')) {
                        if (quantity > 1) {
                            quantitySpan.textContent = quantity - 1;
                        }
                    } else if (this.classList.contains('plus')) {
                        quantitySpan.textContent = quantity + 1;
                    }
                });
            });
            
            // Add to cart buttons
            document.querySelectorAll('.add-to-cart').forEach(btn => {
                btn.addEventListener('click', function() {
                    const menuItem = this.closest('.menu-item');
                    const itemId = menuItem.getAttribute('data-id');
                    const itemName = menuItem.querySelector('.item-name').textContent;
                    const quantity = parseInt(menuItem.querySelector('.quantity').textContent);
                    const fullPrice = parseFloat(this.getAttribute('data-full-price'));
                    const halfPrice = this.getAttribute('data-half-price') ? parseFloat(this.getAttribute('data-half-price')) : null;
                    
                    // For now, always add full portion
                    const price = fullPrice;
                    const portionType = 'Full';
                    
                    addToCart(itemId, itemName, quantity, price, portionType);
                    showToast(`${itemName} added to cart!`);
                    
                    // Reset quantity
                    menuItem.querySelector('.quantity').textContent = '1';
                });
            });
            
            // Cart modal controls
            openCartBtn.addEventListener('click', () => {
                cartModal.classList.add('active');
                updateCartDisplay();
            });
            
            closeCartBtn.addEventListener('click', () => {
                cartModal.classList.remove('active');
            });
            
            cartModal.addEventListener('click', (e) => {
                if (e.target === cartModal) {
                    cartModal.classList.remove('active');
                }
            });
            
            clearCartBtn.addEventListener('click', () => {
                if (cart.length > 0) {
                    if (confirm('Are you sure you want to clear your cart?')) {
                        cart = [];
                        updateCart();
                        showToast('Cart cleared!');
                    }
                }
            });
            
            checkoutBtn.addEventListener('click', () => {
                if (cart.length === 0) {
                    showToast('Your cart is empty!');
                } else {
                    alert('Thank you for your order! Your total is ₹' + calculateTotal() + '. This is a demo - in a real application, this would proceed to checkout.');
                    cart = [];
                    updateCart();
                    cartModal.classList.remove('active');
                }
            });
            
            // Add touch swipe for mobile slider
            let touchStartX = 0;
            let touchEndX = 0;
            
            sliderWrapper.addEventListener('touchstart', (e) => {
                touchStartX = e.changedTouches[0].screenX;
            });
            
            sliderWrapper.addEventListener('touchend', (e) => {
                touchEndX = e.changedTouches[0].screenX;
                handleSwipe();
            });
            
            function handleSwipe() {
                const swipeThreshold = 50;
                
                if (touchEndX < touchStartX - swipeThreshold) {
                    // Swipe left - scroll right
                    sliderWrapper.scrollBy({ left: 200, behavior: 'smooth' });
                }
                
                if (touchEndX > touchStartX + swipeThreshold) {
                    // Swipe right - scroll left
                    sliderWrapper.scrollBy({ left: -200, behavior: 'smooth' });
                }
            }
        });
        
        // Cart functions
        function addToCart(id, name, quantity, price, portionType) {
            // Check if item already exists in cart
            const existingItemIndex = cart.findIndex(item => item.id === id && item.portionType === portionType);
            
            if (existingItemIndex > -1) {
                // Update quantity
                cart[existingItemIndex].quantity += quantity;
            } else {
                // Add new item
                cart.push({
                    id,
                    name,
                    quantity,
                    price,
                    portionType
                });
            }
            
            updateCart();
        }
        
        function updateCart() {
            // Update cart count
            const totalItems = cart.reduce((total, item) => total + item.quantity, 0);
            cartCount.textContent = totalItems;
            
            // Save to localStorage
            localStorage.setItem('cart', JSON.stringify(cart));
        }
        
        function updateCartDisplay() {
            if (cart.length === 0) {
                cartItems.innerHTML = '<p style="text-align: center; color: #999; padding: 40px 0;">Your cart is empty</p>';
                cartTotal.textContent = '0';
                return;
            }
            
            let itemsHTML = '';
            cart.forEach(item => {
                itemsHTML += `
                    <div class="cart-item">
                        <div class="cart-item-info">
                            <div class="cart-item-name">${item.name} (${item.portionType})</div>
                            <div class="cart-item-quantity">Quantity: ${item.quantity}</div>
                        </div>
                        <div class="cart-item-price">${item.price * item.quantity}</div>
                    </div>
                `;
            });
            
            cartItems.innerHTML = itemsHTML;
            cartTotal.textContent = calculateTotal();
        }
        
        function calculateTotal() {
            return cart.reduce((total, item) => total + (item.price * item.quantity), 0);
        }
        
        function showToast(message) {
            toastMessage.textContent = message;
            toast.classList.add('active');
            
            setTimeout(() => {
                toast.classList.remove('active');
            }, 3000);
        }
        
        // Load cart from localStorage on page load
        window.addEventListener('load', () => {
            const savedCart = localStorage.getItem('cart');
            if (savedCart) {
                cart = JSON.parse(savedCart);
                updateCart();
            }
        });
    </script>
</body>
</html>