<!DOCTYPE html>
<html lang="en">

<?php 
include('head.php'); 
include('conection.php');
?>

<body>
    <div class="container-fluid bg-white p-0">

        <!-- Header Start -->
        <?php include('nav.php'); ?>
        <!-- Header End -->


        <!-- Page Header Start -->
        <div class="container-fluid p-0 mb-5" style="background-image: url(img/carousel-1.jpg);">
            <div class="container-fluid page-header-inner py-5">
                <div class="container text-center pb-5">
                    <h1 class="display-3 text-white mb-3 animated slideInDown">Gallery</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb justify-content-center text-uppercase">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Pages</a></li>
                            <li class="breadcrumb-item text-white active" aria-current="page">Gallery</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Booking Start -->
        <?php include 'commonbooking.php'; ?>
        <!-- Booking End -->


        

        <div class="container-fluid py-5 bg-light">
    <div class="container py-5">

        <!-- <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase" style="letter-spacing:4px;">Our Gallery</h5>
        </div> -->

        <div class="d-flex justify-content-start gap-3 mt-3 flex-wrap" style="zoom:1.2;">
    <select class="form-select w-auto" id="categoryFilter">
        <option value="">Select Category</option>
        <?php
        $catQuery = mysqli_query($conn, "SELECT DISTINCT catogeryId FROM gallery WHERE status = 1");
        while ($row = mysqli_fetch_assoc($catQuery)) {
            $selectcategory = mysqli_query($conn, "SELECT * FROM category WHERE Id = {$row['catogeryId']}");
            if ($selectcategory && mysqli_num_rows($selectcategory) > 0) {
                $rowcategory = mysqli_fetch_assoc($selectcategory);
                echo '<option value="' . $row['catogeryId'] . '">' . htmlspecialchars($rowcategory['name']) . '</option>';
            }
        }
        ?>
    </select>
</div>

<!-- EMPTY CONTAINER – Filled only after dropdown select -->
<div id="galleryContainer" class="mt-5"></div>


<!-- Gallery Items -->
<div class="mt-5" id="galleryContainer">
    <?php
    // Set Weekend Tour default category ID
    $defaultCat = 7;

    // Fetch all gallery items (status = 1)
    $galleryQuery = mysqli_query($conn,
        "SELECT * FROM gallery WHERE status = 1 ORDER BY catogeryId, orderby ASC"
    );

    // Group by category
    $galleryData = [];
    while ($row = mysqli_fetch_assoc($galleryQuery)) {
        $galleryData[$row['catogeryId']][] = $row;
    }

    // Loop categories
    foreach ($galleryData as $catId => $items) {

        // Get category name
        $catRes = mysqli_query($conn, "SELECT * FROM category WHERE Id = $catId");
        $catRow = mysqli_fetch_assoc($catRes);
        $catName = htmlspecialchars($catRow['name']);

        // Show Weekend Tour by default
        $display = ($catId == $defaultCat) ? 'block' : 'none';

        echo '<div class="gallery-category mb-5" data-category="' . $catId . '" style="display:' . $display . ';">';
        echo '<h3 class="mb-4 text-primary">' . $catName . ' Gallery</h3>';
        echo '<div class="row g-4">';

        foreach ($items as $item) {

            $imagePath = '../viphoteladda/images/gallery/' . $item['image'];
            // $itemName  = htmlspecialchars($item['name']);

            echo '
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="gallery-item shadow-sm rounded overflow-hidden">
                    <img src="' . $imagePath . '" class="img-fluid" alt="' . $itemName . '">
                    <h4>' . $itemName . '</h4>
                </div>
            </div>';
        }

        echo '</div></div>'; // close row + category
    }
    ?>
</div>




    </div>
</div>


<!-- CSS -->
<style>

.service-desc {
    color: #6c757d;
    line-height: 1.6;
}

.service-row {
    padding: 25px 0;
    border-bottom: 1px solid rgba(0,0,0,0.05);
}

.service-row:last-child {
    border-bottom: none;
}

/* Image Styling */
.service-img {
    width: 100%;
    border-radius: 14px;
    box-shadow: 0 6px 16px rgba(0,0,0,0.10);
    object-fit: cover;
}

/* Right-align content only on large screens */
.text-lg-end {
    text-align: right;
}

@media (max-width: 991px) {
    .text-lg-end {
        text-align: left !important;
    }
}

</style>

        
        <!-- <br> -->
        <!-- <br> -->
        <!-- Service End -->


        <!-- Testimonial Start -->
        <?php include('testimonialshort.php'); ?>
        <br>
        <!-- <br> -->
        <!-- Testimonial End -->


        <!-- Newsletter Start -->
        <!-- <div class="container newsletter mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="row justify-content-center">
                <div class="col-lg-10 border rounded p-1">
                    <div class="border rounded text-center p-1">
                        <div class="bg-white rounded text-center p-5">
                            <h4 class="mb-4">Subscribe Our <span class="text-primary text-uppercase">Newsletter</span></h4>
                            <div class="position-relative mx-auto" style="max-width: 400px;">
                                <input class="form-control w-100 py-3 ps-4 pe-5" type="text" placeholder="Enter your email">
                                <button type="button" class="btn btn-primary py-2 px-3 position-absolute top-0 end-0 mt-2 me-2">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <!-- Newsletter Start -->
        
<script>
document.getElementById("categoryFilter").addEventListener("change", function () {
    let selected = this.value;

    // Hide all
    document.querySelectorAll(".gallery-category").forEach(sec => {
        sec.style.display = "none";
    });

    // If nothing selected → show default Weekend Tour
    if (selected === "") {
        document.querySelector('[data-category="5"]').style.display = "block"; // change ID
        return;
    }

    // Show selected
    document.querySelector('[data-category="' + selected + '"]').style.display = "block";
});
</script>


        <!-- Footer Start -->
        <?php include('footer.php'); ?>
</body>

</html>