<?php 
// Default values
$today = date('Y-m-d');
$tomorrow = date('Y-m-d', strtotime('+1 day'));

// Get values from POST or GET
$check_in  = $_POST['check_in']  ?? ($_GET['check_in']  ?? $today);
$check_out = $_POST['check_out'] ?? ($_GET['check_out'] ?? $tomorrow);
$adults    = $_POST['adults']    ?? ($_GET['adults']    ?? '1');
$children  = $_POST['children']  ?? ($_GET['children']  ?? '0');

// Auto-set checkout = checkin +1 day if user changes checkin
if (strtotime($check_out) <= strtotime($check_in)) {
    $check_out = date('Y-m-d', strtotime($check_in . ' +1 day'));
}
?>

<div class="container-fluid booking pb-5 wow fadeIn mt-5" data-wow-delay="0.1s">
    <div class="container">
        <div class="bg-white shadow p-4">
            <h4 class="mb-4">Book Your Stay</h4>

            <?php if(isset($message)) echo $message; ?>

            <form method="POST" action="room.php">
                <div class="row g-2 align-items-end">
                    <div class="col-md-3">
                        <label>Check-In</label>
                        <input type="date" 
                               name="check_in" 
                               class="form-control" 
                               required 
                               min="<?= $today ?>"
                               value="<?= htmlspecialchars($check_in) ?>"
                               onchange="autoSetCheckout(this)">
                    </div>

                    <div class="col-md-3">
                        <label>Check-Out</label>
                        <input type="date" 
                               name="check_out" 
                               class="form-control" 
                               required 
                               min="<?= $tomorrow ?>"
                               value="<?= htmlspecialchars($check_out) ?>">
                    </div>

                    <div class="col-md-2">
                        <label>Adults</label>
                        <select name="adults" class="form-select">
                            <?php
                            for ($i = 1; $i <= 3; $i++) {
                                $selected = ($adults == $i) ? 'selected' : '';
                                echo "<option value='$i' $selected>$i Adult" . ($i > 1 ? 's' : '') . "</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label>Children</label>
                        <select name="children" class="form-select">
                            <?php
                            for ($i = 0; $i <= 2; $i++) {
                                $selected = ($children == $i) ? 'selected' : '';
                                echo "<option value='$i' $selected>$i " . ($i == 1 ? 'Child' : 'Children') . "</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary w-100">Check Now</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function autoSetCheckout(input) {
    const checkInDate = new Date(input.value);
    if (!isNaN(checkInDate)) {
        checkInDate.setDate(checkInDate.getDate() + 1);
        const nextDay = checkInDate.toISOString().split('T')[0];
        document.querySelector('[name="check_out"]').value = nextDay;
        document.querySelector('[name="check_out"]').min = nextDay;
    }
}
</script>
