<!DOCTYPE html>
<html lang="en">

<?php 
include('head.php'); 
include('conection.php');
?>

<body>
    <div class="container-fluid bg-white p-0">
        <!-- Spinner Start -->
        <?php include('nav.php'); ?>


        <!-- Page Header Start -->
        <div class="container-fluid p-0 mb-5" style="background-image: url(img/carousel-1.jpg);">
            <div class="container-fluid page-header-inner py-5">
                <div class="container text-center pb-5">
                    <h1 class="display-3 text-white mb-3 animated slideInDown">About Us</h1>
                    <!-- <nav aria-label="breadcrumb">
                        <ol class="breadcrumb justify-content-center text-uppercase">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Pages</a></li>
                            <li class="breadcrumb-item text-white active" aria-current="page">About</li>
                        </ol>
                    </nav> -->
                </div>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Booking Start -->
        <?php include 'commonbooking.php'; ?>
        <!-- Booking End -->

        
        <!-- About Start -->
        <!-- About Us Start -->
<div class="container-fluid p-0 mb-5">
    <div class="container py-5">
        <div class="row align-items-center">
            <div class="col-lg-5">
                <img class="img-fluid rounded mb-4 mb-lg-0 shadow-lg" src="img/hotel.jpg" alt="About Golden Heights Hotel" width="500px">
            </div>
            <div class="col-lg-7">
                <div class="text-left mb-4">
                    <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">About Us</h5>
                    <h1 class="mb-3 fw-bold">Experience Comfort, Style & Exceptional Hospitality</h1>
                </div>

                <p class="mb-4">
                    <strong>Golden Heights</strong>, established in <strong>2011</strong>, is a premium hospitality destination designed for guests who value comfort, luxury, and exceptional service. 
                    Located in a prime area, our hotel provides a perfect blend of elegance and warmth, making it the ideal choice for business travelers, families, and tourists alike.
                </p>

                <p class="mb-4">
                    Our hotel features a <strong>stylish, well-stocked bar</strong> where guests can unwind with premium beverages in a relaxing ambiance. The 
                    <strong>in-house restaurant</strong> serves delicious multi-cuisine dishes prepared by experienced chefs — ensuring every meal brings joy and satisfaction.
                </p>

                <p class="mb-4">
                    At Golden Heights, guest well-being is our priority. We offer <strong>Doctor on Call</strong> services for emergency assistance, ensuring a safe and secure stay. 
                    Our professional <strong>laundry services</strong> provide convenience and comfort for long-stay guests, corporate travelers, and families.
                </p>

                <p class="mb-4">
                    With thoughtfully designed rooms, modern amenities, 24x7 support, and a commitment to quality, <strong>Golden Heights</strong> continues to delight guests with an unforgettable hospitality experience — 
                    combining style, comfort, and exceptional service under one roof.
                </p>

            </div>
        </div>
    </div>
</div>
<!-- About Us End -->

<!-- Founder Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="row align-items-center">
         
            <div class="col-lg-7">
                <div class="text-left mb-4">
                    <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Founder</h5>
                    <h1 class="fw-bold mb-3">Taranath Sitimani</h1>
                    <h6 class="text-muted mb-4">Founder of Golden Heights (Established in 2011)</h6>
                </div>

                <p class="mb-4">
                    <strong>Taranath Sitimani</strong> is the visionary force behind <strong>Golden Heights</strong>. 
                    With a deep belief in creating meaningful impact and long-term growth, he founded the institution in <strong>2011</strong> 
                    to empower individuals and uplift the community.
                </p>

                <p class="mb-4">
                    Under his dedicated leadership, Golden Heights has evolved into a trusted and respected name, 
                    known for its commitment to quality, integrity, and people-centered values. 
                    His strong vision and disciplined approach continue to shape the identity and direction of the institution.
                </p>

                <p class="mb-4">
                    He firmly believes that 
                    <em>“Every great journey begins with a vision, discipline, and a commitment to uplift others.”</em> 
                    This guiding principle has played a central role in the growth and success of Golden Heights.
                </p>

                <p class="mb-4">
                    His humility, dedication, and passion for community development have earned him respect and admiration, 
                    making Golden Heights a true reflection of his values and mission.
                </p>

                <a href="contact.php" class="btn btn-primary py-md-2 px-md-4 fw-semibold rounded-pill shadow-sm mt-2">Contact Us</a>
            </div>

            <div class="col-lg-5 mb-4 mb-lg-0">
                <img class="img-fluid rounded shadow-lg" src="img/chairman.jpg" alt="Taranath Sitimani - Founder of Golden Heights">
            </div>

        </div>
    </div>
</div>
<!-- Founder End -->


<!-- Vision & Mission Start -->
<!-- <div class="container-fluid py-5 bg-light">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Philosophy</h5>
            <h1 class="fw-bold">Vision & Mission</h1>
        </div>

        <div class="row g-4">
            Vision
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <i class="fa fa-eye fa-3x text-primary mb-3"></i>
                            <h3 class="card-title fw-bold">Our Vision</h3>
                        </div>
                        <p class="card-text text-muted">
                            To be a leading hospitality destination known for comfort, innovation, warm service, and memorable guest experiences. 
                            We aim to provide world-class facilities while maintaining a welcoming and homely environment.
                        </p>
                    </div>
                </div>
            </div>

            Mission
            <div class="col-lg-6">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <i class="fa fa-bullseye fa-3x text-primary mb-3"></i>
                            <h3 class="card-title fw-bold">Our Mission</h3>
                        </div>
                        <p class="card-text text-muted">
                            To deliver exceptional hospitality by providing clean, comfortable rooms, delicious food, friendly service, and modern facilities — 
                            ensuring every guest feels valued and cared for throughout their stay.
                        </p>
                        <ul class="list-unstyled text-start mt-3">
                            <li class="mb-2"><i class="fa fa-check text-primary me-2"></i>Commitment to guest comfort & satisfaction</li>
                            <li class="mb-2"><i class="fa fa-check text-primary me-2"></i>Delicious food & premium beverages</li>
                            <li class="mb-2"><i class="fa fa-check text-primary me-2"></i>Hygienic, safe & well-maintained environment</li>
                            <li class="mb-2"><i class="fa fa-check text-primary me-2"></i>24x7 support with trained staff</li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div> -->
<!-- Vision & Mission End -->

<!-- Philosophy Start -->
<!-- <div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Philosophy</h5>
            <h1 class="fw-bold">Vision & Mission</h1>
        </div>

        <div class="row g-5 align-items-center">

            Vision
            <div class="col-lg-6">
                <div class="p-4 bg-light rounded-3 shadow-sm position-relative border-start border-4 border-primary">
                    <span class="position-absolute top-50 start-0 translate-middle p-3 bg-primary rounded-circle"></span>
                    <h3 class="text-primary mb-3">Our Vision</h3>
                    <p>
                        To build a trusted name in hospitality known for comfort, elegance, 
                        and unforgettable service excellence.
                    </p>
                </div>
            </div>

            Mission
            <div class="col-lg-6">
                <div class="p-4 bg-primary text-white rounded-3 shadow-sm position-relative border-start border-4 border-white">
                    <span class="position-absolute top-50 start-0 translate-middle p-3 bg-white rounded-circle"></span>
                    <h3 class="text-white mb-3">Our Mission</h3>
                    <p>
                        To consistently deliver superior hospitality, ensure guest satisfaction, 
                        and keep improving our services with a warm, personalized touch.
                    </p>
                </div>
            </div>

        </div>
    </div>
</div> -->
<!-- Philosophy End -->


<!-- Philosophy Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Philosophy</h5>
            <h1 class="fw-bold">Vision & Mission</h1>
        </div>

        <div class="row text-center g-4">

            <!-- Vision -->
            <div class="col-md-6">
                <div class="p-4 rounded shadow-sm bg-light border-top border-4 border-primary">
                    <div class="mb-3">
                        <i class="fa fa-eye text-primary fa-3x"></i>
                    </div>
                    <h3 class="text-primary mb-3">Our Vision</h3>
                    <p>
                        To redefine hospitality with elegance, comfort, and a guest-first approach that 
                        creates lasting experiences.
                    </p>
                </div>
            </div>

            <!-- Mission -->
            <div class="col-md-6">
                <div class="p-4 rounded shadow-sm bg-primary text-white border-top border-4 border-white">
                    <div class="mb-3">
                        <i class="fa fa-bullseye text-white fa-3x"></i>
                    </div>
                    <h3 class="text-white mb-3">Our Mission</h3>
                    <p>
                        To provide excellent service, maintain high-quality hospitality, 
                        and offer a seamless stay for every guest who walks through our doors.
                    </p>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- Philosophy End -->



<!-- Facilities Start -->
<?php include('facilities.php'); ?>
<!-- Facilities End -->


<!-- Awards & Recognition Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Awards & Recognition</h5>
            <h1 class="fw-bold">Our Achievements</h1>
            <p class="text-muted">Honored for excellence, service quality, and guest satisfaction.</p>
        </div>

        <div class="row g-4">

            <!-- Award 1 -->
            <div class="col-lg-4 col-md-6">
                <div class="card shadow-sm border-0 h-100 text-center p-4">
                    <i class="fa fa-trophy fa-3x text-primary mb-3"></i>
                    <h4 class="fw-bold">Guest Excellence Award</h4>
                    <p class="text-muted">
                        Recognized for maintaining outstanding hospitality standards and exceptional guest satisfaction.
                    </p>
                </div>
            </div>

            <!-- Award 2 -->
            <div class="col-lg-4 col-md-6">
                <div class="card shadow-sm border-0 h-100 text-center p-4">
                    <i class="fa fa-star fa-3x text-primary mb-3"></i>
                    <h4 class="fw-bold">Top Rated Hotel</h4>
                    <p class="text-muted">
                        Consistently rated among the best hotels in the region for comfort, cleanliness, and service.
                    </p>
                </div>
            </div>

            <!-- Award 3 -->
            <div class="col-lg-4 col-md-6">
                <div class="card shadow-sm border-0 h-100 text-center p-4">
                    <i class="fa fa-glass-cheers fa-3x text-primary mb-3"></i>
                    <h4 class="fw-bold">Best Bar & Lounge</h4>
                    <p class="text-muted">
                        Awarded for offering a premium bar atmosphere with exceptional service and beverage quality.
                    </p>
                </div>
            </div>

            <!-- Award 4 -->
            <div class="col-lg-4 col-md-6">
                <div class="card shadow-sm border-0 h-100 text-center p-4">
                    <i class="fa fa-utensils fa-3x text-primary mb-3"></i>
                    <h4 class="fw-bold">Dining Excellence</h4>
                    <p class="text-muted">
                        Recognized for providing delicious multi-cuisine dining with fresh ingredients & expert chefs.
                    </p>
                </div>
            </div>

            <!-- Award 5 -->
            <div class="col-lg-4 col-md-6">
                <div class="card shadow-sm border-0 h-100 text-center p-4">
                    <i class="fa fa-medal fa-3x text-primary mb-3"></i>
                    <h4 class="fw-bold">Trusted Hospitality</h4>
                    <p class="text-muted">
                        Over 14 years of delivering reliable service, comfort, and memorable guest experiences.
                    </p>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- Awards & Recognition End -->


<!-- Gallery Start -->
<?php include('explore.php'); ?>
<!-- Gallery End -->


<!-- Our Journey Start -->
<div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Journey</h5>
            <h1 class="fw-bold">Milestones of Golden Heights</h1>
            <!-- <p>From a humble beginning in 2011 to becoming a stylish hotel with bar & restaurant services.</p> -->
        </div>

        <div class="timeline">

            <!-- 2011 -->
            <div class="timeline-item left">
                <div class="timeline-content bg-light p-4 rounded shadow-sm">
                    <h4>2011 – Establishment</h4>
                    <p>Golden Heights was founded with a vision to offer comfortable, stylish, and guest-focused hospitality.</p>
                </div>
            </div>

            <!-- 2014 -->
            <div class="timeline-item right">
                <div class="timeline-content bg-primary text-white p-4 rounded shadow-sm">
                    <h4>2014 – Restaurant Expansion</h4>
                    <p>Launched our in-house multi-cuisine restaurant serving delicious meals prepared by expert chefs.</p>
                </div>
            </div>

            <!-- 2016 -->
            <div class="timeline-item left">
                <div class="timeline-content bg-light p-4 rounded shadow-sm">
                    <h4>2016 – Stylish Bar Launched</h4>
                    <p>Opened a premium bar offering an elegant ambiance and a wide range of beverages.</p>
                </div>
            </div>

            <!-- 2019 -->
            <div class="timeline-item right">
                <div class="timeline-content bg-primary text-white p-4 rounded shadow-sm">
                    <h4>2019 – Facilities Upgrade</h4>
                    <p>Upgraded rooms, added doctor-on-call, enhanced laundry services, and improved guest comfort.</p>
                </div>
            </div>

            <!-- 2023 -->
            <div class="timeline-item left">
                <div class="timeline-content bg-light p-4 rounded shadow-sm">
                    <h4>2023 – Modernization & Renovation</h4>
                    <p>Introduced modern interiors, upgraded rooms, improved safety standards, and seamless service workflows.</p>
                </div>
            </div>

            <!-- 2025 -->
            <div class="timeline-item right">
                <div class="timeline-content bg-primary text-white p-4 rounded shadow-sm">
                    <h4>2025 – Excellence & Growth</h4>
                    <p>Golden Heights continues to grow as a preferred stay & dining destination with consistent guest satisfaction.</p>
                </div>
            </div>

        </div>
    </div>
</div>
<!-- Our Journey End -->

<!-- Timeline CSS -->
<style>
    .timeline {
        position: relative;
        max-width: 900px;
        margin: auto;
    }
    .timeline::after {
        content: '';
        position: absolute;
        width: 6px;
        background-color: #007bff;
        top: 0;
        bottom: 0;
        left: 50%;
        margin-left: -3px;
    }
    .timeline-item {
        padding: 10px 40px;
        position: relative;
        width: 50%;
    }
    .timeline-item::after {
        content: '';
        position: absolute;
        width: 25px;
        height: 25px;
        right: -13px;
        background-color: #fff;
        border: 4px solid #007bff;
        top: 15px;
        border-radius: 50%;
        z-index: 1;
    }
    .timeline-item.left { left: 0; }
    .timeline-item.right { left: 50%; }
    .timeline-item.right::after { left: -13px; }
    .timeline-content {
        padding: 20px 30px;
    }
    @media screen and (max-width: 768px) {
        .timeline-item {
            width: 100%;
            padding-left: 70px;
            padding-right: 25px;
        }
        .timeline-item.right {
            left: 0%;
        }
        .timeline::after {
            left: 30px;
        }
        .timeline-item::after {
            left: 18px;
        }
    }
</style>
<!-- <div class="container-fluid py-5">
    <div class="container py-5">
        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Journey</h5>
            <h1 class="fw-bold">Milestones of Golden Heights</h1>
        </div>

        <div class="horizontal-timeline">

            <div class="timeline-item">
                <h4>2011</h4>
                <p>Golden Heights was founded with a vision to offer stylish and guest-focused hospitality.</p>
            </div>

            <div class="timeline-item">
                <h4>2014</h4>
                <p>Launched our in-house multi-cuisine restaurant serving delicious meals.</p>
            </div>

            <div class="timeline-item">
                <h4>2016</h4>
                <p>Introduced a premium bar with elegant ambiance and top beverages.</p>
            </div>

            <div class="timeline-item">
                <h4>2019</h4>
                <p>Upgraded rooms, added doctor-on-call and improved guest comfort.</p>
            </div>

            <div class="timeline-item">
                <h4>2023</h4>
                <p>Renovated interiors, upgraded rooms, and enhanced safety standards.</p>
            </div>

            <div class="timeline-item">
                <h4>2025</h4>
                <p>Continues to grow as a preferred stay & dining destination.</p>
            </div>

        </div>
    </div>
</div>
<style>
.horizontal-timeline {
    display: flex;
    gap: 20px;
    overflow-x: auto;
    padding-bottom: 20px;
    scrollbar-width: thin;
}

.horizontal-timeline::-webkit-scrollbar {
    height: 8px;
}

.horizontal-timeline::-webkit-scrollbar-thumb {
    background: #0d6efd;
    border-radius: 10px;
}

.timeline-item {
    min-width: 260px;
    background: #ffffff;
    padding: 20px;
    border-radius: 15px;
    border-top: 6px solid #0d6efd;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: 0.3s;
}

.timeline-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 22px rgba(0,0,0,0.15);
}

.timeline-item h4 {
    font-weight: bold;
    color: #0d6efd;
}

.timeline-item p {
    margin: 0;
    font-size: 15px;
    color: #555;
}

</style> -->
<!-- <div class="container-fluid py-5">
    <div class="container py-5">

        <div class="text-center mb-5">
            <h5 class="text-primary text-uppercase mb-2" style="letter-spacing: 4px;">Our Journey</h5>
            <h1 class="fw-bold">Milestones of Golden Heights</h1>
        </div>

        <div class="pro2-timeline">

            <div class="pro2-item">
                <div class="pro2-year">2011</div>
                <div class="pro2-card">
                    <h4>Establishment</h4>
                    <p>Golden Heights began with a mission to deliver comfort and refined hospitality.</p>
                </div>
            </div>

            <div class="pro2-item">
                <div class="pro2-year">2014</div>
                <div class="pro2-card">
                    <h4>Restaurant Expansion</h4>
                    <p>Launched a multi-cuisine restaurant serving premium dining experiences.</p>
                </div>
            </div>

            <div class="pro2-item">
                <div class="pro2-year">2016</div>
                <div class="pro2-card">
                    <h4>Stylish Bar</h4>
                    <p>Opened an elegant bar offering curated beverages and a sophisticated setting.</p>
                </div>
            </div>

            <div class="pro2-item">
                <div class="pro2-year">2019</div>
                <div class="pro2-card">
                    <h4>Facilities Upgrade</h4>
                    <p>Enhanced rooms and amenities to elevate guest comfort and satisfaction.</p>
                </div>
            </div>

            <div class="pro2-item">
                <div class="pro2-year">2023</div>
                <div class="pro2-card">
                    <h4>Modern Renovation</h4>
                    <p>Upgraded interiors and improved service workflows for a modern guest experience.</p>
                </div>
            </div>

            <div class="pro2-item">
                <div class="pro2-year">2025</div>
                <div class="pro2-card">
                    <h4>Excellence & Growth</h4>
                    <p>Continues to grow as a preferred stay and dining destination.</p>
                </div>
            </div>

        </div>

    </div>
</div>
<style>
    .pro2-timeline {
    position: relative;
    max-width: 750px;
    margin: 0 auto;
    padding: 20px 0;
}

.pro2-timeline::before {
    content: '';
    position: absolute;
    left: 50%;
    top: 0;
    width: 3px;
    height: 100%;
    background: #e5e5e5;
    transform: translateX(-50%);
}

.pro2-item {
    position: relative;
    margin: 50px 0;
    text-align: center;
}

.pro2-year {
    position: relative;
    background: #0d6efd;
    color: #fff;
    display: inline-block;
    padding: 10px 25px;
    border-radius: 30px;
    font-size: 18px;
    font-weight: 600;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 2;
}

.pro2-card {
    background: #fff;
    margin-top: 25px;
    padding: 25px;
    border-radius: 14px;
    width: 90%;
    margin-left: auto;
    margin-right: auto;
    box-shadow: 0 6px 25px rgba(0,0,0,0.06);
    border-left: 5px solid #0d6efd;
    transition: 0.3s ease;
}

.pro2-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 35px rgba(0,0,0,0.12);
}

.pro2-card h4 {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 8px;
}

.pro2-card p {
    margin: 0;
    font-size: 15px;
    color: #555;
}

</style> -->
        <!-- About End -->

        <!-- Testimonial Start -->
        
                <?php include('testimonialshort.php'); ?>
            <br>
        <!-- Testimonial End -->

        <!-- Team Start -->
        <!-- <div class="container-xxl py-5">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Our Team</h6>
                    <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Staffs</span></h1>
                </div>
                <div class="row g-4">
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-1.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-2.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-3.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.7s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-4.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <!-- Team End -->


        <!-- Newsletter Start -->
        <!-- <div class="container newsletter mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="row justify-content-center">
                <div class="col-lg-10 border rounded p-1">
                    <div class="border rounded text-center p-1">
                        <div class="bg-white rounded text-center p-5">
                            <h4 class="mb-4">Subscribe Our <span class="text-primary text-uppercase">Newsletter</span></h4>
                            <div class="position-relative mx-auto" style="max-width: 400px;">
                                <input class="form-control w-100 py-3 ps-4 pe-5" type="text" placeholder="Enter your email">
                                <button type="button" class="btn btn-primary py-2 px-3 position-absolute top-0 end-0 mt-2 me-2">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <!-- Newsletter Start -->
        

        <!-- Footer Start -->
        <?php include('footer.php'); ?>
</body>

</html>